/*
 * Decompiled with CFR 0.152.
 */
package com.rodiontsev.maven.plugins.buildinfo.providers;

import com.rodiontsev.maven.plugins.buildinfo.BuildInfoMojo;
import com.rodiontsev.maven.plugins.buildinfo.providers.AbstractVcsInfoProvider;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.info.InfoItem;
import org.apache.maven.scm.command.info.InfoScmResult;
import org.apache.maven.scm.log.DefaultLog;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.svn.command.SvnCommand;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.scm.provider.svn.svnexe.SvnExeScmProvider;

public class SubversionInfoProvider
extends AbstractVcsInfoProvider {
    private static final String DOT_SVN = ".svn";

    @Override
    protected boolean isActive(MavenProject project, BuildInfoMojo mojo) {
        return this.isDirectoryExists(project, DOT_SVN);
    }

    @Override
    protected Map<String, String> getScmInfo(MavenProject project, BuildInfoMojo mojo) {
        InfoScmResult infoResult;
        block6: {
            File basedir = project.getBasedir();
            DefaultLog logger = new DefaultLog();
            ScmFileSet fileSet = new ScmFileSet(basedir);
            SvnCommand infoCommand = new SvnExeScmProvider().getInfoCommand();
            infoCommand.setLogger((ScmLogger)logger);
            infoResult = null;
            try {
                SvnScmProviderRepository repository = new SvnScmProviderRepository(basedir.getAbsolutePath());
                CommandParameters parameters = new CommandParameters();
                infoResult = (InfoScmResult)infoCommand.execute((ScmProviderRepository)repository, fileSet, parameters);
            }
            catch (ScmException e) {
                if (!logger.isErrorEnabled()) break block6;
                logger.error(e.getMessage());
            }
        }
        LinkedHashMap<String, String> info = new LinkedHashMap<String, String>();
        if (infoResult != null) {
            if (infoResult.isSuccess()) {
                List items = infoResult.getInfoItems();
                if (items != null && items.size() == 1) {
                    InfoItem item = (InfoItem)items.get(0);
                    info.put("svn.url", item.getURL());
                    info.put("svn.revision", item.getRevision());
                    info.put("svn.last.changed.author", item.getLastChangedAuthor());
                    info.put("svn.last.changed.revision", item.getLastChangedRevision());
                    info.put("svn.last.changed.date", item.getLastChangedDate());
                }
            } else {
                info.put("svn.info.error", infoResult.getProviderMessage());
            }
        }
        return info;
    }
}

