/*
 * Decompiled with CFR 0.152.
 */
package com.rodiontsev.maven.plugins.buildinfo.providers;

import com.rodiontsev.maven.plugins.buildinfo.BuildInfoMojo;
import com.rodiontsev.maven.plugins.buildinfo.InfoProvider;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.project.MavenProject;

public class BuildTimeProvider
implements InfoProvider {
    @Override
    public Map<String, String> getInfo(MavenProject project, BuildInfoMojo mojo) {
        LinkedHashMap<String, String> info = new LinkedHashMap<String, String>();
        String dateTimePattern = mojo.getDateTimePattern();
        if (StringUtils.isNotBlank((String)dateTimePattern)) {
            String buildTime;
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat(dateTimePattern, Locale.ENGLISH);
                buildTime = dateFormat.format(new Date());
            }
            catch (IllegalArgumentException e) {
                buildTime = "the given pattern is invalid";
                mojo.getLog().warn((CharSequence)String.format("The given date-time pattern '%s' is invalid. Please read %s javadoc about user-defined patterns for date-time formatting.", dateTimePattern, SimpleDateFormat.class.getCanonicalName()));
            }
            info.put("build.time", buildTime);
        }
        return info;
    }
}

