/*
 * Decompiled with CFR 0.152.
 */
package com.rodiontsev.maven.plugins.buildinfo;

import com.rodiontsev.maven.plugins.buildinfo.InfoProvider;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public class BuildInfoMojo
extends AbstractMojo {
    private MavenProject project;
    private String filename;
    private List<String> projectProperties;
    private List<String> systemProperties;
    private List<String> environmentVariables;
    private String dateTimePattern;
    private boolean includeVcsInfo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (InfoProvider provider : ServiceLoader.load(InfoProvider.class)) {
            map.putAll(provider.getInfo(this.project, this));
        }
        File buildDir = new File(this.project.getBuild().getDirectory());
        File file = new File(buildDir, this.filename);
        BufferedWriter out = null;
        try {
            boolean buildDirectoryCreated;
            if (!buildDir.exists() && (buildDirectoryCreated = buildDir.mkdir())) {
                this.getLog().info((CharSequence)"The build directory was created");
            }
            boolean infoFileCreated = file.createNewFile();
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            for (Map.Entry entry : map.entrySet()) {
                out.write((String)entry.getKey());
                out.write(" = ");
                out.write((String)entry.getValue());
                out.write("\n");
            }
            ((Writer)out).flush();
            this.getLog().info((CharSequence)(infoFileCreated ? "Created " : "Overwrote " + file.getAbsolutePath()));
            IOUtils.closeQuietly((Writer)out);
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)e.getMessage());
        }
        finally {
            IOUtils.closeQuietly(out);
        }
    }

    public List<String> getProjectProperties() {
        return this.projectProperties;
    }

    public List<String> getSystemProperties() {
        return this.systemProperties;
    }

    public List<String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public String getDateTimePattern() {
        return this.dateTimePattern;
    }

    public boolean isIncludeVcsInfo() {
        return this.includeVcsInfo;
    }
}

