/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.eventhubs.client.example;

import com.microsoft.eventhubs.client.ConnectionStringBuilder;
import com.microsoft.eventhubs.client.EventHubEnqueueTimeFilter;
import com.microsoft.eventhubs.client.EventHubException;
import com.microsoft.eventhubs.client.EventHubMessage;
import com.microsoft.eventhubs.client.ResilientEventHubReceiver;

public class ResilientEventHubReceiveClient {
    public static void main(String[] args) {
        if (args == null || args.length < 5) {
            System.out.println("Usage: ReceiveClient <policyName> <policyKey> <namespace> <name> <partitionId> [timeFilterDiff]");
            return;
        }
        String policyName = args[0];
        String policyKey = args[1];
        String namespace = args[2];
        String name = args[3];
        String partitionId = args[4];
        long enqueueTime = 0L;
        if (args.length >= 6) {
            long enqueueTimeDiff = Integer.parseInt(args[5]);
            enqueueTime = System.currentTimeMillis() - enqueueTimeDiff * 1000L;
        }
        String connectionString = new ConnectionStringBuilder(policyName, policyKey, namespace).getConnectionString();
        EventHubEnqueueTimeFilter filter = null;
        if (enqueueTime != 0L) {
            filter = new EventHubEnqueueTimeFilter(enqueueTime);
        }
        ResilientEventHubReceiver receiver = new ResilientEventHubReceiver(connectionString, name, partitionId, null, -1, filter);
        try {
            receiver.initialize();
        }
        catch (EventHubException e) {
            System.out.println("Exception: " + e.getMessage());
            return;
        }
        while (true) {
            EventHubMessage message;
            if ((message = EventHubMessage.parseAmqpMessage(receiver.receive(5000L))) == null) {
                continue;
            }
            System.out.println("Received: (" + message.getOffset() + " | " + message.getSequence() + " | " + message.getEnqueuedTimestamp() + ") => " + message.getDataAsString());
        }
    }
}

