/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.eventhubs.client.example;

import com.microsoft.eventhubs.client.EventHubClient;
import com.microsoft.eventhubs.client.EventHubException;
import com.microsoft.eventhubs.client.EventHubSender;

public class EventHubSendClient {
    public static void main(String[] args) {
        if (args == null || args.length < 7) {
            System.out.println("Usage: SendClient <policyName> <policyKey> <namespace> <name> <partitionId> <messageSize> <messageCount>");
            return;
        }
        String policyName = args[0];
        String policyKey = args[1];
        String namespace = args[2];
        String name = args[3];
        String partitionId = args[4];
        int messageSize = Integer.parseInt(args[5]);
        int messageCount = Integer.parseInt(args[6]);
        assert (messageSize > 0);
        assert (messageCount > 0);
        if (partitionId.equals("-1")) {
            partitionId = null;
        }
        try {
            EventHubClient client = EventHubClient.create(policyName, policyKey, namespace, name);
            EventHubSender sender = client.createPartitionSender(partitionId);
            StringBuilder sb = new StringBuilder(messageSize);
            for (int i = 1; i < messageCount + 1; ++i) {
                while (sb.length() < messageSize) {
                    sb.append(" current message: " + i);
                }
                sb.setLength(messageSize);
                sender.send(sb.toString());
                sb.setLength(0);
                if (i % 1000 != 0) continue;
                System.out.println("Number of messages sent: " + i);
            }
            System.out.println("Total Number of messages sent: " + messageCount);
        }
        catch (EventHubException e) {
            System.out.println("Exception: " + e.getMessage());
        }
        System.out.println("done");
    }
}

