/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.eventhubs.client;

import com.microsoft.eventhubs.client.EventHubException;
import com.microsoft.eventhubs.client.EventHubOffsetFilter;
import com.microsoft.eventhubs.client.EventHubReceiver;
import com.microsoft.eventhubs.client.IEventHubFilter;
import org.apache.qpid.amqp_1_0.client.Connection;
import org.apache.qpid.amqp_1_0.client.ConnectionException;
import org.apache.qpid.amqp_1_0.client.Session;

public class EventHubConsumerGroup {
    private final Connection connection;
    private final String entityPath;
    private final String consumerGroupName;
    private Session session;

    public EventHubConsumerGroup(Connection connection, String entityPath, String consumerGroupName) {
        this.connection = connection;
        this.entityPath = entityPath;
        this.consumerGroupName = consumerGroupName;
    }

    public EventHubReceiver createReceiver(String partitionId, IEventHubFilter filter, int defaultCredits) throws EventHubException {
        this.ensureSessionCreated();
        if (filter == null) {
            filter = new EventHubOffsetFilter("-1");
        }
        if (defaultCredits < 0) {
            defaultCredits = 1024;
        }
        return new EventHubReceiver(this.session, this.entityPath, this.consumerGroupName, partitionId, filter.getFilterString(), defaultCredits);
    }

    public void close() {
        if (this.session != null) {
            this.session.close();
        }
    }

    synchronized void ensureSessionCreated() throws EventHubException {
        try {
            if (this.session == null) {
                this.session = this.connection.createSession();
            }
        }
        catch (ConnectionException e) {
            throw new EventHubException(e);
        }
    }
}

