/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.eventhubs.client;

import com.microsoft.eventhubs.client.ConnectionStringBuilder;
import com.microsoft.eventhubs.client.ConnectionStringParser;
import com.microsoft.eventhubs.client.EventHubConsumerGroup;
import com.microsoft.eventhubs.client.EventHubException;
import com.microsoft.eventhubs.client.EventHubSender;
import com.microsoft.eventhubs.client.SelectorFilterWriter;
import org.apache.qpid.amqp_1_0.client.Connection;
import org.apache.qpid.amqp_1_0.client.ConnectionErrorException;
import org.apache.qpid.amqp_1_0.client.ConnectionException;
import org.apache.qpid.amqp_1_0.codec.ValueWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventHubClient {
    private static final Logger logger = LoggerFactory.getLogger(EventHubClient.class);
    private final String connectionString;
    private final String entityPath;
    private final Connection connection;

    private EventHubClient(String connectionString, String entityPath) throws EventHubException {
        this.connectionString = connectionString;
        this.entityPath = entityPath;
        this.connection = this.createConnection();
    }

    public static EventHubClient create(String connectionString, String name) throws EventHubException {
        return new EventHubClient(connectionString, name);
    }

    public static EventHubClient create(String policyName, String policyKey, String namespace, String name) throws EventHubException {
        String connectionString = new ConnectionStringBuilder(policyName, policyKey, namespace).getConnectionString();
        return new EventHubClient(connectionString, name);
    }

    public EventHubSender createPartitionSender(String partitionId) throws EventHubException {
        try {
            return new EventHubSender(this.connection.createSession(), this.entityPath, partitionId);
        }
        catch (ConnectionException e) {
            throw new EventHubException(e);
        }
    }

    public EventHubConsumerGroup getConsumerGroup(String cgName) {
        if (cgName == null || cgName.length() == 0) {
            cgName = "$default";
        }
        return new EventHubConsumerGroup(this.connection, this.entityPath, cgName);
    }

    public void close() {
        try {
            this.connection.close();
        }
        catch (ConnectionErrorException e) {
            logger.error(e.toString());
        }
    }

    private Connection createConnection() throws EventHubException {
        Connection clientConnection;
        ConnectionStringParser ConnectionStringParser2 = new ConnectionStringParser(this.connectionString);
        try {
            clientConnection = new Connection(ConnectionStringParser2.getHost(), ConnectionStringParser2.getPort(), ConnectionStringParser2.getPolicyName(), ConnectionStringParser2.getPolicyKey(), ConnectionStringParser2.getHost(), ConnectionStringParser2.getSsl());
        }
        catch (ConnectionException e) {
            throw new EventHubException(e);
        }
        clientConnection.getEndpoint().setSyncTimeout(60000L);
        SelectorFilterWriter.register((ValueWriter.Registry)clientConnection.getEndpoint().getDescribedTypeRegistry());
        return clientConnection;
    }
}

