/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.eventhubs.client;

import com.microsoft.eventhubs.client.EventHubException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLStreamHandler;

public class ConnectionStringParser {
    private final String connectionString;
    private String host;
    private int port;
    private String policyName = "";
    private String policyKey = "";
    private boolean ssl;

    public ConnectionStringParser(String connectionString) throws EventHubException {
        this.connectionString = connectionString;
        this.initialize();
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPolicyName() {
        return this.policyName;
    }

    public String getPolicyKey() {
        return this.policyKey;
    }

    public boolean getSsl() {
        return this.ssl;
    }

    private void initialize() throws EventHubException {
        String userInfo;
        URL url;
        try {
            url = new URL(null, this.connectionString, new NullURLStreamHandler());
        }
        catch (MalformedURLException e) {
            throw new EventHubException("connectionString is not valid.", e);
        }
        String protocol = url.getProtocol();
        if (!protocol.startsWith("amqp")) {
            throw new EventHubException("invalid scheme in connectionString");
        }
        this.ssl = protocol.equalsIgnoreCase("amqps");
        this.host = url.getHost();
        this.port = url.getPort();
        if (this.port == -1) {
            int n = this.port = this.ssl ? 5671 : 5672;
        }
        if ((userInfo = url.getUserInfo()) != null) {
            String[] credentials = userInfo.split(":", 2);
            if (credentials.length != 2) {
                throw new EventHubException("connectionString does not contain policy info.");
            }
            try {
                this.policyName = URLDecoder.decode(credentials[0], "UTF-8");
                this.policyKey = URLDecoder.decode(credentials[1], "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new EventHubException(ex);
            }
        }
        if (this.policyName.length() == 0 || this.policyKey.length() == 0) {
            throw new EventHubException("invalid userInfo in connectionString");
        }
    }

    class NullURLStreamHandler
    extends URLStreamHandler {
        NullURLStreamHandler() {
        }

        protected URLConnection openConnection(URL u) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

