/*
 * Copyright 2006 Robert Burrell Donkin
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ 
package rat.report.claim.util;

import rat.report.RatReportFailedException;
import rat.report.claim.IClaimReporter;

public class ClaimReporterMultiplexer implements IClaimReporter {

    private final IClaimReporter[] reporters;
        
    public ClaimReporterMultiplexer(final IClaimReporter[] reporters) {
        super();
        this.reporters = reporters;
    }

    public void claim(CharSequence subject, CharSequence predicate,
            CharSequence object, boolean isLiteral)
            throws RatReportFailedException {
        final int length = reporters.length;
        for (int i=0;i<length;i++) {
            reporters[i].claim(subject, predicate, object, isLiteral);
        }
    }

}
