/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.ForwardingIterator;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ForwardingMapEntry;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StandardBiMap<K, V>
extends ForwardingMap<K, V>
implements BiMap<K, V> {
    private StandardBiMap<V, K> inverse;
    private volatile transient Set<K> keySet;
    private volatile transient Set<V> valueSet;
    private volatile transient Set<Map.Entry<K, V>> entrySet;
    private static final long serialVersionUID = 4530707788347682991L;

    StandardBiMap(Map<K, V> forward, Map<V, K> backward) {
        super(forward);
        Preconditions.checkArgument(forward.isEmpty());
        Preconditions.checkArgument(backward.isEmpty());
        this.inverse = new StandardBiMap<K, V>(backward, this);
    }

    private StandardBiMap(Map<K, V> backward, StandardBiMap<V, K> forward) {
        super(backward);
        this.inverse = forward;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.inverse.containsKey(value);
    }

    @Override
    public V put(K key, V value) {
        return this.putInBothMaps(key, value, false);
    }

    @Override
    public V forcePut(K key, V value) {
        return this.putInBothMaps(key, value, true);
    }

    private V putInBothMaps(K key, V value, boolean force) {
        boolean containedKey = this.containsKey(key);
        if (containedKey && Objects.equal(value, this.get(key))) {
            return value;
        }
        if (force) {
            this.inverse().remove(value);
        } else {
            Preconditions.checkArgument(!this.containsValue(value), "value already present: %s", value);
        }
        V oldValue = super.put(key, value);
        this.updateInverseMap(key, containedKey, oldValue, value);
        return oldValue;
    }

    private void updateInverseMap(K key, boolean containedKey, V oldValue, V newValue) {
        if (containedKey) {
            this.removeFromInverseMap(oldValue);
        }
        this.inverse.delegate().put(newValue, key);
    }

    @Override
    public V remove(Object key) {
        return this.containsKey(key) ? (V)this.removeFromBothMaps(key) : null;
    }

    private V removeFromBothMaps(Object key) {
        Object oldValue = super.remove(key);
        this.removeFromInverseMap(oldValue);
        return oldValue;
    }

    private void removeFromInverseMap(V oldValue) {
        this.inverse.delegate().remove(oldValue);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.inverse.delegate().clear();
    }

    @Override
    public BiMap<V, K> inverse() {
        return this.inverse;
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet(super.keySet());
        }
        return this.keySet;
    }

    @Override
    public Set<V> values() {
        if (this.valueSet == null) {
            this.valueSet = new ValueSet(this.inverse.keySet());
        }
        return this.valueSet;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet(super.entrySet());
        }
        return this.entrySet;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntrySet
    extends ForwardingSet<Map.Entry<K, V>> {
        EntrySet(Set<Map.Entry<K, V>> entrySet) {
            super(entrySet);
        }

        @Override
        public void clear() {
            StandardBiMap.this.clear();
        }

        @Override
        public boolean remove(Object object) {
            if (!super.remove(object)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            StandardBiMap.this.inverse.delegate().remove(entry.getValue());
            return true;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new ForwardingIterator<Map.Entry<K, V>>(super.iterator()){
                Map.Entry<K, V> entry;

                @Override
                public Map.Entry<K, V> next() {
                    this.entry = (Map.Entry)super.next();
                    return new ForwardingMapEntry<K, V>(this.entry){

                        @Override
                        public V setValue(V value) {
                            if (Objects.equal(value, this.getValue())) {
                                return value;
                            }
                            Preconditions.checkArgument(!StandardBiMap.this.containsValue(value), "value already present: %s", value);
                            Object oldValue = super.setValue(value);
                            StandardBiMap.this.updateInverseMap(this.getKey(), true, oldValue, value);
                            return oldValue;
                        }
                    };
                }

                @Override
                public void remove() {
                    super.remove();
                    StandardBiMap.this.removeFromInverseMap(this.entry.getValue());
                }
            };
        }

        @Override
        public Object[] toArray() {
            return EntrySet.toArrayImpl(this);
        }

        @Override
        public <T> T[] toArray(T[] array) {
            return EntrySet.toArrayImpl(this, array);
        }

        @Override
        public boolean contains(Object o) {
            return Maps.containsEntryImpl(this.delegate(), o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return EntrySet.containsAllImpl(this, c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return EntrySet.removeAllImpl(this, c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return EntrySet.retainAllImpl(this, c);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValueSet
    extends ForwardingSet<V> {
        ValueSet(Set<V> values) {
            super(values);
        }

        @Override
        public Iterator<V> iterator() {
            Iterator iterator = StandardBiMap.super.values().iterator();
            return new ForwardingIterator<V>(iterator){
                V valueToRemove;

                @Override
                public V next() {
                    this.valueToRemove = super.next();
                    return this.valueToRemove;
                }

                @Override
                public void remove() {
                    super.remove();
                    StandardBiMap.this.removeFromInverseMap(this.valueToRemove);
                }
            };
        }

        @Override
        public Object[] toArray() {
            return ValueSet.toArrayImpl(this);
        }

        @Override
        public <T> T[] toArray(T[] array) {
            return ValueSet.toArrayImpl(this, array);
        }

        @Override
        public String toString() {
            return ValueSet.toStringImpl(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    extends ForwardingSet<K> {
        KeySet(Set<K> keySet) {
            super(keySet);
        }

        @Override
        public void clear() {
            StandardBiMap.this.clear();
        }

        @Override
        public boolean remove(Object key) {
            if (!this.contains(key)) {
                return false;
            }
            StandardBiMap.this.removeFromBothMaps(key);
            return true;
        }

        @Override
        public boolean removeAll(Collection<?> keysToRemove) {
            return KeySet.removeAllImpl(this, keysToRemove);
        }

        @Override
        public boolean retainAll(Collection<?> keysToRetain) {
            return KeySet.retainAllImpl(this, keysToRetain);
        }

        @Override
        public Iterator<K> iterator() {
            final Iterator iterator = StandardBiMap.super.entrySet().iterator();
            return new Iterator<K>(){
                Map.Entry<K, V> entry;

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public K next() {
                    this.entry = (Map.Entry)iterator.next();
                    return this.entry.getKey();
                }

                @Override
                public void remove() {
                    iterator.remove();
                    StandardBiMap.this.removeFromInverseMap(this.entry.getValue());
                }
            };
        }
    }
}

