/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractMapBasedMultiset;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multiset;
import com.google.common.collect.MultisetSerializedForm;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.util.EnumMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EnumMultiset<E extends Enum<E>>
extends AbstractMapBasedMultiset<E> {
    private final Class<E> type;

    public EnumMultiset(Class<E> type) {
        super(new EnumMap(type));
        this.type = type;
    }

    public EnumMultiset(Iterable<E> elements) {
        this(EnumMultiset.findClass(elements));
        Iterables.addAll(this, elements);
    }

    private static <E extends Enum<E>> Class<E> findClass(Iterable<E> elements) {
        Iterator<E> iterator = elements.iterator();
        Preconditions.checkArgument(iterator.hasNext(), "EnumMultiset constructor passed empty Iterable");
        return ((Enum)iterator.next()).getDeclaringClass();
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Use SerializedForm");
    }

    private Object writeReplace() {
        return new SerializedForm(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SerializedForm<E extends Enum<E>>
    extends MultisetSerializedForm<E> {
        private final Class<E> type;
        private static final long serialVersionUID = 0L;

        SerializedForm(EnumMultiset<E> multiset) {
            super(multiset);
            this.type = ((EnumMultiset)multiset).type;
        }

        @Override
        protected Multiset<E> createEmpty() {
            return new EnumMultiset<E>(this.type);
        }
    }
}

