/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.randomizedtesting;

import com.carrotsearch.randomizedtesting.RandomizedContext;
import com.carrotsearch.randomizedtesting.RandomizedRunner;
import com.carrotsearch.randomizedtesting.RuntimeTestGroup;
import com.carrotsearch.randomizedtesting.SysGlobals;
import java.util.Arrays;
import org.junit.runner.Description;

public class ReproduceErrorMessageBuilder {
    private final StringBuilder b;

    public ReproduceErrorMessageBuilder() {
        this(new StringBuilder());
    }

    public ReproduceErrorMessageBuilder(StringBuilder builder) {
        this.b = builder;
    }

    public ReproduceErrorMessageBuilder appendAllOpts(Description description) {
        RandomizedContext ctx = null;
        try {
            ctx = RandomizedContext.current();
            this.appendOpt(SysGlobals.SYSPROP_RANDOM_SEED(), ctx.getRunnerSeedAsString());
        }
        catch (IllegalStateException e) {
            RandomizedRunner.logger.warning("No context available when dumping reproduce options?");
        }
        if (description.getClassName() != null) {
            this.appendOpt(SysGlobals.SYSPROP_TESTCLASS(), description.getClassName());
        }
        if (description.getMethodName() != null) {
            this.appendOpt(SysGlobals.SYSPROP_TESTMETHOD(), RandomizedRunner.methodName(description));
        }
        this.appendRunnerProperties();
        this.appendTestGroupOptions(ctx);
        this.appendEnvironmentSettings();
        return this;
    }

    public ReproduceErrorMessageBuilder appendEnvironmentSettings() {
        for (String sysPropName : Arrays.asList("file.encoding", "user.timezone")) {
            if (RandomizedRunner.emptyToNull(System.getProperty(sysPropName)) == null) continue;
            this.appendOpt(sysPropName, System.getProperty(sysPropName));
        }
        return this;
    }

    public ReproduceErrorMessageBuilder appendTestGroupOptions(RandomizedContext ctx) {
        if (ctx != null) {
            for (RuntimeTestGroup g : ctx.getTestGroups().values()) {
                String sysPropName = g.getSysPropertyName();
                if (System.getProperty(sysPropName) == null) continue;
                this.appendOpt(sysPropName, System.getProperty(sysPropName));
            }
        }
        return this;
    }

    public ReproduceErrorMessageBuilder appendRunnerProperties() {
        this.appendOpt(SysGlobals.SYSPROP_PREFIX(), SysGlobals.CURRENT_PREFIX());
        for (String sysPropName : Arrays.asList(SysGlobals.SYSPROP_STACKFILTERING(), SysGlobals.SYSPROP_ITERATIONS(), SysGlobals.SYSPROP_KILLATTEMPTS(), SysGlobals.SYSPROP_KILLWAIT(), SysGlobals.SYSPROP_TIMEOUT())) {
            if (System.getProperty(sysPropName) == null) continue;
            this.appendOpt(sysPropName, System.getProperty(sysPropName));
        }
        return this;
    }

    public ReproduceErrorMessageBuilder appendOpt(String sysPropName, String value) {
        if (this.b.length() > 0) {
            this.b.append(" ");
        }
        this.b.append("-D").append(sysPropName).append("=").append(value);
        return this;
    }
}

