/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.AbstractFuture$Sync;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.ExecutionList;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public abstract class AbstractFuture
implements ListenableFuture {
    private final AbstractFuture$Sync sync = new AbstractFuture$Sync();
    private final ExecutionList executionList = new ExecutionList();

    protected AbstractFuture() {
    }

    public Object get(long l, TimeUnit timeUnit) {
        return this.sync.get(timeUnit.toNanos(l));
    }

    public Object get() {
        return this.sync.get();
    }

    @Override
    public boolean isDone() {
        return this.sync.isDone();
    }

    @Override
    public boolean isCancelled() {
        return this.sync.isCancelled();
    }

    @Override
    public boolean cancel(boolean bl) {
        if (!this.sync.cancel(bl)) {
            return false;
        }
        this.executionList.execute();
        if (bl) {
            this.interruptTask();
        }
        return true;
    }

    protected void interruptTask() {
    }

    protected final boolean wasInterrupted() {
        return this.sync.wasInterrupted();
    }

    @Override
    public void addListener(Runnable runnable, Executor executor) {
        this.executionList.add(runnable, executor);
    }

    protected boolean set(@Nullable Object object) {
        boolean bl = this.sync.set(object);
        if (bl) {
            this.executionList.execute();
        }
        return bl;
    }

    protected boolean setException(Throwable throwable) {
        boolean bl = this.sync.setException((Throwable)Preconditions.checkNotNull(throwable));
        if (bl) {
            this.executionList.execute();
        }
        return bl;
    }

    static final CancellationException cancellationExceptionWithCause(@Nullable String string, @Nullable Throwable throwable) {
        CancellationException cancellationException = new CancellationException(string);
        cancellationException.initCause(throwable);
        return cancellationException;
    }
}

