/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.listeners.json;

import com.carrotsearch.ant.tasks.junit4.ForkedJvmInfo;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.JsonArray;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.JsonElement;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.JsonObject;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.JsonSerializationContext;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.JsonSerializer;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.apache.commons.io.output.WriterOutputStream;
import com.carrotsearch.ant.tasks.junit4.events.EventType;
import com.carrotsearch.ant.tasks.junit4.events.FailureEvent;
import com.carrotsearch.ant.tasks.junit4.events.IDescribable;
import com.carrotsearch.ant.tasks.junit4.events.IEvent;
import com.carrotsearch.ant.tasks.junit4.events.IStreamEvent;
import com.carrotsearch.ant.tasks.junit4.events.aggregated.AggregatedSuiteResultEvent;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.Date;

public class JsonAggregatedSuiteResultEventAdapter
implements JsonSerializer {
    private final boolean outputStreams;

    public JsonAggregatedSuiteResultEventAdapter(boolean bl) {
        this.outputStreams = bl;
    }

    public JsonElement serialize(AggregatedSuiteResultEvent aggregatedSuiteResultEvent, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("slave", aggregatedSuiteResultEvent.getSlave().id);
        jsonObject.addProperty("startTimestamp", aggregatedSuiteResultEvent.getStartTimestamp());
        jsonObject.add("startTimestampDate", jsonSerializationContext.serialize(new Date(aggregatedSuiteResultEvent.getStartTimestamp())));
        jsonObject.addProperty("executionTime", aggregatedSuiteResultEvent.getExecutionTime());
        jsonObject.add("description", jsonSerializationContext.serialize(aggregatedSuiteResultEvent.getDescription()));
        jsonObject.add("tests", jsonSerializationContext.serialize(aggregatedSuiteResultEvent.getTests()));
        jsonObject.add("suiteFailures", jsonSerializationContext.serialize(aggregatedSuiteResultEvent.getFailures()));
        jsonObject.add("executionEvents", this.serializeEvents(aggregatedSuiteResultEvent, jsonSerializationContext));
        return jsonObject;
    }

    public JsonArray serializeEvents(AggregatedSuiteResultEvent aggregatedSuiteResultEvent, JsonSerializationContext jsonSerializationContext) {
        JsonArray jsonArray = new JsonArray();
        ForkedJvmInfo forkedJvmInfo = aggregatedSuiteResultEvent.getSlave();
        int n = 160;
        StringWriter stringWriter = new StringWriter();
        StringWriter stringWriter2 = new StringWriter();
        WriterOutputStream writerOutputStream = new WriterOutputStream((Writer)stringWriter, forkedJvmInfo.getCharset(), n, false);
        WriterOutputStream writerOutputStream2 = new WriterOutputStream((Writer)stringWriter2, forkedJvmInfo.getCharset(), n, false);
        for (IEvent iEvent : aggregatedSuiteResultEvent.getEventStream()) {
            try {
                switch (iEvent.getType()) {
                    case SUITE_FAILURE: 
                    case TEST_IGNORED_ASSUMPTION: 
                    case TEST_IGNORED: 
                    case TEST_STARTED: 
                    case TEST_FINISHED: 
                    case TEST_FAILURE: {
                        this.flushBoth(jsonArray, stringWriter, stringWriter2, writerOutputStream, writerOutputStream2);
                        JsonObject jsonObject = new JsonObject();
                        jsonObject.addProperty("event", iEvent.getType().toString());
                        jsonObject.add("description", jsonSerializationContext.serialize(((IDescribable)((Object)iEvent)).getDescription()));
                        if (iEvent instanceof FailureEvent) {
                            jsonObject.add("failure", jsonSerializationContext.serialize(((FailureEvent)iEvent).getFailure()));
                        }
                        jsonArray.add(jsonObject);
                        break;
                    }
                    case APPEND_STDOUT: {
                        if (!this.outputStreams) break;
                        this.flush(EventType.APPEND_STDERR, jsonArray, writerOutputStream2, stringWriter2);
                        ((IStreamEvent)((Object)iEvent)).copyTo(writerOutputStream);
                        break;
                    }
                    case APPEND_STDERR: {
                        if (!this.outputStreams) break;
                        this.flush(EventType.APPEND_STDOUT, jsonArray, writerOutputStream, stringWriter);
                        ((IStreamEvent)((Object)iEvent)).copyTo(writerOutputStream2);
                        break;
                    }
                }
            }
            catch (IOException iOException) {}
        }
        this.flushBoth(jsonArray, stringWriter, stringWriter2, writerOutputStream, writerOutputStream2);
        return jsonArray;
    }

    public void flushBoth(JsonArray jsonArray, StringWriter stringWriter, StringWriter stringWriter2, WriterOutputStream writerOutputStream, WriterOutputStream writerOutputStream2) {
        try {
            this.flush(EventType.APPEND_STDOUT, jsonArray, writerOutputStream, stringWriter);
            this.flush(EventType.APPEND_STDERR, jsonArray, writerOutputStream2, stringWriter2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void flush(EventType eventType, JsonArray jsonArray, WriterOutputStream writerOutputStream, StringWriter stringWriter) {
        writerOutputStream.flush();
        if (stringWriter.getBuffer().length() > 0) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("event", eventType.toString());
            jsonObject.addProperty("content", stringWriter.getBuffer().toString());
            stringWriter.getBuffer().setLength(0);
            jsonArray.add(jsonObject);
        }
    }
}

