/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.ByteStreams$1;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.ByteStreams$FastByteArrayOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public final class ByteStreams {
    private static final OutputStream NULL_OUTPUT_STREAM = new ByteStreams$1();

    public static long copy(InputStream inputStream, OutputStream outputStream) {
        int n;
        Preconditions.checkNotNull(inputStream);
        Preconditions.checkNotNull(outputStream);
        byte[] byArray = new byte[4096];
        long l = 0L;
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    public static byte[] toByteArray(InputStream inputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteStreams.copy(inputStream, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    static byte[] toByteArray(InputStream inputStream, int n) {
        int n2;
        int n3;
        byte[] byArray = new byte[n];
        for (int i = n; i > 0; i -= n3) {
            n2 = n - i;
            n3 = inputStream.read(byArray, n2, i);
            if (n3 != -1) continue;
            return Arrays.copyOf(byArray, n2);
        }
        n2 = inputStream.read();
        if (n2 == -1) {
            return byArray;
        }
        ByteStreams$FastByteArrayOutputStream byteStreams$FastByteArrayOutputStream = new ByteStreams$FastByteArrayOutputStream(null);
        byteStreams$FastByteArrayOutputStream.write(n2);
        ByteStreams.copy(inputStream, byteStreams$FastByteArrayOutputStream);
        byte[] byArray2 = new byte[byArray.length + byteStreams$FastByteArrayOutputStream.size()];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        byteStreams$FastByteArrayOutputStream.writeTo(byArray2, byArray.length);
        return byArray2;
    }
}

