/*
 * Decompiled with CFR 0.152.
 */
package storm.kafka.trident;

import backtype.storm.task.IMetricsContext;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import storm.kafka.trident.TridentKafkaState;
import storm.kafka.trident.mapper.TridentTupleToKafkaMapper;
import storm.kafka.trident.selector.KafkaTopicSelector;
import storm.trident.state.State;
import storm.trident.state.StateFactory;

public class TridentKafkaStateFactory
implements StateFactory {
    private static final Logger LOG = LoggerFactory.getLogger(TridentKafkaStateFactory.class);
    private TridentTupleToKafkaMapper mapper;
    private KafkaTopicSelector topicSelector;
    private Properties producerProperties = new Properties();

    public TridentKafkaStateFactory withTridentTupleToKafkaMapper(TridentTupleToKafkaMapper mapper2) {
        this.mapper = mapper2;
        return this;
    }

    public TridentKafkaStateFactory withKafkaTopicSelector(KafkaTopicSelector selector) {
        this.topicSelector = selector;
        return this;
    }

    public TridentKafkaStateFactory withProducerProperties(Properties props) {
        this.producerProperties = props;
        return this;
    }

    public State makeState(Map conf, IMetricsContext metrics, int partitionIndex, int numPartitions) {
        LOG.info("makeState(partitonIndex={}, numpartitions={}", partitionIndex, (Object)numPartitions);
        TridentKafkaState state = new TridentKafkaState().withKafkaTopicSelector(this.topicSelector).withTridentTupleToKafkaMapper(this.mapper);
        state.prepare(this.producerProperties);
        return state;
    }
}

