/*
 * Decompiled with CFR 0.152.
 */
package storm.kafka.trident;

import backtype.storm.task.OutputCollector;
import backtype.storm.topology.FailedException;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.lang.Validate;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import storm.kafka.trident.mapper.TridentTupleToKafkaMapper;
import storm.kafka.trident.selector.KafkaTopicSelector;
import storm.trident.operation.TridentCollector;
import storm.trident.state.State;
import storm.trident.tuple.TridentTuple;

public class TridentKafkaState
implements State {
    private static final Logger LOG = LoggerFactory.getLogger(TridentKafkaState.class);
    private KafkaProducer producer;
    private OutputCollector collector;
    private TridentTupleToKafkaMapper mapper;
    private KafkaTopicSelector topicSelector;

    public TridentKafkaState withTridentTupleToKafkaMapper(TridentTupleToKafkaMapper mapper2) {
        this.mapper = mapper2;
        return this;
    }

    public TridentKafkaState withKafkaTopicSelector(KafkaTopicSelector selector) {
        this.topicSelector = selector;
        return this;
    }

    public void beginCommit(Long txid) {
        LOG.debug("beginCommit is Noop.");
    }

    public void commit(Long txid) {
        LOG.debug("commit is Noop.");
    }

    public void prepare(Properties options) {
        Validate.notNull(this.mapper, "mapper can not be null");
        Validate.notNull(this.topicSelector, "topicSelector can not be null");
        this.producer = new KafkaProducer(options);
    }

    public void updateState(List<TridentTuple> tuples, TridentCollector collector) {
        String topic = null;
        for (TridentTuple tuple : tuples) {
            try {
                topic = this.topicSelector.getTopic(tuple);
                if (topic != null) {
                    Future<RecordMetadata> result2 = this.producer.send(new ProducerRecord(topic, this.mapper.getKeyFromTuple(tuple), this.mapper.getMessageFromTuple(tuple)));
                    try {
                        result2.get();
                        continue;
                    }
                    catch (ExecutionException e) {
                        String errorMsg = "Could not retrieve result for message with key = " + this.mapper.getKeyFromTuple(tuple) + " from topic = " + topic;
                        LOG.error(errorMsg, e);
                        throw new FailedException(errorMsg, (Throwable)e);
                    }
                }
                LOG.warn("skipping key = " + this.mapper.getKeyFromTuple(tuple) + ", topic selector returned null.");
            }
            catch (Exception ex) {
                String errorMsg = "Could not send message with key = " + this.mapper.getKeyFromTuple(tuple) + " to topic = " + topic;
                LOG.warn(errorMsg, ex);
                throw new FailedException(errorMsg, (Throwable)ex);
            }
        }
    }
}

