/*
 * Decompiled with CFR 0.152.
 */
package storm.kafka.bolt;

import backtype.storm.task.OutputCollector;
import backtype.storm.task.TopologyContext;
import backtype.storm.topology.OutputFieldsDeclarer;
import backtype.storm.topology.base.BaseRichBolt;
import backtype.storm.tuple.Tuple;
import backtype.storm.utils.TupleUtils;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import storm.kafka.bolt.mapper.FieldNameBasedTupleToKafkaMapper;
import storm.kafka.bolt.mapper.TupleToKafkaMapper;
import storm.kafka.bolt.selector.DefaultTopicSelector;
import storm.kafka.bolt.selector.KafkaTopicSelector;

public class KafkaBolt<K, V>
extends BaseRichBolt {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaBolt.class);
    public static final String TOPIC = "topic";
    private KafkaProducer<K, V> producer;
    private OutputCollector collector;
    private TupleToKafkaMapper<K, V> mapper;
    private KafkaTopicSelector topicSelector;
    private Properties boltSpecfiedProperties = new Properties();
    private boolean fireAndForget = false;
    private boolean async = true;

    public KafkaBolt<K, V> withTupleToKafkaMapper(TupleToKafkaMapper<K, V> mapper2) {
        this.mapper = mapper2;
        return this;
    }

    public KafkaBolt<K, V> withTopicSelector(KafkaTopicSelector selector) {
        this.topicSelector = selector;
        return this;
    }

    public KafkaBolt<K, V> withProducerProperties(Properties producerProperties) {
        this.boltSpecfiedProperties = producerProperties;
        return this;
    }

    public void prepare(Map stormConf, TopologyContext context, OutputCollector collector) {
        if (this.mapper == null) {
            this.mapper = new FieldNameBasedTupleToKafkaMapper();
        }
        if (this.topicSelector == null) {
            this.topicSelector = new DefaultTopicSelector((String)stormConf.get(TOPIC));
        }
        this.producer = new KafkaProducer(this.boltSpecfiedProperties);
        this.collector = collector;
    }

    public void execute(final Tuple input2) {
        if (TupleUtils.isTick((Tuple)input2)) {
            this.collector.ack(input2);
            return;
        }
        Object key = null;
        Object message = null;
        String topic = null;
        try {
            key = this.mapper.getKeyFromTuple(input2);
            message = this.mapper.getMessageFromTuple(input2);
            topic = this.topicSelector.getTopic(input2);
            if (topic != null) {
                Callback callback = null;
                if (!this.fireAndForget && this.async) {
                    callback = new Callback(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void onCompletion(RecordMetadata ignored, Exception e) {
                            OutputCollector outputCollector = KafkaBolt.this.collector;
                            synchronized (outputCollector) {
                                if (e != null) {
                                    KafkaBolt.this.collector.reportError((Throwable)e);
                                    KafkaBolt.this.collector.fail(input2);
                                } else {
                                    KafkaBolt.this.collector.ack(input2);
                                }
                            }
                        }
                    };
                }
                Future<RecordMetadata> result2 = this.producer.send(new ProducerRecord<Object, Object>(topic, key, message), callback);
                if (!this.async) {
                    try {
                        result2.get();
                        this.collector.ack(input2);
                    }
                    catch (ExecutionException err2) {
                        this.collector.reportError((Throwable)err2);
                        this.collector.fail(input2);
                    }
                } else if (this.fireAndForget) {
                    this.collector.ack(input2);
                }
            } else {
                LOG.warn("skipping key = " + key + ", topic selector returned null.");
                this.collector.ack(input2);
            }
        }
        catch (Exception ex) {
            this.collector.reportError((Throwable)ex);
            this.collector.fail(input2);
        }
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
    }

    public void cleanup() {
        this.producer.close();
    }

    public void setFireAndForget(boolean fireAndForget) {
        this.fireAndForget = fireAndForget;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }
}

