/*
 * Decompiled with CFR 0.152.
 */
package storm.kafka;

import backtype.storm.spout.Scheme;
import backtype.storm.tuple.Fields;
import backtype.storm.tuple.Values;
import backtype.storm.utils.Utils;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class StringScheme
implements Scheme {
    private static final Charset UTF8_CHARSET = StandardCharsets.UTF_8;
    public static final String STRING_SCHEME_KEY = "str";

    public List<Object> deserialize(ByteBuffer bytes2) {
        return new Values(new Object[]{StringScheme.deserializeString(bytes2)});
    }

    public static String deserializeString(ByteBuffer string2) {
        if (string2.hasArray()) {
            int base = string2.arrayOffset();
            return new String(string2.array(), base + string2.position(), string2.remaining());
        }
        return new String(Utils.toByteArray((ByteBuffer)string2), UTF8_CHARSET);
    }

    public Fields getOutputFields() {
        return new Fields(new String[]{STRING_SCHEME_KEY});
    }
}

