/*
 * Decompiled with CFR 0.152.
 */
package storm.kafka;

import backtype.storm.spout.MultiScheme;
import backtype.storm.spout.RawMultiScheme;
import java.io.Serializable;
import java.util.List;
import kafka.api.OffsetRequest;
import storm.kafka.BrokerHosts;

public class KafkaConfig
implements Serializable {
    private static final long serialVersionUID = 5276718734571623855L;
    public final BrokerHosts hosts;
    public final String topic;
    public final List<String> topics;
    public final String clientId;
    public int fetchSizeBytes = 0x100000;
    public int socketTimeoutMs = 10000;
    public int fetchMaxWait = 10000;
    public int bufferSizeBytes = 0x100000;
    public MultiScheme scheme = new RawMultiScheme();
    public boolean ignoreZkOffsets = false;
    public long startOffsetTime = OffsetRequest.EarliestTime();
    public long maxOffsetBehind = Long.MAX_VALUE;
    public boolean useStartOffsetTimeIfOffsetOutOfRange = true;
    public int metricsTimeBucketSizeInSecs = 60;

    public KafkaConfig(BrokerHosts hosts, String topic) {
        this(hosts, topic, OffsetRequest.DefaultClientId());
    }

    public KafkaConfig(BrokerHosts hosts, List<String> topics) {
        this(hosts, topics, OffsetRequest.DefaultClientId());
    }

    public KafkaConfig(BrokerHosts hosts, String topic, String clientId) {
        this.hosts = hosts;
        this.topic = topic;
        this.topics = null;
        this.clientId = clientId;
    }

    public KafkaConfig(BrokerHosts hosts, List<String> topics, String clientId) {
        this.hosts = hosts;
        this.topic = null;
        this.topics = topics;
        this.clientId = clientId;
    }
}

