/*
 * Decompiled with CFR 0.152.
 */
package storm.example;

import backtype.storm.Config;
import backtype.storm.task.OutputCollector;
import backtype.storm.task.TopologyContext;
import backtype.storm.topology.IRichBolt;
import backtype.storm.topology.OutputFieldsDeclarer;
import backtype.storm.tuple.Fields;
import backtype.storm.tuple.Tuple;
import backtype.storm.tuple.Values;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AverageCountBolt<K, V>
implements IRichBolt {
    protected OutputCollector collector;
    public static final Logger LOG = LoggerFactory.getLogger(AverageCountBolt.class);
    private long periodInSecs;
    private volatile long count;

    public AverageCountBolt(long periodInSecs) {
        this.periodInSecs = periodInSecs;
    }

    public void prepare(Map stormConf, TopologyContext context, OutputCollector collector) {
        this.collector = collector;
    }

    public void execute(Tuple tuple) {
        if (AverageCountBolt.isTickTuple(tuple)) {
            long cachedCount = this.count;
            this.count = 0L;
            LOG.info("Got tick tuple, emitting count={}", cachedCount);
            this.collector.emit((List)new Values(new Object[]{"", String.valueOf(cachedCount).getBytes()}));
        } else {
            ++this.count;
            LOG.info("Increasing count={}", this.count);
        }
        this.collector.ack(tuple);
    }

    public void cleanup() {
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        declarer.declare(new Fields(new String[]{"key", "message"}));
    }

    public Map<String, Object> getComponentConfiguration() {
        Config conf = new Config();
        conf.put((Object)"topology.tick.tuple.freq.secs", (Object)this.periodInSecs);
        return conf;
    }

    private static boolean isTickTuple(Tuple tuple) {
        return tuple.getSourceComponent().equals("__system") && tuple.getSourceStreamId().equals("__tick");
    }
}

