/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent;

import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000114A!\u0001\u0002\u0001\u000f\t91+\u001f8d-\u0006\u0014(BA\u0002\u0005\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0002\u000b\u0005)1oY1mC\u000e\u0001QC\u0001\u0005\u0015'\t\u0001\u0011\u0002\u0005\u0002\u000b\u00175\tA!\u0003\u0002\r\t\t1\u0011I\\=SK\u001aDQA\u0004\u0001\u0005\u0002=\ta\u0001P5oSRtD#\u0001\t\u0011\u0007E\u0001!#D\u0001\u0003!\t\u0019B\u0003\u0004\u0001\u0005\u000bU\u0001!\u0019\u0001\f\u0003\u0003\u0005\u000b\"a\u0006\u000e\u0011\u0005)A\u0012BA\r\u0005\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"AC\u000e\n\u0005q!!aA!os\"9a\u0004\u0001a\u0001\n\u0013y\u0012!C5t\t\u00164\u0017N\\3e+\u0005\u0001\u0003C\u0001\u0006\"\u0013\t\u0011CAA\u0004C_>dW-\u00198\t\u000f\u0011\u0002\u0001\u0019!C\u0005K\u0005i\u0011n\u001d#fM&tW\rZ0%KF$\"AJ\u0015\u0011\u0005)9\u0013B\u0001\u0015\u0005\u0005\u0011)f.\u001b;\t\u000f)\u001a\u0013\u0011!a\u0001A\u0005\u0019\u0001\u0010J\u0019\t\r1\u0002\u0001\u0015)\u0003!\u0003)I7\u000fR3gS:,G\r\t\u0005\b]\u0001\u0001\r\u0011\"\u00030\u0003\u00151\u0018\r\\;f+\u0005\u0001\u0004c\u0001\u00062%%\u0011!\u0007\u0002\u0002\u0007\u001fB$\u0018n\u001c8\t\u000fQ\u0002\u0001\u0019!C\u0005k\u0005Ia/\u00197vK~#S-\u001d\u000b\u0003MYBqAK\u001a\u0002\u0002\u0003\u0007\u0001\u0007\u0003\u00049\u0001\u0001\u0006K\u0001M\u0001\u0007m\u0006dW/\u001a\u0011\t\u000bi\u0002A\u0011A\u001e\u0002\u0007\u001d,G/F\u0001\u0013\u0011\u0015i\u0004\u0001\"\u0003?\u0003Q9\u0018-\u001b;NK\u0006\u001cXO]5oO\u0016c\u0017\r]:fIR\u0011qH\u0011\t\u0003\u0015\u0001K!!\u0011\u0003\u0003\t1{gn\u001a\u0005\u0006\u0007r\u0002\raP\u0001\bi&lWm\\;u\u0011\u0015Q\u0004\u0001\"\u0001F)\t\u0001d\tC\u0003D\t\u0002\u0007q\bC\u0003I\u0001\u0011\u0005\u0011*\u0001\u0003uC.,G#\u0001\n\t\u000b!\u0003A\u0011A&\u0015\u0005Ia\u0005\"B\"K\u0001\u0004y\u0004\"\u0002(\u0001\t\u0003y\u0015aA:fiR\u0011a\u0005\u0015\u0005\u0006#6\u0003\rAE\u0001\u0002q\"\"Qj\u0015,Y!\tQA+\u0003\u0002V\t\tQA-\u001a9sK\u000e\fG/\u001a3\"\u0003]\u000b\u0001(V:fA\u0001\u0004X\u000f\u001e1!S:\u001cH/Z1eY\u0001\n7\u000f\t1tKR\u0004\u0007%[:!a>$XM\u001c;j_:\fG\u000e\\=!KJ\u0014xN]\u0017qe>tW-I\u0001Z\u0003\u0019\u0011d&\r\u0019/a!)1\f\u0001C\u00019\u0006\u0019\u0001/\u001e;\u0015\u0005\u0019j\u0006\"B)[\u0001\u0004\u0011\u0002\"B0\u0001\t\u0003y\u0012!B5t'\u0016$\b\"B1\u0001\t\u0003\u0011\u0017!B;og\u0016$H#\u0001\u0014)\t\u0001\u001cF\rW\u0011\u0002K\u0006YTk]3!AR\f7.\u001a1!S:\u001cH/Z1eY\u0001\n7\u000f\t1v]N,G\u000f\u0019\u0011jg\u0002\u0002x\u000e^3oi&|g.\u00197ms\u0002*'O]8s[A\u0014xN\\3\t\u000b\u001d\u0004A\u0011\u00025\u0002\rM,GOV1m)\t1\u0013\u000eC\u0003RM\u0002\u0007!\u0003C\u0003l\u0001\u0011%!-\u0001\u0005v]N,GOV1m\u0001")
public class SyncVar<A> {
    private boolean isDefined = false;
    private Option<A> value = None$.MODULE$;

    private boolean isDefined() {
        return this.isDefined;
    }

    private void isDefined_$eq(boolean x$1) {
        this.isDefined = x$1;
    }

    private Option<A> value() {
        return this.value;
    }

    private void value_$eq(Option<A> x$1) {
        this.value = x$1;
    }

    public synchronized A get() {
        while (!this.isDefined()) {
            this.wait();
        }
        return this.value().get();
    }

    private long waitMeasuringElapsed(long timeout) {
        long l;
        if (timeout <= 0L) {
            l = 0L;
        } else {
            long start2 = System.currentTimeMillis();
            this.wait(timeout);
            long elapsed = System.currentTimeMillis() - start2;
            l = elapsed < 0L ? 0L : elapsed;
        }
        return l;
    }

    public synchronized Option<A> get(long timeout) {
        long elapsed;
        for (long rest = timeout; !this.isDefined() && rest > 0L; rest -= elapsed) {
            elapsed = this.waitMeasuringElapsed(rest);
        }
        return this.value();
    }

    public synchronized A take() {
        try {
            return this.get();
        }
        finally {
            this.unsetVal();
        }
    }

    public synchronized A take(long timeout) {
        try {
            return this.get(timeout).get();
        }
        finally {
            this.unsetVal();
        }
    }

    public void set(A x2) {
        this.setVal(x2);
    }

    public synchronized void put(A x2) {
        while (this.isDefined()) {
            this.wait();
        }
        this.setVal(x2);
    }

    public synchronized boolean isSet() {
        return this.isDefined();
    }

    public synchronized void unset() {
        this.isDefined_$eq(false);
        this.value_$eq(None$.MODULE$);
        this.notifyAll();
    }

    private synchronized void setVal(A x2) {
        this.isDefined_$eq(true);
        this.value_$eq(new Some<A>(x2));
        this.notifyAll();
    }

    private synchronized void unsetVal() {
        this.isDefined_$eq(false);
        this.value_$eq(None$.MODULE$);
        this.notifyAll();
    }
}

