/*
 * Decompiled with CFR 0.152.
 */
package scala;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.text.MessageFormat;
import scala.Function0;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.util.DynamicVariable;

public final class Console$ {
    public static final Console$ MODULE$;
    private final String BLACK;
    private final String RED;
    private final String GREEN;
    private final String YELLOW;
    private final String BLUE;
    private final String MAGENTA;
    private final String CYAN;
    private final String WHITE;
    private final String BLACK_B;
    private final String RED_B;
    private final String GREEN_B;
    private final String YELLOW_B;
    private final String BLUE_B;
    private final String MAGENTA_B;
    private final String CYAN_B;
    private final String WHITE_B;
    private final String RESET;
    private final String BOLD;
    private final String UNDERLINED;
    private final String BLINK;
    private final String REVERSED;
    private final String INVISIBLE;
    private final DynamicVariable<PrintStream> outVar;
    private final DynamicVariable<PrintStream> errVar;
    private final DynamicVariable<BufferedReader> inVar;

    static {
        new Console$();
    }

    public final String BLACK() {
        return "\u001b[30m";
    }

    public final String RED() {
        return "\u001b[31m";
    }

    public final String GREEN() {
        return "\u001b[32m";
    }

    public final String YELLOW() {
        return "\u001b[33m";
    }

    public final String BLUE() {
        return "\u001b[34m";
    }

    public final String MAGENTA() {
        return "\u001b[35m";
    }

    public final String CYAN() {
        return "\u001b[36m";
    }

    public final String WHITE() {
        return "\u001b[37m";
    }

    public final String BLACK_B() {
        return "\u001b[40m";
    }

    public final String RED_B() {
        return "\u001b[41m";
    }

    public final String GREEN_B() {
        return "\u001b[42m";
    }

    public final String YELLOW_B() {
        return "\u001b[43m";
    }

    public final String BLUE_B() {
        return "\u001b[44m";
    }

    public final String MAGENTA_B() {
        return "\u001b[45m";
    }

    public final String CYAN_B() {
        return "\u001b[46m";
    }

    public final String WHITE_B() {
        return "\u001b[47m";
    }

    public final String RESET() {
        return "\u001b[0m";
    }

    public final String BOLD() {
        return "\u001b[1m";
    }

    public final String UNDERLINED() {
        return "\u001b[4m";
    }

    public final String BLINK() {
        return "\u001b[5m";
    }

    public final String REVERSED() {
        return "\u001b[7m";
    }

    public final String INVISIBLE() {
        return "\u001b[8m";
    }

    private DynamicVariable<PrintStream> outVar() {
        return this.outVar;
    }

    private DynamicVariable<PrintStream> errVar() {
        return this.errVar;
    }

    private DynamicVariable<BufferedReader> inVar() {
        return this.inVar;
    }

    public PrintStream out() {
        return this.outVar().value();
    }

    public PrintStream err() {
        return this.errVar().value();
    }

    public BufferedReader in() {
        return this.inVar().value();
    }

    public void setOut(PrintStream out) {
        this.outVar().value_$eq(out);
    }

    public <T> T withOut(PrintStream out, Function0<T> thunk) {
        return this.outVar().withValue(out, thunk);
    }

    public void setOut(OutputStream out) {
        this.setOut(new PrintStream(out));
    }

    public <T> T withOut(OutputStream out, Function0<T> thunk) {
        PrintStream printStream = new PrintStream(out);
        return this.outVar().withValue(printStream, thunk);
    }

    public void setErr(PrintStream err2) {
        this.errVar().value_$eq(err2);
    }

    public <T> T withErr(PrintStream err2, Function0<T> thunk) {
        return this.errVar().withValue(err2, thunk);
    }

    public void setErr(OutputStream err2) {
        this.setErr(new PrintStream(err2));
    }

    public <T> T withErr(OutputStream err2, Function0<T> thunk) {
        PrintStream printStream = new PrintStream(err2);
        return this.errVar().withValue(printStream, thunk);
    }

    public void setIn(Reader reader) {
        this.inVar().value_$eq(new BufferedReader(reader));
    }

    public <T> T withIn(Reader reader, Function0<T> thunk) {
        return this.inVar().withValue(new BufferedReader(reader), thunk);
    }

    public void setIn(InputStream in) {
        this.setIn(new InputStreamReader(in));
    }

    public <T> T withIn(InputStream in, Function0<T> thunk) {
        InputStreamReader inputStreamReader = new InputStreamReader(in);
        return this.inVar().withValue(new BufferedReader(inputStreamReader), thunk);
    }

    public void print(Object obj) {
        this.out().print(obj == null ? "null" : obj.toString());
    }

    public void flush() {
        this.out().flush();
    }

    public void println() {
        this.out().println();
    }

    public void println(Object x2) {
        this.out().println(x2);
    }

    public void printf(String text2, Seq<Object> args2) {
        Predef$ predef$ = Predef$.MODULE$;
        this.out().print(new StringOps(text2).format(args2));
    }

    public String readLine() {
        return this.in().readLine();
    }

    public String readLine(String text2, Seq<Object> args2) {
        this.printf(text2, args2);
        return this.readLine();
    }

    public boolean readBoolean() {
        String s2 = this.readLine();
        if (s2 == null) {
            throw new EOFException("Console has reached end of input");
        }
        String string2 = s2.toLowerCase();
        boolean bl = !("true" != null ? !"true".equals(string2) : string2 != null) ? true : (!("t" != null ? !"t".equals(string2) : string2 != null) ? true : (!("yes" != null ? !"yes".equals(string2) : string2 != null) ? true : !("y" != null ? !"y".equals(string2) : string2 != null)));
        return bl;
    }

    public byte readByte() {
        String s2 = this.readLine();
        if (s2 == null) {
            throw new EOFException("Console has reached end of input");
        }
        Predef$ predef$ = Predef$.MODULE$;
        return new StringOps(s2).toByte();
    }

    public short readShort() {
        String s2 = this.readLine();
        if (s2 == null) {
            throw new EOFException("Console has reached end of input");
        }
        Predef$ predef$ = Predef$.MODULE$;
        return new StringOps(s2).toShort();
    }

    public char readChar() {
        String s2 = this.readLine();
        if (s2 == null) {
            throw new EOFException("Console has reached end of input");
        }
        return s2.charAt(0);
    }

    public int readInt() {
        String s2 = this.readLine();
        if (s2 == null) {
            throw new EOFException("Console has reached end of input");
        }
        Predef$ predef$ = Predef$.MODULE$;
        return new StringOps(s2).toInt();
    }

    public long readLong() {
        String s2 = this.readLine();
        if (s2 == null) {
            throw new EOFException("Console has reached end of input");
        }
        Predef$ predef$ = Predef$.MODULE$;
        return new StringOps(s2).toLong();
    }

    public float readFloat() {
        String s2 = this.readLine();
        if (s2 == null) {
            throw new EOFException("Console has reached end of input");
        }
        Predef$ predef$ = Predef$.MODULE$;
        return new StringOps(s2).toFloat();
    }

    public double readDouble() {
        String s2 = this.readLine();
        if (s2 == null) {
            throw new EOFException("Console has reached end of input");
        }
        Predef$ predef$ = Predef$.MODULE$;
        return new StringOps(s2).toDouble();
    }

    public List<Object> readf(String format2) {
        String s2 = this.readLine();
        if (s2 == null) {
            throw new EOFException("Console has reached end of input");
        }
        return this.textComponents(new MessageFormat(format2).parse(s2));
    }

    public Object readf1(String format2) {
        return this.readf(format2).head();
    }

    public Tuple2<Object, Object> readf2(String format2) {
        List<Object> res = this.readf(format2);
        return new Tuple2<Object, Object>(res.head(), ((IterableLike)res.tail()).head());
    }

    public Tuple3<Object, Object, Object> readf3(String format2) {
        List<Object> res = this.readf(format2);
        return new Tuple3<Object, Object, Object>(res.head(), ((IterableLike)res.tail()).head(), ((IterableLike)((TraversableLike)res.tail()).tail()).head());
    }

    private List<Object> textComponents(Object[] a) {
        List res = Nil$.MODULE$;
        for (int i = a.length - 1; i >= 0; --i) {
            Object object;
            Object object2 = a[i];
            if (object2 instanceof Boolean) {
                Boolean bl = (Boolean)object2;
                object = BoxesRunTime.boxToBoolean(bl);
            } else if (object2 instanceof Byte) {
                Byte by2 = (Byte)object2;
                object = BoxesRunTime.boxToByte(by2);
            } else if (object2 instanceof Short) {
                Short s2 = (Short)object2;
                object = BoxesRunTime.boxToShort(s2);
            } else if (object2 instanceof Character) {
                Character c = (Character)object2;
                object = BoxesRunTime.boxToCharacter(c.charValue());
            } else if (object2 instanceof Integer) {
                Integer n = (Integer)object2;
                object = BoxesRunTime.boxToInteger(n);
            } else if (object2 instanceof Long) {
                Long l = (Long)object2;
                object = BoxesRunTime.boxToLong(l);
            } else if (object2 instanceof Float) {
                Float f = (Float)object2;
                object = BoxesRunTime.boxToFloat(f.floatValue());
            } else if (object2 instanceof Double) {
                Double d = (Double)object2;
                object = BoxesRunTime.boxToDouble(d);
            } else {
                object = object2;
            }
            res = res.$colon$colon(object);
        }
        return res;
    }

    private Console$() {
        MODULE$ = this;
        this.outVar = new DynamicVariable<PrintStream>(System.out);
        this.errVar = new DynamicVariable<PrintStream>(System.err);
        this.inVar = new DynamicVariable<BufferedReader>(new BufferedReader(new InputStreamReader(System.in)));
    }
}

