/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.socket.oio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.netty.channel.AbstractServerChannel;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelSink;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.socket.DefaultServerSocketChannelConfig;
import org.jboss.netty.channel.socket.ServerSocketChannel;
import org.jboss.netty.channel.socket.ServerSocketChannelConfig;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;

class OioServerSocketChannel
extends AbstractServerChannel
implements ServerSocketChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(OioServerSocketChannel.class);
    final ServerSocket socket;
    final Lock shutdownLock = new ReentrantLock();
    private final ServerSocketChannelConfig config;

    OioServerSocketChannel(ChannelFactory factory2, ChannelPipeline pipeline, ChannelSink sink) {
        super(factory2, pipeline, sink);
        try {
            this.socket = new ServerSocket();
        }
        catch (IOException e) {
            throw new ChannelException("Failed to open a server socket.", e);
        }
        try {
            this.socket.setSoTimeout(1000);
        }
        catch (IOException e) {
            try {
                this.socket.close();
            }
            catch (IOException e2) {
                logger.warn("Failed to close a partially initialized socket.", e2);
            }
            throw new ChannelException("Failed to set the server socket timeout.", e);
        }
        this.config = new DefaultServerSocketChannelConfig(this.socket);
        Channels.fireChannelOpen(this);
    }

    public ServerSocketChannelConfig getConfig() {
        return this.config;
    }

    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this.socket.getLocalSocketAddress();
    }

    public InetSocketAddress getRemoteAddress() {
        return null;
    }

    public boolean isBound() {
        return this.isOpen() && this.socket.isBound();
    }

    protected boolean setClosed() {
        return super.setClosed();
    }
}

