/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.socket.oio;

import java.io.PushbackInputStream;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import org.jboss.netty.channel.AbstractChannelSink;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelState;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.socket.oio.OioClientSocketChannel;
import org.jboss.netty.channel.socket.oio.OioWorker;
import org.jboss.netty.util.ThreadRenamingRunnable;
import org.jboss.netty.util.internal.IoWorkerRunnable;

class OioClientSocketPipelineSink
extends AbstractChannelSink {
    private final Executor workerExecutor;

    OioClientSocketPipelineSink(Executor workerExecutor) {
        this.workerExecutor = workerExecutor;
    }

    public void eventSunk(ChannelPipeline pipeline, ChannelEvent e) throws Exception {
        OioClientSocketChannel channel = (OioClientSocketChannel)e.getChannel();
        ChannelFuture future = e.getFuture();
        if (e instanceof ChannelStateEvent) {
            ChannelStateEvent stateEvent = (ChannelStateEvent)e;
            ChannelState state = stateEvent.getState();
            Object value2 = stateEvent.getValue();
            switch (state) {
                case OPEN: {
                    if (!Boolean.FALSE.equals(value2)) break;
                    OioWorker.close(channel, future);
                    break;
                }
                case BOUND: {
                    if (value2 != null) {
                        this.bind(channel, future, (SocketAddress)value2);
                        break;
                    }
                    OioWorker.close(channel, future);
                    break;
                }
                case CONNECTED: {
                    if (value2 != null) {
                        this.connect(channel, future, (SocketAddress)value2);
                        break;
                    }
                    OioWorker.close(channel, future);
                    break;
                }
                case INTEREST_OPS: {
                    OioWorker.setInterestOps(channel, future, (Integer)value2);
                }
            }
        } else if (e instanceof MessageEvent) {
            OioWorker.write(channel, future, ((MessageEvent)e).getMessage());
        }
    }

    private void bind(OioClientSocketChannel channel, ChannelFuture future, SocketAddress localAddress) {
        try {
            channel.socket.bind(localAddress);
            future.setSuccess();
            Channels.fireChannelBound(channel, (SocketAddress)channel.getLocalAddress());
        }
        catch (Throwable t) {
            future.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void connect(OioClientSocketChannel channel, ChannelFuture future, SocketAddress remoteAddress) {
        boolean bound = channel.isBound();
        boolean connected = false;
        boolean workerStarted = false;
        future.addListener(ChannelFutureListener.CLOSE_ON_FAILURE);
        try {
            try {
                channel.socket.connect(remoteAddress, channel.getConfig().getConnectTimeoutMillis());
                connected = true;
                channel.in = new PushbackInputStream(channel.socket.getInputStream(), 1);
                channel.out = channel.socket.getOutputStream();
                future.setSuccess();
                if (!bound) {
                    Channels.fireChannelBound(channel, (SocketAddress)channel.getLocalAddress());
                }
                Channels.fireChannelConnected(channel, (SocketAddress)channel.getRemoteAddress());
                this.workerExecutor.execute(new IoWorkerRunnable(new ThreadRenamingRunnable(new OioWorker(channel), "Old I/O client worker (" + channel + ')')));
                workerStarted = true;
            }
            catch (Throwable t) {
                future.setFailure(t);
                Channels.fireExceptionCaught(channel, t);
                Object var9_8 = null;
                if (!connected) return;
                if (workerStarted) return;
                OioWorker.close(channel, future);
                return;
            }
            Object var9_7 = null;
            if (!connected) return;
            if (workerStarted) return;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (!connected) throw throwable;
            if (workerStarted) throw throwable;
            OioWorker.close(channel, future);
            throw throwable;
        }
        OioWorker.close(channel, future);
    }
}

