/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import org.jboss.netty.channel.FileRegion;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;

public class DefaultFileRegion
implements FileRegion {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultFileRegion.class);
    private final FileChannel file;
    private final long position;
    private final long count;

    public DefaultFileRegion(FileChannel file, long position, long count2) {
        this.file = file;
        this.position = position;
        this.count = count2;
    }

    public long getPosition() {
        return this.position;
    }

    public long getCount() {
        return this.count;
    }

    public long transferTo(WritableByteChannel target, long position) throws IOException {
        long count2 = this.count - position;
        if (count2 < 0L || position < 0L) {
            throw new IllegalArgumentException("position out of range: " + position + " (expected: 0 - " + (this.count - 1L) + ")");
        }
        if (count2 == 0L) {
            return 0L;
        }
        return this.file.transferTo(this.position + position, count2, target);
    }

    public void releaseExternalResources() {
        try {
            this.file.close();
        }
        catch (IOException e) {
            logger.warn("Failed to close a file.", e);
        }
    }
}

