/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.buffer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import org.jboss.netty.buffer.AbstractChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.buffer.SlicedChannelBuffer;
import org.jboss.netty.buffer.TruncatedChannelBuffer;

public abstract class HeapChannelBuffer
extends AbstractChannelBuffer {
    protected final byte[] array;

    public HeapChannelBuffer(int length) {
        this(new byte[length], 0, 0);
    }

    public HeapChannelBuffer(byte[] array) {
        this(array, 0, array.length);
    }

    protected HeapChannelBuffer(byte[] array, int readerIndex, int writerIndex) {
        if (array == null) {
            throw new NullPointerException("array");
        }
        this.array = array;
        this.setIndex(readerIndex, writerIndex);
    }

    public boolean isDirect() {
        return false;
    }

    public int capacity() {
        return this.array.length;
    }

    public boolean hasArray() {
        return true;
    }

    public byte[] array() {
        return this.array;
    }

    public int arrayOffset() {
        return 0;
    }

    public byte getByte(int index2) {
        return this.array[index2];
    }

    public void getBytes(int index2, ChannelBuffer dst, int dstIndex, int length) {
        if (dst instanceof HeapChannelBuffer) {
            this.getBytes(index2, ((HeapChannelBuffer)dst).array, dstIndex, length);
        } else {
            dst.setBytes(dstIndex, this.array, index2, length);
        }
    }

    public void getBytes(int index2, byte[] dst, int dstIndex, int length) {
        System.arraycopy(this.array, index2, dst, dstIndex, length);
    }

    public void getBytes(int index2, ByteBuffer dst) {
        dst.put(this.array, index2, Math.min(this.capacity() - index2, dst.remaining()));
    }

    public void getBytes(int index2, OutputStream out, int length) throws IOException {
        out.write(this.array, index2, length);
    }

    public int getBytes(int index2, GatheringByteChannel out, int length) throws IOException {
        return out.write(ByteBuffer.wrap(this.array, index2, length));
    }

    public void setByte(int index2, int value2) {
        this.array[index2] = (byte)value2;
    }

    public void setBytes(int index2, ChannelBuffer src, int srcIndex, int length) {
        if (src instanceof HeapChannelBuffer) {
            this.setBytes(index2, ((HeapChannelBuffer)src).array, srcIndex, length);
        } else {
            src.getBytes(srcIndex, this.array, index2, length);
        }
    }

    public void setBytes(int index2, byte[] src, int srcIndex, int length) {
        System.arraycopy(src, srcIndex, this.array, index2, length);
    }

    public void setBytes(int index2, ByteBuffer src) {
        src.get(this.array, index2, src.remaining());
    }

    public int setBytes(int index2, InputStream in, int length) throws IOException {
        int localReadBytes;
        int readBytes = 0;
        do {
            if ((localReadBytes = in.read(this.array, index2, length)) < 0) {
                if (readBytes != 0) break;
                return -1;
            }
            readBytes += localReadBytes;
            index2 += localReadBytes;
        } while ((length -= localReadBytes) > 0);
        return readBytes;
    }

    public int setBytes(int index2, ScatteringByteChannel in, int length) throws IOException {
        int localReadBytes;
        ByteBuffer buf = ByteBuffer.wrap(this.array, index2, length);
        int readBytes = 0;
        do {
            try {
                localReadBytes = in.read(buf);
            }
            catch (ClosedChannelException e) {
                localReadBytes = -1;
            }
            if (localReadBytes >= 0) continue;
            if (readBytes != 0) break;
            return -1;
        } while (localReadBytes != 0 && (readBytes += localReadBytes) < length);
        return readBytes;
    }

    public ChannelBuffer slice(int index2, int length) {
        if (index2 == 0) {
            if (length == 0) {
                return ChannelBuffers.EMPTY_BUFFER;
            }
            if (length == this.array.length) {
                ChannelBuffer slice2 = this.duplicate();
                slice2.setIndex(0, length);
                return slice2;
            }
            return new TruncatedChannelBuffer(this, length);
        }
        if (length == 0) {
            return ChannelBuffers.EMPTY_BUFFER;
        }
        return new SlicedChannelBuffer(this, index2, length);
    }

    public ByteBuffer toByteBuffer(int index2, int length) {
        return ByteBuffer.wrap(this.array, index2, length).order(this.order());
    }
}

