/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.zip.Adler32;
import org.apache.jute.BinaryInputArchive;
import org.apache.jute.Record;
import org.apache.zookeeper.server.TraceFormatter;
import org.apache.zookeeper.server.persistence.FileHeader;
import org.apache.zookeeper.server.persistence.FileTxnLog;
import org.apache.zookeeper.server.util.SerializeUtils;
import org.apache.zookeeper.txn.TxnHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogFormatter {
    private static final Logger LOG = LoggerFactory.getLogger(LogFormatter.class);

    public static void main(String[] args2) throws Exception {
        if (args2.length != 1) {
            System.err.println("USAGE: LogFormatter log_file");
            System.exit(2);
        }
        FileInputStream fis = new FileInputStream(args2[0]);
        BinaryInputArchive logStream = BinaryInputArchive.getArchive(fis);
        FileHeader fhdr = new FileHeader();
        fhdr.deserialize(logStream, "fileheader");
        if (fhdr.getMagic() != FileTxnLog.TXNLOG_MAGIC) {
            System.err.println("Invalid magic number for " + args2[0]);
            System.exit(2);
        }
        System.out.println("ZooKeeper Transactional Log File with dbid " + fhdr.getDbid() + " txnlog format version " + fhdr.getVersion());
        int count2 = 0;
        while (true) {
            byte[] bytes2;
            long crcValue;
            try {
                crcValue = logStream.readLong("crcvalue");
                bytes2 = logStream.readBuffer("txnEntry");
            }
            catch (EOFException e) {
                System.out.println("EOF reached after " + count2 + " txns.");
                return;
            }
            if (bytes2.length == 0) {
                System.out.println("EOF reached after " + count2 + " txns.");
                return;
            }
            Adler32 crc = new Adler32();
            crc.update(bytes2, 0, bytes2.length);
            if (crcValue != crc.getValue()) {
                throw new IOException("CRC doesn't match " + crcValue + " vs " + crc.getValue());
            }
            TxnHeader hdr = new TxnHeader();
            Record txn = SerializeUtils.deserializeTxn(bytes2, hdr);
            System.out.println(DateFormat.getDateTimeInstance(3, 1).format(new Date(hdr.getTime())) + " session 0x" + Long.toHexString(hdr.getClientId()) + " cxid 0x" + Long.toHexString(hdr.getCxid()) + " zxid 0x" + Long.toHexString(hdr.getZxid()) + " " + TraceFormatter.op2String(hdr.getType()) + " " + txn);
            if (logStream.readByte("EOR") != 66) {
                LOG.error("Last transaction was partial.");
                throw new EOFException("Last transaction was partial.");
            }
            ++count2;
        }
    }
}

