/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper;

import java.util.List;
import jline.Completor;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.ZooKeeperMain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JLineZNodeCompletor
implements Completor {
    private ZooKeeper zk;

    public JLineZNodeCompletor(ZooKeeper zk) {
        this.zk = zk;
    }

    @Override
    public int complete(String buffer, int cursor, List candidates) {
        String[] tokens2;
        buffer = buffer.substring(0, cursor);
        String token2 = "";
        if (!buffer.endsWith(" ") && (tokens2 = buffer.split(" ")).length != 0) {
            token2 = tokens2[tokens2.length - 1];
        }
        if (token2.startsWith("/")) {
            return this.completeZNode(buffer, token2, candidates);
        }
        return this.completeCommand(buffer, token2, candidates);
    }

    private int completeCommand(String buffer, String token2, List<String> candidates) {
        for (String cmd : ZooKeeperMain.getCommands()) {
            if (!cmd.startsWith(token2)) continue;
            candidates.add(cmd);
        }
        return buffer.lastIndexOf(" ") + 1;
    }

    private int completeZNode(String buffer, String token2, List<String> candidates) {
        String path = token2;
        int idx = path.lastIndexOf("/") + 1;
        String prefix = path.substring(idx);
        try {
            String dir = idx == 1 ? "/" : path.substring(0, idx - 1);
            List<String> children2 = this.zk.getChildren(dir, false);
            for (String child : children2) {
                if (!child.startsWith(prefix)) continue;
                candidates.add(child);
            }
        }
        catch (InterruptedException e) {
            return 0;
        }
        catch (KeeperException e) {
            return 0;
        }
        return candidates.size() == 0 ? buffer.length() : buffer.lastIndexOf("/") + 1;
    }
}

