/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.AppenderAttachableImpl;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.AppenderAttachable;
import org.apache.log4j.spi.LoggingEvent;

public class AsyncAppender
extends AppenderSkeleton
implements AppenderAttachable {
    public static final int DEFAULT_BUFFER_SIZE = 128;
    private final List buffer = new ArrayList();
    private final Map discardMap = new HashMap();
    private int bufferSize = 128;
    AppenderAttachableImpl aai = this.appenders = new AppenderAttachableImpl();
    private final AppenderAttachableImpl appenders;
    private final Thread dispatcher = new Thread(new Dispatcher(this, this.buffer, this.discardMap, this.appenders));
    private boolean locationInfo = false;
    private boolean blocking = true;

    public AsyncAppender() {
        this.dispatcher.setDaemon(true);
        this.dispatcher.setName("AsyncAppender-Dispatcher-" + this.dispatcher.getName());
        this.dispatcher.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAppender(Appender newAppender) {
        AppenderAttachableImpl appenderAttachableImpl = this.appenders;
        synchronized (appenderAttachableImpl) {
            this.appenders.addAppender(newAppender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(LoggingEvent event) {
        if (this.dispatcher == null || !this.dispatcher.isAlive() || this.bufferSize <= 0) {
            AppenderAttachableImpl appenderAttachableImpl = this.appenders;
            synchronized (appenderAttachableImpl) {
                this.appenders.appendLoopOnAppenders(event);
            }
            return;
        }
        event.getNDC();
        event.getThreadName();
        event.getMDCCopy();
        if (this.locationInfo) {
            event.getLocationInformation();
        }
        event.getRenderedMessage();
        event.getThrowableStrRep();
        List list2 = this.buffer;
        synchronized (list2) {
            block15: {
                boolean discard;
                do {
                    int previousSize;
                    if ((previousSize = this.buffer.size()) < this.bufferSize) {
                        this.buffer.add(event);
                        if (previousSize == 0) {
                            this.buffer.notifyAll();
                        }
                        break block15;
                    }
                    discard = true;
                    if (!this.blocking || Thread.interrupted() || Thread.currentThread() == this.dispatcher) continue;
                    try {
                        this.buffer.wait();
                        discard = false;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                } while (!discard);
                String loggerName = event.getLoggerName();
                DiscardSummary summary2 = (DiscardSummary)this.discardMap.get(loggerName);
                if (summary2 == null) {
                    summary2 = new DiscardSummary(event);
                    this.discardMap.put(loggerName, summary2);
                } else {
                    summary2.add(event);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.buffer;
        synchronized (object) {
            this.closed = true;
            this.buffer.notifyAll();
        }
        try {
            this.dispatcher.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LogLog.error("Got an InterruptedException while waiting for the dispatcher to finish.", e);
        }
        object = this.appenders;
        synchronized (object) {
            Enumeration iter2 = this.appenders.getAllAppenders();
            if (iter2 != null) {
                while (iter2.hasMoreElements()) {
                    Object next2 = iter2.nextElement();
                    if (!(next2 instanceof Appender)) continue;
                    ((Appender)next2).close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getAllAppenders() {
        AppenderAttachableImpl appenderAttachableImpl = this.appenders;
        synchronized (appenderAttachableImpl) {
            return this.appenders.getAllAppenders();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Appender getAppender(String name) {
        AppenderAttachableImpl appenderAttachableImpl = this.appenders;
        synchronized (appenderAttachableImpl) {
            return this.appenders.getAppender(name);
        }
    }

    public boolean getLocationInfo() {
        return this.locationInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAttached(Appender appender) {
        AppenderAttachableImpl appenderAttachableImpl = this.appenders;
        synchronized (appenderAttachableImpl) {
            return this.appenders.isAttached(appender);
        }
    }

    public boolean requiresLayout() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllAppenders() {
        AppenderAttachableImpl appenderAttachableImpl = this.appenders;
        synchronized (appenderAttachableImpl) {
            this.appenders.removeAllAppenders();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAppender(Appender appender) {
        AppenderAttachableImpl appenderAttachableImpl = this.appenders;
        synchronized (appenderAttachableImpl) {
            this.appenders.removeAppender(appender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAppender(String name) {
        AppenderAttachableImpl appenderAttachableImpl = this.appenders;
        synchronized (appenderAttachableImpl) {
            this.appenders.removeAppender(name);
        }
    }

    public void setLocationInfo(boolean flag) {
        this.locationInfo = flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBufferSize(int size2) {
        if (size2 < 0) {
            throw new NegativeArraySizeException("size");
        }
        List list2 = this.buffer;
        synchronized (list2) {
            this.bufferSize = size2 < 1 ? 1 : size2;
            this.buffer.notifyAll();
        }
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlocking(boolean value2) {
        List list2 = this.buffer;
        synchronized (list2) {
            this.blocking = value2;
            this.buffer.notifyAll();
        }
    }

    public boolean getBlocking() {
        return this.blocking;
    }

    private static class Dispatcher
    implements Runnable {
        private final AsyncAppender parent;
        private final List buffer;
        private final Map discardMap;
        private final AppenderAttachableImpl appenders;

        public Dispatcher(AsyncAppender parent, List buffer, Map discardMap, AppenderAttachableImpl appenders) {
            this.parent = parent;
            this.buffer = buffer;
            this.appenders = appenders;
            this.discardMap = discardMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean isActive2 = true;
            try {
                while (isActive2) {
                    LoggingEvent[] events2 = null;
                    List list2 = this.buffer;
                    synchronized (list2) {
                        int bufferSize = this.buffer.size();
                        boolean bl = isActive2 = !this.parent.closed;
                        while (bufferSize == 0 && isActive2) {
                            this.buffer.wait();
                            bufferSize = this.buffer.size();
                            isActive2 = !this.parent.closed;
                        }
                        if (bufferSize > 0) {
                            events2 = new LoggingEvent[bufferSize + this.discardMap.size()];
                            this.buffer.toArray(events2);
                            int index2 = bufferSize;
                            Iterator iter2 = this.discardMap.values().iterator();
                            while (iter2.hasNext()) {
                                events2[index2++] = ((DiscardSummary)iter2.next()).createEvent();
                            }
                            this.buffer.clear();
                            this.discardMap.clear();
                            this.buffer.notifyAll();
                        }
                    }
                    if (events2 == null) continue;
                    for (int i = 0; i < events2.length; ++i) {
                        AppenderAttachableImpl appenderAttachableImpl = this.appenders;
                        synchronized (appenderAttachableImpl) {
                            this.appenders.appendLoopOnAppenders(events2[i]);
                            continue;
                        }
                    }
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static final class DiscardSummary {
        private LoggingEvent maxEvent;
        private int count;

        public DiscardSummary(LoggingEvent event) {
            this.maxEvent = event;
            this.count = 1;
        }

        public void add(LoggingEvent event) {
            if (event.getLevel().toInt() > this.maxEvent.getLevel().toInt()) {
                this.maxEvent = event;
            }
            ++this.count;
        }

        public LoggingEvent createEvent() {
            String msg = MessageFormat.format("Discarded {0} messages due to full event buffer including: {1}", new Integer(this.count), this.maxEvent.getMessage());
            return new LoggingEvent("org.apache.log4j.AsyncAppender.DONT_REPORT_LOCATION", Logger.getLogger(this.maxEvent.getLoggerName()), this.maxEvent.getLevel(), msg, null);
        }
    }
}

