/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.ProtoUtils;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractRequestResponse;
import org.apache.kafka.common.requests.LeaderAndIsrResponse;

public class LeaderAndIsrRequest
extends AbstractRequest {
    private static final Schema CURRENT_SCHEMA = ProtoUtils.currentRequestSchema(ApiKeys.LEADER_AND_ISR.id);
    private static final String CONTROLLER_ID_KEY_NAME = "controller_id";
    private static final String CONTROLLER_EPOCH_KEY_NAME = "controller_epoch";
    private static final String PARTITION_STATES_KEY_NAME = "partition_states";
    private static final String LIVE_LEADERS_KEY_NAME = "live_leaders";
    private static final String TOPIC_KEY_NAME = "topic";
    private static final String PARTITION_KEY_NAME = "partition";
    private static final String LEADER_KEY_NAME = "leader";
    private static final String LEADER_EPOCH_KEY_NAME = "leader_epoch";
    private static final String ISR_KEY_NAME = "isr";
    private static final String ZK_VERSION_KEY_NAME = "zk_version";
    private static final String REPLICAS_KEY_NAME = "replicas";
    private static final String END_POINT_ID_KEY_NAME = "id";
    private static final String HOST_KEY_NAME = "host";
    private static final String PORT_KEY_NAME = "port";
    private final int controllerId;
    private final int controllerEpoch;
    private final Map<TopicPartition, PartitionState> partitionStates;
    private final Set<EndPoint> liveLeaders;

    public LeaderAndIsrRequest(int controllerId, int controllerEpoch, Map<TopicPartition, PartitionState> partitionStates, Set<EndPoint> liveLeaders) {
        super(new Struct(CURRENT_SCHEMA));
        this.struct.set(CONTROLLER_ID_KEY_NAME, (Object)controllerId);
        this.struct.set(CONTROLLER_EPOCH_KEY_NAME, (Object)controllerEpoch);
        ArrayList<Struct> partitionStatesData = new ArrayList<Struct>(partitionStates.size());
        for (Map.Entry<TopicPartition, PartitionState> entry2 : partitionStates.entrySet()) {
            Struct partitionStateData = this.struct.instance(PARTITION_STATES_KEY_NAME);
            TopicPartition topicPartition = entry2.getKey();
            partitionStateData.set(TOPIC_KEY_NAME, (Object)topicPartition.topic());
            partitionStateData.set(PARTITION_KEY_NAME, (Object)topicPartition.partition());
            PartitionState partitionState = entry2.getValue();
            partitionStateData.set(CONTROLLER_EPOCH_KEY_NAME, (Object)partitionState.controllerEpoch);
            partitionStateData.set(LEADER_KEY_NAME, (Object)partitionState.leader);
            partitionStateData.set(LEADER_EPOCH_KEY_NAME, (Object)partitionState.leaderEpoch);
            partitionStateData.set(ISR_KEY_NAME, (Object)partitionState.isr.toArray());
            partitionStateData.set(ZK_VERSION_KEY_NAME, (Object)partitionState.zkVersion);
            partitionStateData.set(REPLICAS_KEY_NAME, (Object)partitionState.replicas.toArray());
            partitionStatesData.add(partitionStateData);
        }
        this.struct.set(PARTITION_STATES_KEY_NAME, (Object)partitionStatesData.toArray());
        ArrayList<Struct> leadersData = new ArrayList<Struct>(liveLeaders.size());
        for (EndPoint leader : liveLeaders) {
            Struct leaderData = this.struct.instance(LIVE_LEADERS_KEY_NAME);
            leaderData.set(END_POINT_ID_KEY_NAME, (Object)leader.id);
            leaderData.set(HOST_KEY_NAME, (Object)leader.host);
            leaderData.set(PORT_KEY_NAME, (Object)leader.port);
            leadersData.add(leaderData);
        }
        this.struct.set(LIVE_LEADERS_KEY_NAME, (Object)leadersData.toArray());
        this.controllerId = controllerId;
        this.controllerEpoch = controllerEpoch;
        this.partitionStates = partitionStates;
        this.liveLeaders = liveLeaders;
    }

    public LeaderAndIsrRequest(Struct struct) {
        super(struct);
        HashMap<TopicPartition, PartitionState> partitionStates = new HashMap<TopicPartition, PartitionState>();
        for (Object partitionStateDataObj : struct.getArray(PARTITION_STATES_KEY_NAME)) {
            Struct partitionStateData = (Struct)partitionStateDataObj;
            String topic = partitionStateData.getString(TOPIC_KEY_NAME);
            int partition2 = partitionStateData.getInt(PARTITION_KEY_NAME);
            int controllerEpoch = partitionStateData.getInt(CONTROLLER_EPOCH_KEY_NAME);
            int leader = partitionStateData.getInt(LEADER_KEY_NAME);
            int leaderEpoch = partitionStateData.getInt(LEADER_EPOCH_KEY_NAME);
            Object[] isrArray = partitionStateData.getArray(ISR_KEY_NAME);
            ArrayList<Integer> isr = new ArrayList<Integer>(isrArray.length);
            for (Object r : isrArray) {
                isr.add((Integer)r);
            }
            int zkVersion = partitionStateData.getInt(ZK_VERSION_KEY_NAME);
            Object[] replicasArray = partitionStateData.getArray(REPLICAS_KEY_NAME);
            HashSet<Integer> replicas = new HashSet<Integer>(replicasArray.length);
            for (Object r : replicasArray) {
                replicas.add((Integer)r);
            }
            PartitionState partitionState = new PartitionState(controllerEpoch, leader, leaderEpoch, isr, zkVersion, replicas);
            partitionStates.put(new TopicPartition(topic, partition2), partitionState);
        }
        HashSet<EndPoint> leaders = new HashSet<EndPoint>();
        for (Object leadersDataObj : struct.getArray(LIVE_LEADERS_KEY_NAME)) {
            Struct leadersData = (Struct)leadersDataObj;
            int id = leadersData.getInt(END_POINT_ID_KEY_NAME);
            String host = leadersData.getString(HOST_KEY_NAME);
            int port = leadersData.getInt(PORT_KEY_NAME);
            leaders.add(new EndPoint(id, host, port));
        }
        this.controllerId = struct.getInt(CONTROLLER_ID_KEY_NAME);
        this.controllerEpoch = struct.getInt(CONTROLLER_EPOCH_KEY_NAME);
        this.partitionStates = partitionStates;
        this.liveLeaders = leaders;
    }

    @Override
    public AbstractRequestResponse getErrorResponse(int versionId, Throwable e) {
        HashMap<TopicPartition, Short> responses = new HashMap<TopicPartition, Short>(this.partitionStates.size());
        for (TopicPartition partition2 : this.partitionStates.keySet()) {
            responses.put(partition2, Errors.forException(e).code());
        }
        switch (versionId) {
            case 0: {
                return new LeaderAndIsrResponse(Errors.NONE.code(), responses);
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ProtoUtils.latestVersion(ApiKeys.LEADER_AND_ISR.id)));
    }

    public int controllerId() {
        return this.controllerId;
    }

    public int controllerEpoch() {
        return this.controllerEpoch;
    }

    public Map<TopicPartition, PartitionState> partitionStates() {
        return this.partitionStates;
    }

    public Set<EndPoint> liveLeaders() {
        return this.liveLeaders;
    }

    public static LeaderAndIsrRequest parse(ByteBuffer buffer, int versionId) {
        return new LeaderAndIsrRequest(ProtoUtils.parseRequest(ApiKeys.LEADER_AND_ISR.id, versionId, buffer));
    }

    public static LeaderAndIsrRequest parse(ByteBuffer buffer) {
        return new LeaderAndIsrRequest((Struct)CURRENT_SCHEMA.read(buffer));
    }

    public static final class EndPoint {
        public final int id;
        public final String host;
        public final int port;

        public EndPoint(int id, String host, int port) {
            this.id = id;
            this.host = host;
            this.port = port;
        }
    }

    public static class PartitionState {
        public final int controllerEpoch;
        public final int leader;
        public final int leaderEpoch;
        public final List<Integer> isr;
        public final int zkVersion;
        public final Set<Integer> replicas;

        public PartitionState(int controllerEpoch, int leader, int leaderEpoch, List<Integer> isr, int zkVersion, Set<Integer> replicas) {
            this.controllerEpoch = controllerEpoch;
            this.leader = leader;
            this.leaderEpoch = leaderEpoch;
            this.isr = isr;
            this.zkVersion = zkVersion;
            this.replicas = replicas;
        }
    }
}

