/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

import java.io.OutputStream;
import java.nio.ByteBuffer;

public class ByteBufferOutputStream
extends OutputStream {
    private static final float REALLOCATION_FACTOR = 1.1f;
    private ByteBuffer buffer;

    public ByteBufferOutputStream(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public void write(int b) {
        if (this.buffer.remaining() < 1) {
            this.expandBuffer(this.buffer.capacity() + 1);
        }
        this.buffer.put((byte)b);
    }

    @Override
    public void write(byte[] bytes2, int off, int len) {
        if (this.buffer.remaining() < len) {
            this.expandBuffer(this.buffer.capacity() + len);
        }
        this.buffer.put(bytes2, off, len);
    }

    public ByteBuffer buffer() {
        return this.buffer;
    }

    private void expandBuffer(int size2) {
        int expandSize = Math.max((int)((float)this.buffer.capacity() * 1.1f), size2);
        ByteBuffer temp = ByteBuffer.allocate(expandSize);
        temp.put(this.buffer.array(), this.buffer.arrayOffset(), this.buffer.position());
        this.buffer = temp;
    }
}

