/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.consumer.internals.PartitionAssignor;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.SchemaException;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;

public class ConsumerProtocol {
    public static final String PROTOCOL_TYPE = "consumer";
    public static final String VERSION_KEY_NAME = "version";
    public static final String TOPICS_KEY_NAME = "topics";
    public static final String TOPIC_KEY_NAME = "topic";
    public static final String PARTITIONS_KEY_NAME = "partitions";
    public static final String TOPIC_PARTITIONS_KEY_NAME = "topic_partitions";
    public static final String USER_DATA_KEY_NAME = "user_data";
    public static final short CONSUMER_PROTOCOL_V0 = 0;
    public static final Schema CONSUMER_PROTOCOL_HEADER_SCHEMA = new Schema(new Field("version", Type.INT16));
    private static final Struct CONSUMER_PROTOCOL_HEADER_V0 = new Struct(CONSUMER_PROTOCOL_HEADER_SCHEMA).set("version", (Object)0);
    public static final Schema SUBSCRIPTION_V0 = new Schema(new Field("topics", new ArrayOf(Type.STRING)), new Field("user_data", Type.BYTES));
    public static final Schema TOPIC_ASSIGNMENT_V0 = new Schema(new Field("topic", Type.STRING), new Field("partitions", new ArrayOf(Type.INT32)));
    public static final Schema ASSIGNMENT_V0 = new Schema(new Field("topic_partitions", new ArrayOf(TOPIC_ASSIGNMENT_V0)), new Field("user_data", Type.BYTES));

    public static ByteBuffer serializeSubscription(PartitionAssignor.Subscription subscription) {
        Struct struct = new Struct(SUBSCRIPTION_V0);
        struct.set(USER_DATA_KEY_NAME, (Object)subscription.userData());
        struct.set(TOPICS_KEY_NAME, (Object)subscription.topics().toArray());
        ByteBuffer buffer = ByteBuffer.allocate(CONSUMER_PROTOCOL_HEADER_V0.sizeOf() + SUBSCRIPTION_V0.sizeOf(struct));
        CONSUMER_PROTOCOL_HEADER_V0.writeTo(buffer);
        SUBSCRIPTION_V0.write(buffer, struct);
        buffer.flip();
        return buffer;
    }

    public static PartitionAssignor.Subscription deserializeSubscription(ByteBuffer buffer) {
        Struct header = (Struct)CONSUMER_PROTOCOL_HEADER_SCHEMA.read(buffer);
        Short version = header.getShort(VERSION_KEY_NAME);
        ConsumerProtocol.checkVersionCompatibility(version);
        Struct struct = (Struct)SUBSCRIPTION_V0.read(buffer);
        ByteBuffer userData = struct.getBytes(USER_DATA_KEY_NAME);
        ArrayList<String> topics = new ArrayList<String>();
        for (Object topicObj : struct.getArray(TOPICS_KEY_NAME)) {
            topics.add((String)topicObj);
        }
        return new PartitionAssignor.Subscription(topics, userData);
    }

    public static PartitionAssignor.Assignment deserializeAssignment(ByteBuffer buffer) {
        Struct header = (Struct)CONSUMER_PROTOCOL_HEADER_SCHEMA.read(buffer);
        Short version = header.getShort(VERSION_KEY_NAME);
        ConsumerProtocol.checkVersionCompatibility(version);
        Struct struct = (Struct)ASSIGNMENT_V0.read(buffer);
        ByteBuffer userData = struct.getBytes(USER_DATA_KEY_NAME);
        ArrayList<TopicPartition> partitions = new ArrayList<TopicPartition>();
        for (Object structObj : struct.getArray(TOPIC_PARTITIONS_KEY_NAME)) {
            Struct assignment = (Struct)structObj;
            String topic = assignment.getString(TOPIC_KEY_NAME);
            for (Object partitionObj : assignment.getArray(PARTITIONS_KEY_NAME)) {
                Integer partition2 = (Integer)partitionObj;
                partitions.add(new TopicPartition(topic, partition2));
            }
        }
        return new PartitionAssignor.Assignment(partitions, userData);
    }

    public static ByteBuffer serializeAssignment(PartitionAssignor.Assignment assignment) {
        Struct struct = new Struct(ASSIGNMENT_V0);
        struct.set(USER_DATA_KEY_NAME, (Object)assignment.userData());
        ArrayList<Struct> topicAssignments = new ArrayList<Struct>();
        for (Map.Entry<String, List<Integer>> topicEntry : ConsumerProtocol.asMap(assignment.partitions()).entrySet()) {
            Struct topicAssignment = new Struct(TOPIC_ASSIGNMENT_V0);
            topicAssignment.set(TOPIC_KEY_NAME, (Object)topicEntry.getKey());
            topicAssignment.set(PARTITIONS_KEY_NAME, (Object)topicEntry.getValue().toArray());
            topicAssignments.add(topicAssignment);
        }
        struct.set(TOPIC_PARTITIONS_KEY_NAME, (Object)topicAssignments.toArray());
        ByteBuffer buffer = ByteBuffer.allocate(CONSUMER_PROTOCOL_HEADER_V0.sizeOf() + ASSIGNMENT_V0.sizeOf(struct));
        CONSUMER_PROTOCOL_HEADER_V0.writeTo(buffer);
        ASSIGNMENT_V0.write(buffer, struct);
        buffer.flip();
        return buffer;
    }

    private static void checkVersionCompatibility(short version) {
        if (version < 0) {
            throw new SchemaException("Unsupported subscription version: " + version);
        }
    }

    private static Map<String, List<Integer>> asMap(Collection<TopicPartition> partitions) {
        HashMap<String, List<Integer>> partitionMap = new HashMap<String, List<Integer>>();
        for (TopicPartition partition2 : partitions) {
            String topic = partition2.topic();
            ArrayList<Integer> topicPartitions = (ArrayList<Integer>)partitionMap.get(topic);
            if (topicPartitions == null) {
                topicPartitions = new ArrayList<Integer>();
                partitionMap.put(topic, topicPartitions);
            }
            topicPartitions.add(partition2.partition());
        }
        return partitionMap;
    }
}

