/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

public final class ConsumerRecord<K, V> {
    private final String topic;
    private final int partition;
    private final long offset;
    private final long timestamp;
    private final K key;
    private final V value;
    private final String producer;

    public ConsumerRecord(String topic, int partition2, long offset, K key, V value2) {
        if (topic == null) {
            throw new IllegalArgumentException("Topic cannot be null");
        }
        this.topic = topic;
        this.partition = partition2;
        this.offset = offset;
        this.key = key;
        this.value = value2;
        this.timestamp = 0L;
        this.producer = null;
    }

    public ConsumerRecord(String topic, int partition2, long offset, K key, V value2, long timestamp, String producer) {
        if (topic == null) {
            throw new IllegalArgumentException("Topic cannot be null");
        }
        this.topic = topic;
        this.partition = partition2;
        this.offset = offset;
        this.key = key;
        this.value = value2;
        this.timestamp = timestamp;
        this.producer = producer;
    }

    public String topic() {
        return this.topic;
    }

    public int partition() {
        return this.partition;
    }

    public K key() {
        return this.key;
    }

    public V value() {
        return this.value;
    }

    public long offset() {
        return this.offset;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public String producer() {
        return this.producer;
    }

    public String toString() {
        return "ConsumerRecord(topic = " + this.topic() + ", partition = " + this.partition() + ", offset = " + this.offset() + ", timestamp = " + this.timestamp() + ", producer = " + this.producer() + ", key = " + this.key + ", value = " + this.value + ")";
    }
}

