/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jute;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.apache.jute.BinaryInputArchive;
import org.apache.jute.CsvInputArchive;
import org.apache.jute.InputArchive;
import org.apache.jute.Record;
import org.apache.jute.XmlInputArchive;

public class RecordReader {
    private InputArchive archive;
    private static HashMap archiveFactory = new HashMap();

    private static InputArchive createArchive(InputStream in, String format2) throws IOException {
        Method factory2 = (Method)archiveFactory.get(format2);
        if (factory2 != null) {
            Object[] params2 = new Object[]{in};
            try {
                return (InputArchive)factory2.invoke(null, params2);
            }
            catch (IllegalArgumentException ex) {
                ex.printStackTrace();
            }
            catch (InvocationTargetException ex) {
                ex.printStackTrace();
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    public RecordReader(InputStream in, String format2) throws IOException {
        this.archive = RecordReader.createArchive(in, format2);
    }

    public void read(Record r) throws IOException {
        r.deserialize(this.archive, "");
    }

    static {
        Class[] params2 = new Class[]{InputStream.class};
        try {
            archiveFactory.put("binary", BinaryInputArchive.class.getDeclaredMethod("getArchive", params2));
            archiveFactory.put("csv", CsvInputArchive.class.getDeclaredMethod("getArchive", params2));
            archiveFactory.put("xml", XmlInputArchive.class.getDeclaredMethod("getArchive", params2));
        }
        catch (SecurityException ex) {
            ex.printStackTrace();
        }
        catch (NoSuchMethodException ex) {
            ex.printStackTrace();
        }
    }
}

