/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.imps;

import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.apache.curator.RetryLoop;
import org.apache.curator.TimeTrace;
import org.apache.curator.framework.api.BackgroundCallback;
import org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.curator.framework.api.CuratorEventType;
import org.apache.curator.framework.api.PathAndBytesable;
import org.apache.curator.framework.api.SetDataBackgroundVersionable;
import org.apache.curator.framework.api.SetDataBuilder;
import org.apache.curator.framework.api.transaction.CuratorTransactionBridge;
import org.apache.curator.framework.api.transaction.OperationType;
import org.apache.curator.framework.api.transaction.TransactionSetDataBuilder;
import org.apache.curator.framework.imps.BackgroundOperation;
import org.apache.curator.framework.imps.Backgrounding;
import org.apache.curator.framework.imps.CuratorEventImpl;
import org.apache.curator.framework.imps.CuratorFrameworkImpl;
import org.apache.curator.framework.imps.CuratorMultiTransactionRecord;
import org.apache.curator.framework.imps.CuratorTransactionImpl;
import org.apache.curator.framework.imps.OperationAndData;
import org.apache.curator.framework.imps.PathAndBytes;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.data.Stat;

class SetDataBuilderImpl
implements SetDataBuilder,
BackgroundOperation<PathAndBytes> {
    private final CuratorFrameworkImpl client;
    private Backgrounding backgrounding;
    private int version;
    private boolean compress;

    SetDataBuilderImpl(CuratorFrameworkImpl client) {
        this.client = client;
        this.backgrounding = new Backgrounding();
        this.version = -1;
        this.compress = false;
    }

    TransactionSetDataBuilder asTransactionSetDataBuilder(final CuratorTransactionImpl curatorTransaction, final CuratorMultiTransactionRecord transaction) {
        return new TransactionSetDataBuilder(){

            @Override
            public CuratorTransactionBridge forPath(String path, byte[] data2) throws Exception {
                if (SetDataBuilderImpl.this.compress) {
                    data2 = SetDataBuilderImpl.this.client.getCompressionProvider().compress(path, data2);
                }
                String fixedPath = SetDataBuilderImpl.this.client.fixForNamespace(path);
                transaction.add(Op.setData(fixedPath, data2, SetDataBuilderImpl.this.version), OperationType.SET_DATA, path);
                return curatorTransaction;
            }

            @Override
            public CuratorTransactionBridge forPath(String path) throws Exception {
                return this.forPath(path, SetDataBuilderImpl.this.client.getDefaultData());
            }

            @Override
            public PathAndBytesable<CuratorTransactionBridge> withVersion(int version) {
                SetDataBuilderImpl.this.withVersion(version);
                return this;
            }

            @Override
            public PathAndBytesable<CuratorTransactionBridge> compressed() {
                SetDataBuilderImpl.this.compress = true;
                return this;
            }
        };
    }

    @Override
    public SetDataBackgroundVersionable compressed() {
        this.compress = true;
        return new SetDataBackgroundVersionable(){

            @Override
            public PathAndBytesable<Stat> inBackground() {
                return SetDataBuilderImpl.this.inBackground();
            }

            @Override
            public PathAndBytesable<Stat> inBackground(BackgroundCallback callback, Object context) {
                return SetDataBuilderImpl.this.inBackground(callback, context);
            }

            @Override
            public PathAndBytesable<Stat> inBackground(BackgroundCallback callback, Object context, Executor executor) {
                return SetDataBuilderImpl.this.inBackground(callback, context, executor);
            }

            @Override
            public PathAndBytesable<Stat> inBackground(Object context) {
                return SetDataBuilderImpl.this.inBackground(context);
            }

            @Override
            public PathAndBytesable<Stat> inBackground(BackgroundCallback callback) {
                return SetDataBuilderImpl.this.inBackground(callback);
            }

            @Override
            public PathAndBytesable<Stat> inBackground(BackgroundCallback callback, Executor executor) {
                return SetDataBuilderImpl.this.inBackground(callback, executor);
            }

            @Override
            public Stat forPath(String path, byte[] data2) throws Exception {
                return SetDataBuilderImpl.this.forPath(path, data2);
            }

            @Override
            public Stat forPath(String path) throws Exception {
                return SetDataBuilderImpl.this.forPath(path);
            }

            @Override
            public BackgroundPathAndBytesable<Stat> withVersion(int version) {
                return SetDataBuilderImpl.this.withVersion(version);
            }
        };
    }

    @Override
    public BackgroundPathAndBytesable<Stat> withVersion(int version) {
        this.version = version;
        return this;
    }

    @Override
    public PathAndBytesable<Stat> inBackground(BackgroundCallback callback, Object context) {
        this.backgrounding = new Backgrounding(callback, context);
        return this;
    }

    @Override
    public PathAndBytesable<Stat> inBackground(BackgroundCallback callback, Object context, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, callback, context, executor);
        return this;
    }

    @Override
    public PathAndBytesable<Stat> inBackground(BackgroundCallback callback) {
        this.backgrounding = new Backgrounding(callback);
        return this;
    }

    @Override
    public PathAndBytesable<Stat> inBackground() {
        this.backgrounding = new Backgrounding(true);
        return this;
    }

    @Override
    public PathAndBytesable<Stat> inBackground(Object context) {
        this.backgrounding = new Backgrounding(context);
        return this;
    }

    @Override
    public PathAndBytesable<Stat> inBackground(BackgroundCallback callback, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, callback, executor);
        return this;
    }

    @Override
    public void performBackgroundOperation(final OperationAndData<PathAndBytes> operationAndData) throws Exception {
        final TimeTrace trace2 = this.client.getZookeeperClient().startTracer("SetDataBuilderImpl-Background");
        this.client.getZooKeeper().setData(operationAndData.getData().getPath(), operationAndData.getData().getData(), this.version, new AsyncCallback.StatCallback(){

            @Override
            public void processResult(int rc, String path, Object ctx, Stat stat) {
                trace2.commit();
                CuratorEventImpl event = new CuratorEventImpl(SetDataBuilderImpl.this.client, CuratorEventType.SET_DATA, rc, path, null, ctx, stat, null, null, null, null);
                SetDataBuilderImpl.this.client.processBackgroundOperation(operationAndData, event);
            }
        }, this.backgrounding.getContext());
    }

    @Override
    public Stat forPath(String path) throws Exception {
        return this.forPath(path, this.client.getDefaultData());
    }

    @Override
    public Stat forPath(String path, byte[] data2) throws Exception {
        if (this.compress) {
            data2 = this.client.getCompressionProvider().compress(path, data2);
        }
        path = this.client.fixForNamespace(path);
        Stat resultStat = null;
        if (this.backgrounding.inBackground()) {
            this.client.processBackgroundOperation(new OperationAndData<PathAndBytes>(this, new PathAndBytes(path, data2), this.backgrounding.getCallback(), null, this.backgrounding.getContext()), null);
        } else {
            resultStat = this.pathInForeground(path, data2);
        }
        return resultStat;
    }

    int getVersion() {
        return this.version;
    }

    private Stat pathInForeground(final String path, final byte[] data2) throws Exception {
        TimeTrace trace2 = this.client.getZookeeperClient().startTracer("SetDataBuilderImpl-Foreground");
        Stat resultStat = RetryLoop.callWithRetry(this.client.getZookeeperClient(), new Callable<Stat>(){

            @Override
            public Stat call() throws Exception {
                return SetDataBuilderImpl.this.client.getZooKeeper().setData(path, data2, SetDataBuilderImpl.this.version);
            }
        });
        trace2.commit();
        return resultStat;
    }
}

