/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.imps;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.apache.curator.RetryLoop;
import org.apache.curator.TimeTrace;
import org.apache.curator.framework.api.BackgroundCallback;
import org.apache.curator.framework.api.CuratorEventType;
import org.apache.curator.framework.api.GetACLBuilder;
import org.apache.curator.framework.api.Pathable;
import org.apache.curator.framework.imps.BackgroundOperation;
import org.apache.curator.framework.imps.Backgrounding;
import org.apache.curator.framework.imps.CuratorEventImpl;
import org.apache.curator.framework.imps.CuratorFrameworkImpl;
import org.apache.curator.framework.imps.OperationAndData;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;

class GetACLBuilderImpl
implements GetACLBuilder,
BackgroundOperation<String> {
    private final CuratorFrameworkImpl client;
    private Backgrounding backgrounding;
    private Stat responseStat;

    GetACLBuilderImpl(CuratorFrameworkImpl client) {
        this.client = client;
        this.backgrounding = new Backgrounding();
        this.responseStat = new Stat();
    }

    @Override
    public Pathable<List<ACL>> inBackground(BackgroundCallback callback, Object context) {
        this.backgrounding = new Backgrounding(callback, context);
        return this;
    }

    @Override
    public Pathable<List<ACL>> inBackground(BackgroundCallback callback, Object context, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, callback, context, executor);
        return this;
    }

    @Override
    public Pathable<List<ACL>> inBackground() {
        this.backgrounding = new Backgrounding(true);
        return this;
    }

    @Override
    public Pathable<List<ACL>> inBackground(Object context) {
        this.backgrounding = new Backgrounding(context);
        return this;
    }

    @Override
    public Pathable<List<ACL>> inBackground(BackgroundCallback callback) {
        this.backgrounding = new Backgrounding(callback);
        return this;
    }

    @Override
    public Pathable<List<ACL>> inBackground(BackgroundCallback callback, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, callback, executor);
        return this;
    }

    @Override
    public Pathable<List<ACL>> storingStatIn(Stat stat) {
        this.responseStat = stat;
        return this;
    }

    @Override
    public void performBackgroundOperation(final OperationAndData<String> operationAndData) throws Exception {
        final TimeTrace trace2 = this.client.getZookeeperClient().startTracer("GetACLBuilderImpl-Background");
        AsyncCallback.ACLCallback callback = new AsyncCallback.ACLCallback(){

            @Override
            public void processResult(int rc, String path, Object ctx, List<ACL> acl, Stat stat) {
                trace2.commit();
                CuratorEventImpl event = new CuratorEventImpl(GetACLBuilderImpl.this.client, CuratorEventType.GET_ACL, rc, path, null, ctx, stat, null, null, null, acl);
                GetACLBuilderImpl.this.client.processBackgroundOperation(operationAndData, event);
            }
        };
        this.client.getZooKeeper().getACL(operationAndData.getData(), this.responseStat, callback, this.backgrounding.getContext());
    }

    @Override
    public List<ACL> forPath(String path) throws Exception {
        path = this.client.fixForNamespace(path);
        List<ACL> result2 = null;
        if (this.backgrounding.inBackground()) {
            this.client.processBackgroundOperation(new OperationAndData<String>(this, path, this.backgrounding.getCallback(), null, this.backgrounding.getContext()), null);
        } else {
            result2 = this.pathInForeground(path);
        }
        return result2;
    }

    private List<ACL> pathInForeground(final String path) throws Exception {
        TimeTrace trace2 = this.client.getZookeeperClient().startTracer("GetACLBuilderImpl-Foreground");
        List<ACL> result2 = RetryLoop.callWithRetry(this.client.getZookeeperClient(), new Callable<List<ACL>>(){

            @Override
            public List<ACL> call() throws Exception {
                return GetACLBuilderImpl.this.client.getZooKeeper().getACL(path, GetACLBuilderImpl.this.responseStat);
            }
        });
        trace2.commit();
        return result2;
    }
}

