/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import kafka.common.Topic$;
import kafka.tools.StateChangeLogMerger;
import kafka.tools.StateChangeLogMerger$dateBasedOrdering$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.PriorityQueue;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.matching.Regex;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class StateChangeLogMerger$
implements Logging {
    public static final StateChangeLogMerger$ MODULE$;
    private final String dateFormatString;
    private final Regex topicPartitionRegex;
    private final Regex dateRegex;
    private final SimpleDateFormat dateFormat;
    private List<String> files;
    private String topic;
    private List<Object> partitions;
    private Date startDate;
    private Date endDate;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new StateChangeLogMerger$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        StateChangeLogMerger$ stateChangeLogMerger$ = this;
        synchronized (stateChangeLogMerger$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public String dateFormatString() {
        return this.dateFormatString;
    }

    public Regex topicPartitionRegex() {
        return this.topicPartitionRegex;
    }

    public Regex dateRegex() {
        return this.dateRegex;
    }

    public SimpleDateFormat dateFormat() {
        return this.dateFormat;
    }

    public List<String> files() {
        return this.files;
    }

    public void files_$eq(List<String> x$1) {
        this.files = x$1;
    }

    public String topic() {
        return this.topic;
    }

    public void topic_$eq(String x$1) {
        this.topic = x$1;
    }

    public List<Object> partitions() {
        return this.partitions;
    }

    public void partitions_$eq(List<Object> x$1) {
        this.partitions = x$1;
    }

    public Date startDate() {
        return this.startDate;
    }

    public void startDate_$eq(Date x$1) {
        this.startDate = x$1;
    }

    public Date endDate() {
        return this.endDate;
    }

    public void endDate_$eq(Date x$1) {
        this.endDate = x$1;
    }

    /*
     * WARNING - void declaration
     */
    public void main(String[] args2) {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec<String> filesOpt = parser.accepts("logs", "Comma separated list of state change logs or a regex for the log file names").withRequiredArg().describedAs("file1,file2,...").ofType(String.class);
        ArgumentAcceptingOptionSpec<String> regexOpt = parser.accepts("logs-regex", "Regex to match the state change log files to be merged").withRequiredArg().describedAs("for example: /tmp/state-change.log*").ofType(String.class);
        ArgumentAcceptingOptionSpec<String> topicOpt = parser.accepts("topic", "The topic whose state change logs should be merged").withRequiredArg().describedAs("topic").ofType(String.class);
        ArgumentAcceptingOptionSpec<String> partitionsOpt = parser.accepts("partitions", "Comma separated list of partition ids whose state change logs should be merged").withRequiredArg().describedAs("0,1,2,...").ofType(String.class);
        ArgumentAcceptingOptionSpec<String> startTimeOpt = parser.accepts("start-time", "The earliest timestamp of state change log entries to be merged").withRequiredArg().describedAs(new StringBuilder().append((Object)"start timestamp in the format ").append(this.dateFormat()).toString()).ofType(String.class).defaultsTo("0000-00-00 00:00:00,000", (String[])((Object[])new String[0]));
        ArgumentAcceptingOptionSpec<String> endTimeOpt = parser.accepts("end-time", "The latest timestamp of state change log entries to be merged").withRequiredArg().describedAs(new StringBuilder().append((Object)"end timestamp in the format ").append(this.dateFormat()).toString()).ofType(String.class).defaultsTo("9999-12-31 23:59:59,999", (String[])((Object[])new String[0]));
        if (args2.length == 0) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(parser, "A tool for merging the log files from several brokers to reconnstruct a unified history of what happened.");
        }
        OptionSet options = parser.parse(args2);
        if (!options.has(filesOpt) && !options.has(regexOpt) || options.has(filesOpt) && options.has(regexOpt)) {
            System.err.println(new StringBuilder().append((Object)"Provide arguments to exactly one of the two options \"").append(filesOpt).append((Object)"\" or \"").append(regexOpt).append((Object)"\"").toString());
            parser.printHelpOn(System.err);
            System.exit(1);
        }
        if (options.has(partitionsOpt) && !options.has(topicOpt)) {
            System.err.println(new StringBuilder().append((Object)"The option \"").append(topicOpt).append((Object)"\" needs to be provided an argument when specifying partition ids").toString());
            parser.printHelpOn(System.err);
            System.exit(1);
        }
        if (options.has(filesOpt)) {
            this.files_$eq(this.files().$colon$colon$colon(Predef$.MODULE$.refArrayOps((Object[])options.valueOf(filesOpt).split(",")).toList()));
        } else if (options.has(regexOpt)) {
            String regex = options.valueOf(regexOpt);
            int fileNameIndex = regex.lastIndexOf(47) + 1;
            String dirName = fileNameIndex == 0 ? "." : regex.substring(0, fileNameIndex - 1);
            Regex fileNameRegex = new Regex(regex.substring(fileNameIndex), Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            this.files_$eq(this.files().$colon$colon$colon(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])new File(dirName).listFiles()).filter(new Serializable(fileNameRegex){
                public static final long serialVersionUID = 0L;
                private final Regex fileNameRegex$1;

                public final boolean apply(File f) {
                    Option<String> option = this.fileNameRegex$1.findFirstIn(f.getName());
                    None$ none$ = None$.MODULE$;
                    return option != null ? !option.equals(none$) : none$ != null;
                }
                {
                    this.fileNameRegex$1 = fileNameRegex$1;
                }
            })).map(new Serializable(dirName){
                public static final long serialVersionUID = 0L;
                private final String dirName$1;

                public final String apply(File x$1) {
                    return new StringBuilder().append((Object)this.dirName$1).append((Object)"/").append((Object)x$1.getName()).toString();
                }
                {
                    this.dirName$1 = dirName$1;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toList()));
        }
        if (options.has(topicOpt)) {
            this.topic_$eq(options.valueOf(topicOpt));
        }
        if (options.has(partitionsOpt)) {
            this.partitions_$eq(Predef$.MODULE$.refArrayOps((Object[])options.valueOf(partitionsOpt).split(",")).toList().map(new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply(String x$2) {
                    return new StringOps(Predef$.MODULE$.augmentString(x$2)).toInt();
                }
            }, List$.MODULE$.canBuildFrom()));
            Iterable<Object> duplicatePartitions = CoreUtils$.MODULE$.duplicates(this.partitions());
            if (duplicatePartitions.nonEmpty()) {
                System.err.println(new StringOps(Predef$.MODULE$.augmentString("The list of partitions contains repeated entries: %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{duplicatePartitions.mkString(",")})));
                System.exit(1);
            }
        }
        this.startDate_$eq(this.dateFormat().parse(options.valueOf(startTimeOpt).replace('\"', ' ').trim()));
        this.endDate_$eq(this.dateFormat().parse(options.valueOf(endTimeOpt).replace('\"', ' ').trim()));
        PriorityQueue<StateChangeLogMerger.LineIterator> pqueue = new PriorityQueue<StateChangeLogMerger.LineIterator>(StateChangeLogMerger$dateBasedOrdering$.MODULE$);
        BufferedOutputStream output2 = new BufferedOutputStream(System.out, 0x100000);
        List<Iterator<String>> lineIterators = this.files().map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterator<String> apply(String x$3) {
                return Source$.MODULE$.fromFile(x$3, Codec$.MODULE$.fallbackSystemCodec()).getLines();
            }
        }, List$.MODULE$.canBuildFrom());
        ObjectRef<Nil$> lines2 = new ObjectRef<Nil$>(Nil$.MODULE$);
        lineIterators.foreach(new Serializable(lines2){
            public static final long serialVersionUID = 0L;
            private final ObjectRef lines$1;

            public final void apply(Iterator<String> itr) {
                StateChangeLogMerger.LineIterator lineItr = StateChangeLogMerger$.MODULE$.getNextLine(itr);
                if (!lineItr.isEmpty()) {
                    this.lines$1.elem = ((List)this.lines$1.elem).$colon$colon(lineItr);
                }
            }
            {
                this.lines$1 = lines$1;
            }
        });
        if (!((List)lines2.elem).isEmpty()) {
            pqueue.enqueue((List)lines2.elem);
        }
        while (true) {
            void var16_16;
            void var15_15;
            if (pqueue.isEmpty()) {
                ((OutputStream)output2).flush();
                return;
            }
            StateChangeLogMerger.LineIterator lineItr = (StateChangeLogMerger.LineIterator)var15_15.dequeue();
            var16_16.write(new StringBuilder().append((Object)lineItr.line()).append((Object)"\n").toString().getBytes());
            StateChangeLogMerger.LineIterator nextLineItr = this.getNextLine(lineItr.itr());
            if (nextLineItr.isEmpty()) continue;
            var15_15.enqueue(Predef$.MODULE$.wrapRefArray((Object[])new StateChangeLogMerger.LineIterator[]{nextLineItr}));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public StateChangeLogMerger.LineIterator getNextLine(Iterator<String> itr) {
        while (itr != null && itr.hasNext()) {
            BoxedUnit boxedUnit;
            Option<String> option;
            block5: {
                BoxedUnit boxedUnit2;
                block11: {
                    block6: {
                        block10: {
                            BoxedUnit boxedUnit3;
                            Option<Regex.Match> option2;
                            block7: {
                                block9: {
                                    Regex.Match matcher;
                                    String nextLine;
                                    block8: {
                                        nextLine = itr.next();
                                        option = this.dateRegex().findFirstIn(nextLine);
                                        if (!(option instanceof Some)) break block5;
                                        Some some = (Some)option;
                                        String d = (String)some.x();
                                        Date date = this.dateFormat().parse(d);
                                        if (!date.equals(this.startDate()) && !date.after(this.startDate()) || !date.equals(this.endDate()) && !date.before(this.endDate())) break block6;
                                        option2 = this.topicPartitionRegex().findFirstMatchIn(nextLine);
                                        if (!(option2 instanceof Some)) break block7;
                                        Some some2 = (Some)option2;
                                        matcher = (Regex.Match)some2.x();
                                        if (this.topic() == null) break block8;
                                        String string2 = this.topic();
                                        String string3 = matcher.group(1);
                                        if (string2 != null ? !string2.equals(string3) : string3 != null) break block9;
                                    }
                                    if (this.partitions().isEmpty() || this.partitions().contains(BoxesRunTime.boxToInteger(new StringOps(Predef$.MODULE$.augmentString(matcher.group(3))).toInt()))) {
                                        return new StateChangeLogMerger.LineIterator(nextLine, itr);
                                    }
                                }
                                boxedUnit3 = BoxedUnit.UNIT;
                                break block10;
                            }
                            None$ none$ = None$.MODULE$;
                            Option<Regex.Match> option3 = option2;
                            if (none$ != null ? !none$.equals(option3) : option3 != null) throw new MatchError(option2);
                            boxedUnit3 = BoxedUnit.UNIT;
                        }
                        boxedUnit2 = BoxedUnit.UNIT;
                        break block11;
                    }
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit2;
                continue;
            }
            None$ none$ = None$.MODULE$;
            Option<String> option4 = option;
            if (none$ != null ? !none$.equals(option4) : option4 != null) throw new MatchError(option);
            boxedUnit = BoxedUnit.UNIT;
        }
        return new StateChangeLogMerger.LineIterator();
    }

    private StateChangeLogMerger$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.dateFormatString = "yyyy-MM-dd HH:mm:ss,SSS";
        this.topicPartitionRegex = new Regex(new StringBuilder().append((Object)"\\[(").append((Object)Topic$.MODULE$.legalChars()).append((Object)"+),( )*([0-9]+)\\]").toString(), Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        this.dateRegex = new Regex("[0-9]{4}-[0-9]{2}-[0-9]{2} [0-9]{2}:[0-9]{2}:[0-9]{2},[0-9]{3}", Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        this.dateFormat = new SimpleDateFormat(this.dateFormatString());
        this.files = Nil$.MODULE$;
        this.topic = null;
        this.partitions = Nil$.MODULE$;
        this.startDate = null;
        this.endDate = null;
    }
}

