/*
 * Decompiled with CFR 0.152.
 */
package kafka.message;

import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.util.concurrent.atomic.AtomicLong;
import kafka.message.ByteBufferMessageSet$;
import kafka.message.CompressionCodec;
import kafka.message.InvalidMessageException;
import kafka.message.Message;
import kafka.message.Message$;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet;
import kafka.message.MessageSet$;
import kafka.message.NoCompressionCodec$;
import kafka.utils.IteratorTemplate;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005=v!B\u0001\u0003\u0011\u00039\u0011\u0001\u0006\"zi\u0016\u0014UO\u001a4fe6+7o]1hKN+GO\u0003\u0002\u0004\t\u00059Q.Z:tC\u001e,'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001A\u0011\u0001\"C\u0007\u0002\u0005\u0019)!B\u0001E\u0001\u0017\t!\")\u001f;f\u0005V4g-\u001a:NKN\u001c\u0018mZ3TKR\u001c\"!\u0003\u0007\u0011\u00055\u0001R\"\u0001\b\u000b\u0003=\tQa]2bY\u0006L!!\u0005\b\u0003\r\u0005s\u0017PU3g\u0011\u0015\u0019\u0012\u0002\"\u0001\u0015\u0003\u0019a\u0014N\\5u}Q\tq\u0001C\u0003\u0017\u0013\u0011%q#\u0001\u0004de\u0016\fG/\u001a\u000b\u00051\u0001b\u0013\u0007\u0005\u0002\u001a=5\t!D\u0003\u0002\u001c9\u0005\u0019a.[8\u000b\u0003u\tAA[1wC&\u0011qD\u0007\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\b\"B\u0011\u0016\u0001\u0004\u0011\u0013!D8gMN,GoQ8v]R,'\u000f\u0005\u0002$U5\tAE\u0003\u0002&M\u00051\u0011\r^8nS\u000eT!a\n\u0015\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002*9\u0005!Q\u000f^5m\u0013\tYCE\u0001\u0006Bi>l\u0017n\u0019'p]\u001eDQ!L\u000bA\u00029\n\u0001cY8naJ,7o]5p]\u000e{G-Z2\u0011\u0005!y\u0013B\u0001\u0019\u0003\u0005A\u0019u.\u001c9sKN\u001c\u0018n\u001c8D_\u0012,7\rC\u00033+\u0001\u00071'\u0001\u0005nKN\u001c\u0018mZ3t!\riAGN\u0005\u0003k9\u0011!\u0002\u0010:fa\u0016\fG/\u001a3?!\tAq'\u0003\u00029\u0005\t9Q*Z:tC\u001e,\u0007\"\u0002\u001e\n\t\u0003Y\u0014\u0001\u00043fKBLE/\u001a:bi>\u0014HC\u0001\u001fL!\riT\t\u0013\b\u0003}\rs!a\u0010\"\u000e\u0003\u0001S!!\u0011\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0011B\u0001#\u000f\u0003\u001d\u0001\u0018mY6bO\u0016L!AR$\u0003\u0011%#XM]1u_JT!\u0001\u0012\b\u0011\u0005!I\u0015B\u0001&\u0003\u0005AiUm]:bO\u0016\fe\u000eZ(gMN,G\u000fC\u0003Ms\u0001\u0007a'\u0001\bxe\u0006\u0004\b/\u001a:NKN\u001c\u0018mZ3\t\r9KA\u0011\u0001\u0003P\u000319(/\u001b;f\u001b\u0016\u001c8/Y4f)\u0011\u00016+\u0016,\u0011\u00055\t\u0016B\u0001*\u000f\u0005\u0011)f.\u001b;\t\u000bQk\u0005\u0019\u0001\r\u0002\r\t,hMZ3s\u0011\u0015\u0019Q\n1\u00017\u0011\u00159V\n1\u0001Y\u0003\u0019ygMZ:fiB\u0011Q\"W\u0005\u00035:\u0011A\u0001T8oO\"1a*\u0003C\u0001\tq#B\u0001U/_G\")Ak\u0017a\u00011!)ql\u0017a\u0001A\u0006iQ.Z:tC\u001e,wK]5uKJ\u0004\"\u0001C1\n\u0005\t\u0014!!D'fgN\fw-Z,sSR,'\u000fC\u0003X7\u0002\u0007\u0001L\u0002\u0003\u000b\u0005\u0001)7c\u00013gSB\u0011\u0001bZ\u0005\u0003Q\n\u0011!\"T3tg\u0006<WmU3u!\tQW.D\u0001l\u0015\taG!A\u0003vi&d7/\u0003\u0002oW\n9Aj\\4hS:<\u0007\u0002\u0003+e\u0005\u000b\u0007I\u0011\u00019\u0016\u0003aA\u0001B\u001d3\u0003\u0002\u0003\u0006I\u0001G\u0001\bEV4g-\u001a:!\u0011\u0015\u0019B\r\"\u0001u)\t)h\u000f\u0005\u0002\tI\")Ak\u001da\u00011!9\u0001\u0010\u001aa\u0001\n\u0013I\u0018!F:iC2dwn\u001e,bY&$')\u001f;f\u0007>,h\u000e^\u000b\u0002uB\u0011Qb_\u0005\u0003y:\u00111!\u00138u\u0011\u001dqH\r1A\u0005\n}\f\u0011d\u001d5bY2|wOV1mS\u0012\u0014\u0015\u0010^3D_VtGo\u0018\u0013fcR\u0019\u0001+!\u0001\t\u0011\u0005\rQ0!AA\u0002i\f1\u0001\u001f\u00132\u0011\u001d\t9\u0001\u001aQ!\ni\fac\u001d5bY2|wOV1mS\u0012\u0014\u0015\u0010^3D_VtG\u000f\t\u0005\u0007'\u0011$\t!a\u0003\u0015\u000bU\fi!a\u0004\t\r5\nI\u00011\u0001/\u0011\u0019\u0011\u0014\u0011\u0002a\u0001g!11\u0003\u001aC\u0001\u0003'!r!^A\u000b\u0003/\tI\u0002\u0003\u0004.\u0003#\u0001\rA\f\u0005\u0007C\u0005E\u0001\u0019\u0001\u0012\t\rI\n\t\u00021\u00014\u0011\u0019\u0019B\r\"\u0001\u0002\u001eQ\u0019Q/a\b\t\rI\nY\u00021\u00014\u0011\u0019\t\u0019\u0003\u001aC\u0001a\u0006Iq-\u001a;Ck\u001a4WM\u001d\u0005\u0007\u0003O!G\u0011B=\u0002#MD\u0017\r\u001c7poZ\u000bG.\u001b3CsR,7\u000fC\u0004\u0002,\u0011$\t!!\f\u0002\u000f]\u0014\u0018\u000e^3U_R9!0a\f\u0002@\u0005\u0005\u0003\u0002CA\u0019\u0003S\u0001\r!a\r\u0002\u000f\rD\u0017M\u001c8fYB!\u0011QGA\u001e\u001b\t\t9DC\u0002\u0002:i\t\u0001b\u00195b]:,Gn]\u0005\u0005\u0003{\t9D\u0001\u000bHCRDWM]5oO\nKH/Z\"iC:tW\r\u001c\u0005\u0007/\u0006%\u0002\u0019\u0001-\t\u000f\u0005\r\u0013\u0011\u0006a\u0001u\u0006!1/\u001b>f\u0011\u001d\t9\u0005\u001aC!\u0003\u0013\n\u0001\"\u001b;fe\u0006$xN]\u000b\u0002y!9\u0011Q\n3\u0005\u0002\u0005%\u0013aD:iC2dwn^%uKJ\fGo\u001c:\t\u000f\u0005EC\r\"\u0003\u0002T\u0005\u0001\u0012N\u001c;fe:\fG.\u0013;fe\u0006$xN\u001d\u000b\u0004y\u0005U\u0003BCA,\u0003\u001f\u0002\n\u00111\u0001\u0002Z\u0005I\u0011n]*iC2dwn\u001e\t\u0004\u001b\u0005m\u0013bAA/\u001d\t9!i\\8mK\u0006t\u0007\u0002CA1I\u0012\u0005A!a\u0019\u0002AY\fG.\u001b3bi\u0016lUm]:bO\u0016\u001c\u0018I\u001c3BgNLwM\\(gMN,Go\u001d\u000b\nk\u0006\u0015\u0014qMA6\u0003_Ba!IA0\u0001\u0004\u0011\u0003bBA5\u0003?\u0002\rAL\u0001\fg>,(oY3D_\u0012,7\rC\u0004\u0002n\u0005}\u0003\u0019\u0001\u0018\u0002\u0017Q\f'oZ3u\u0007>$Wm\u0019\u0005\u000b\u0003c\ny\u0006%AA\u0002\u0005e\u0013AD2p[B\f7\r^3e)>\u0004\u0018n\u0019\u0005\u0007\u0003k\"G\u0011A=\u0002\u0017ML'0Z%o\u0005f$Xm\u001d\u0005\u0007\u0003s\"G\u0011A=\u0002\u0015Y\fG.\u001b3CsR,7\u000fC\u0004\u0002~\u0011$\t%a \u0002\r\u0015\fX/\u00197t)\u0011\tI&!!\t\u0011\u0005\r\u00151\u0010a\u0001\u0003\u000b\u000bQa\u001c;iKJ\u00042!DAD\u0013\r\tII\u0004\u0002\u0004\u0003:L\bbBAGI\u0012\u0005\u0013qR\u0001\tQ\u0006\u001c\bnQ8eKR\t!\u0010C\u0005\u0002\u0014\u0012\f\n\u0011\"\u0001\u0002\u0016\u0006Qc/\u00197jI\u0006$X-T3tg\u0006<Wm]!oI\u0006\u001b8/[4o\u001f\u001a47/\u001a;tI\u0011,g-Y;mi\u0012\"TCAALU\u0011\tI&!',\u0005\u0005m\u0005\u0003BAO\u0003Ok!!a(\u000b\t\u0005\u0005\u00161U\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!*\u000f\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003S\u000byJA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011\"!,e#\u0003%I!!&\u00025%tG/\u001a:oC2LE/\u001a:bi>\u0014H\u0005Z3gCVdG\u000fJ\u0019")
public class ByteBufferMessageSet
extends MessageSet
implements Logging {
    private final ByteBuffer buffer;
    private int shallowValidByteCount;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static Iterator<MessageAndOffset> deepIterator(Message message) {
        return ByteBufferMessageSet$.MODULE$.deepIterator(message);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ByteBufferMessageSet byteBufferMessageSet = this;
        synchronized (byteBufferMessageSet) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public ByteBuffer buffer() {
        return this.buffer;
    }

    private int shallowValidByteCount() {
        return this.shallowValidByteCount;
    }

    private void shallowValidByteCount_$eq(int x$1) {
        this.shallowValidByteCount = x$1;
    }

    public ByteBuffer getBuffer() {
        return this.buffer();
    }

    private int shallowValidBytes() {
        if (this.shallowValidByteCount() < 0) {
            int bytes2 = 0;
            Iterator<MessageAndOffset> iter2 = this.internalIterator(true);
            while (iter2.hasNext()) {
                MessageAndOffset messageAndOffset = iter2.next();
                bytes2 += MessageSet$.MODULE$.entrySize(messageAndOffset.message());
            }
            this.shallowValidByteCount_$eq(bytes2);
        }
        return this.shallowValidByteCount();
    }

    @Override
    public int writeTo(GatheringByteChannel channel, long offset, int size2) {
        int written;
        this.buffer().mark();
        for (written = 0; written < this.sizeInBytes(); written += channel.write(this.buffer())) {
        }
        this.buffer().reset();
        return written;
    }

    @Override
    public Iterator<MessageAndOffset> iterator() {
        return this.internalIterator(this.internalIterator$default$1());
    }

    public Iterator<MessageAndOffset> shallowIterator() {
        return this.internalIterator(true);
    }

    private Iterator<MessageAndOffset> internalIterator(boolean isShallow) {
        return new IteratorTemplate<MessageAndOffset>(this, isShallow){
            private ByteBuffer topIter;
            private Iterator<MessageAndOffset> innerIter;
            private final boolean isShallow$1;

            private ByteBuffer topIter() {
                return this.topIter;
            }

            private void topIter_$eq(ByteBuffer x$1) {
                this.topIter = x$1;
            }

            private Iterator<MessageAndOffset> innerIter() {
                return this.innerIter;
            }

            private void innerIter_$eq(Iterator<MessageAndOffset> x$1) {
                this.innerIter = x$1;
            }

            private boolean innerDone() {
                return this.innerIter() == null || !this.innerIter().hasNext();
            }

            private MessageAndOffset makeNextOuter() {
                MessageAndOffset messageAndOffset;
                if (this.topIter().remaining() < 12) {
                    return (MessageAndOffset)this.allDone();
                }
                long offset = this.topIter().getLong();
                int size2 = this.topIter().getInt();
                if (size2 < Message$.MODULE$.MinHeaderSize()) {
                    throw new InvalidMessageException(new StringBuilder().append((Object)"Message found with corrupt size (").append(BoxesRunTime.boxToInteger(size2)).append((Object)") in shallow iterator").toString());
                }
                if (this.topIter().remaining() < size2) {
                    return (MessageAndOffset)this.allDone();
                }
                ByteBuffer message = this.topIter().slice();
                message.limit(size2);
                this.topIter().position(this.topIter().position() + size2);
                Message newMessage = new Message(message);
                if (this.isShallow$1) {
                    messageAndOffset = new MessageAndOffset(newMessage, offset);
                } else {
                    MessageAndOffset messageAndOffset2;
                    CompressionCodec compressionCodec = newMessage.compressionCodec();
                    NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
                    CompressionCodec compressionCodec2 = compressionCodec;
                    if (!(noCompressionCodec$ != null ? !noCompressionCodec$.equals(compressionCodec2) : compressionCodec2 != null)) {
                        this.innerIter_$eq(null);
                        messageAndOffset2 = new MessageAndOffset(newMessage, offset);
                    } else {
                        this.innerIter_$eq(ByteBufferMessageSet$.MODULE$.deepIterator(newMessage));
                        if (!this.innerIter().hasNext()) {
                            this.innerIter_$eq(null);
                        }
                        messageAndOffset2 = this.makeNext();
                    }
                    messageAndOffset = messageAndOffset2;
                }
                return messageAndOffset;
            }

            public MessageAndOffset makeNext() {
                return this.isShallow$1 ? this.makeNextOuter() : (this.innerDone() ? this.makeNextOuter() : this.innerIter().next());
            }
            {
                this.isShallow$1 = isShallow$1;
                this.topIter = $outer.buffer().slice();
                this.innerIter = null;
            }
        };
    }

    private boolean internalIterator$default$1() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public ByteBufferMessageSet validateMessagesAndAssignOffsets(AtomicLong offsetCounter, CompressionCodec sourceCodec, CompressionCodec targetCodec, boolean compactedTopic) {
        ByteBufferMessageSet byteBufferMessageSet;
        block8: {
            block7: {
                CompressionCodec compressionCodec = sourceCodec;
                NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
                if (compressionCodec != null ? !compressionCodec.equals(noCompressionCodec$) : noCompressionCodec$ != null) break block7;
                CompressionCodec compressionCodec2 = targetCodec;
                NoCompressionCodec$ noCompressionCodec$2 = NoCompressionCodec$.MODULE$;
                if (!(compressionCodec2 != null ? !compressionCodec2.equals(noCompressionCodec$2) : noCompressionCodec$2 != null)) break block8;
            }
            Iterator<Message> messages = this.internalIterator(false).map(new Serializable(this, compactedTopic){
                public static final long serialVersionUID = 0L;
                private final boolean compactedTopic$1;

                public final Message apply(MessageAndOffset messageAndOffset) {
                    if (this.compactedTopic$1 && !messageAndOffset.message().hasKey()) {
                        throw new InvalidMessageException("Compacted topic cannot accept message without key.");
                    }
                    return messageAndOffset.message();
                }
                {
                    this.compactedTopic$1 = compactedTopic$1;
                }
            });
            byteBufferMessageSet = new ByteBufferMessageSet(targetCodec, offsetCounter, messages.toBuffer());
            return byteBufferMessageSet;
        }
        int messagePosition = 0;
        this.buffer().mark();
        while (true) {
            if (messagePosition >= this.sizeInBytes() - MessageSet$.MODULE$.LogOverhead()) {
                this.buffer().reset();
                byteBufferMessageSet = this;
                return byteBufferMessageSet;
            }
            this.buffer().position(messagePosition);
            this.buffer().putLong(offsetCounter.getAndIncrement());
            int messageSize = this.buffer().getInt();
            int positionAfterKeySize = this.buffer().position() + Message$.MODULE$.KeySizeOffset() + Message$.MODULE$.KeySizeLength();
            if (compactedTopic && positionAfterKeySize < this.sizeInBytes()) {
                this.buffer().position(this.buffer().position() + Message$.MODULE$.KeySizeOffset());
                int keySize = this.buffer().getInt();
                if (keySize <= 0) {
                    this.buffer().reset();
                    throw new InvalidMessageException("Compacted topic cannot accept message without key.");
                }
            }
            messagePosition += MessageSet$.MODULE$.LogOverhead() + messageSize;
        }
    }

    public boolean validateMessagesAndAssignOffsets$default$4() {
        return false;
    }

    @Override
    public int sizeInBytes() {
        return this.buffer().limit();
    }

    public int validBytes() {
        return this.shallowValidBytes();
    }

    @Override
    public boolean equals(Object other) {
        boolean bl;
        Object object = other;
        if (object instanceof ByteBufferMessageSet) {
            ByteBufferMessageSet byteBufferMessageSet = (ByteBufferMessageSet)object;
            bl = this.buffer().equals(byteBufferMessageSet.buffer());
        } else {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        return this.buffer().hashCode();
    }

    public ByteBufferMessageSet(ByteBuffer buffer) {
        this.buffer = buffer;
        Logging$class.$init$(this);
        this.shallowValidByteCount = -1;
    }

    public ByteBufferMessageSet(CompressionCodec compressionCodec, Seq<Message> messages) {
        this(ByteBufferMessageSet$.MODULE$.kafka$message$ByteBufferMessageSet$$create(new AtomicLong(0L), compressionCodec, messages));
    }

    public ByteBufferMessageSet(CompressionCodec compressionCodec, AtomicLong offsetCounter, Seq<Message> messages) {
        this(ByteBufferMessageSet$.MODULE$.kafka$message$ByteBufferMessageSet$$create(offsetCounter, compressionCodec, messages));
    }

    public ByteBufferMessageSet(Seq<Message> messages) {
        this(NoCompressionCodec$.MODULE$, new AtomicLong(0L), messages);
    }
}

