/*
 * Decompiled with CFR 0.152.
 */
package kafka.message;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import kafka.common.KafkaException;
import kafka.message.ByteBufferBackedInputStream;
import kafka.message.ByteBufferMessageSet$;
import kafka.message.CompressionCodec;
import kafka.message.CompressionFactory$;
import kafka.message.InvalidMessageException;
import kafka.message.Message;
import kafka.message.Message$;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet$;
import kafka.message.MessageWriter;
import kafka.message.NoCompressionCodec$;
import kafka.utils.IteratorTemplate;
import scala.Function1;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

public final class ByteBufferMessageSet$ {
    public static final ByteBufferMessageSet$ MODULE$;

    static {
        new ByteBufferMessageSet$();
    }

    public ByteBuffer kafka$message$ByteBufferMessageSet$$create(AtomicLong offsetCounter, CompressionCodec compressionCodec, Seq<Message> messages) {
        ByteBuffer byteBuffer;
        if (messages.size() == 0) {
            byteBuffer = MessageSet$.MODULE$.Empty().buffer();
        } else {
            CompressionCodec compressionCodec2 = compressionCodec;
            NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
            if (!(compressionCodec2 != null ? !compressionCodec2.equals(noCompressionCodec$) : noCompressionCodec$ != null)) {
                ByteBuffer buffer = ByteBuffer.allocate(MessageSet$.MODULE$.messageSetSize(messages));
                messages.foreach(new Serializable(offsetCounter, buffer){
                    public static final long serialVersionUID = 0L;
                    private final AtomicLong offsetCounter$1;
                    private final ByteBuffer buffer$1;

                    public final void apply(Message message) {
                        ByteBufferMessageSet$.MODULE$.writeMessage(this.buffer$1, message, this.offsetCounter$1.getAndIncrement());
                    }
                    {
                        this.offsetCounter$1 = offsetCounter$1;
                        this.buffer$1 = buffer$1;
                    }
                });
                buffer.rewind();
                byteBuffer = buffer;
            } else {
                LongRef offset = new LongRef(-1L);
                MessageWriter messageWriter = new MessageWriter(package$.MODULE$.min(package$.MODULE$.max(MessageSet$.MODULE$.messageSetSize(messages) / 2, 1024), 65536));
                CompressionCodec x$1 = compressionCodec;
                byte[] x$2 = messageWriter.write$default$1();
                Serializable x$3 = new Serializable(offsetCounter, compressionCodec, messages, offset){
                    public static final long serialVersionUID = 0L;
                    public final AtomicLong offsetCounter$1;
                    private final CompressionCodec compressionCodec$1;
                    private final Seq messages$1;
                    public final LongRef offset$1;

                    public final void apply(OutputStream outputStream) {
                        DataOutputStream output2 = new DataOutputStream(CompressionFactory$.MODULE$.apply(this.compressionCodec$1, outputStream));
                        try {
                            this.messages$1.foreach(new Serializable(this, output2){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun.1 $outer;
                                private final DataOutputStream output$1;

                                public final void apply(Message message) {
                                    this.$outer.offset$1.elem = this.$outer.offsetCounter$1.getAndIncrement();
                                    this.output$1.writeLong(this.$outer.offset$1.elem);
                                    this.output$1.writeInt(message.size());
                                    this.output$1.write(message.buffer().array(), message.buffer().arrayOffset(), message.buffer().limit());
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.output$1 = output$1;
                                }
                            });
                            return;
                        }
                        finally {
                            output2.close();
                        }
                    }
                    {
                        this.offsetCounter$1 = offsetCounter$1;
                        this.compressionCodec$1 = compressionCodec$1;
                        this.messages$1 = messages$1;
                        this.offset$1 = offset$1;
                    }
                };
                messageWriter.write(x$2, x$1, (Function1<OutputStream, BoxedUnit>)((Object)x$3));
                ByteBuffer buffer = ByteBuffer.allocate(messageWriter.size() + MessageSet$.MODULE$.LogOverhead());
                this.writeMessage(buffer, messageWriter, offset.elem);
                buffer.rewind();
                byteBuffer = buffer;
            }
        }
        return byteBuffer;
    }

    public Iterator<MessageAndOffset> deepIterator(Message wrapperMessage) {
        return new IteratorTemplate<MessageAndOffset>(wrapperMessage){
            private final InputStream inputStream;
            private final DataInputStream compressed;

            private InputStream inputStream() {
                return this.inputStream;
            }

            private DataInputStream compressed() {
                return this.compressed;
            }

            public MessageAndOffset makeNext() {
                MessageAndOffset messageAndOffset;
                try {
                    long offset = this.compressed().readLong();
                    int size2 = this.compressed().readInt();
                    if (size2 < Message$.MODULE$.MinHeaderSize()) {
                        throw new InvalidMessageException(new StringBuilder().append((Object)"Message found with corrupt size (").append(BoxesRunTime.boxToInteger(size2)).append((Object)") in deep iterator").toString());
                    }
                    byte[] bufferArray = new byte[size2];
                    this.compressed().readFully(bufferArray, 0, size2);
                    ByteBuffer buffer = ByteBuffer.wrap(bufferArray);
                    Message newMessage = new Message(buffer);
                    messageAndOffset = new MessageAndOffset(newMessage, offset);
                }
                catch (IOException iOException) {
                    throw new KafkaException(iOException);
                }
                catch (EOFException eOFException) {
                    this.compressed().close();
                    messageAndOffset = (MessageAndOffset)this.allDone();
                }
                return messageAndOffset;
            }
            {
                this.inputStream = new ByteBufferBackedInputStream(wrapperMessage$1.payload());
                this.compressed = new DataInputStream(CompressionFactory$.MODULE$.apply(wrapperMessage$1.compressionCodec(), this.inputStream()));
            }
        };
    }

    public void writeMessage(ByteBuffer buffer, Message message, long offset) {
        buffer.putLong(offset);
        buffer.putInt(message.size());
        buffer.put(message.buffer());
        message.buffer().rewind();
    }

    public void writeMessage(ByteBuffer buffer, MessageWriter messageWriter, long offset) {
        buffer.putLong(offset);
        buffer.putInt(messageWriter.size());
        messageWriter.writeTo(buffer);
    }

    private ByteBufferMessageSet$() {
        MODULE$ = this;
    }
}

