/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kafka.common.LogCleaningAbortedException;
import kafka.common.ThreadShutdownException;
import kafka.common.TopicAndPartition;
import kafka.log.Cleaner;
import kafka.log.CleanerConfig;
import kafka.log.CleanerStats;
import kafka.log.CleanerStats$;
import kafka.log.Log;
import kafka.log.LogCleaner$;
import kafka.log.LogCleaner$CleanerThread$;
import kafka.log.LogCleanerManager;
import kafka.log.LogToClean;
import kafka.log.SkimpyOffsetMap;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$class;
import kafka.utils.Log4jController$;
import kafka.utils.Logging$class;
import kafka.utils.Pool;
import kafka.utils.ShutdownableThread;
import kafka.utils.Throttler;
import kafka.utils.Time;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Map;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric$LongIsIntegral$;
import scala.math.Ordering$Double$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\tua\u0001B\u0001\u0003\u0001\u001d\u0011!\u0002T8h\u00072,\u0017M\\3s\u0015\t\u0019A!A\u0002m_\u001eT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001\u0001B\u0004\u000b\u0011\u0005%aQ\"\u0001\u0006\u000b\u0003-\tQa]2bY\u0006L!!\u0004\u0006\u0003\r\u0005s\u0017PU3g!\ty!#D\u0001\u0011\u0015\t\tB!A\u0003vi&d7/\u0003\u0002\u0014!\t9Aj\\4hS:<\u0007CA\u000b\u0019\u001b\u00051\"BA\f\u0005\u0003\u001diW\r\u001e:jGNL!!\u0007\f\u0003#-\u000bgm[1NKR\u0014\u0018nY:He>,\b\u000f\u0003\u0005\u001c\u0001\t\u0015\r\u0011\"\u0001\u001d\u0003\u0019\u0019wN\u001c4jOV\tQ\u0004\u0005\u0002\u001f?5\t!!\u0003\u0002!\u0005\ti1\t\\3b]\u0016\u00148i\u001c8gS\u001eD\u0001B\t\u0001\u0003\u0002\u0003\u0006I!H\u0001\bG>tg-[4!\u0011!!\u0003A!b\u0001\n\u0003)\u0013a\u00027pO\u0012K'o]\u000b\u0002MA\u0019\u0011bJ\u0015\n\u0005!R!!B!se\u0006L\bC\u0001\u00160\u001b\u0005Y#B\u0001\u0017.\u0003\tIwNC\u0001/\u0003\u0011Q\u0017M^1\n\u0005AZ#\u0001\u0002$jY\u0016D\u0001B\r\u0001\u0003\u0002\u0003\u0006IAJ\u0001\tY><G)\u001b:tA!AA\u0007\u0001BC\u0002\u0013\u0005Q'\u0001\u0003m_\u001e\u001cX#\u0001\u001c\u0011\t=9\u0014hP\u0005\u0003qA\u0011A\u0001U8pYB\u0011!(P\u0007\u0002w)\u0011A\bB\u0001\u0007G>lWn\u001c8\n\u0005yZ$!\u0005+pa&\u001c\u0017I\u001c3QCJ$\u0018\u000e^5p]B\u0011a\u0004Q\u0005\u0003\u0003\n\u00111\u0001T8h\u0011!\u0019\u0005A!A!\u0002\u00131\u0014!\u00027pON\u0004\u0003\u0002C#\u0001\u0005\u0003\u0005\u000b\u0011\u0002$\u0002\tQLW.\u001a\t\u0003\u001f\u001dK!\u0001\u0013\t\u0003\tQKW.\u001a\u0005\u0006\u0015\u0002!\taS\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b1kej\u0014)\u0011\u0005y\u0001\u0001\"B\u000eJ\u0001\u0004i\u0002\"\u0002\u0013J\u0001\u00041\u0003\"\u0002\u001bJ\u0001\u00041\u0004bB#J!\u0003\u0005\rA\u0012\u0005\t%\u0002\u0011\r\u0011\"\u0001\u0003'\u0006q1\r\\3b]\u0016\u0014X*\u00198bO\u0016\u0014X#\u0001+\u0011\u0005y)\u0016B\u0001,\u0003\u0005EaunZ\"mK\u0006tWM]'b]\u0006<WM\u001d\u0005\u00071\u0002\u0001\u000b\u0011\u0002+\u0002\u001f\rdW-\u00198fe6\u000bg.Y4fe\u0002BqA\u0017\u0001C\u0002\u0013%1,A\u0005uQJ|G\u000f\u001e7feV\tA\f\u0005\u0002\u0010;&\u0011a\f\u0005\u0002\n)\"\u0014x\u000e\u001e;mKJDa\u0001\u0019\u0001!\u0002\u0013a\u0016A\u0003;ie>$H\u000f\\3sA!9!\r\u0001b\u0001\n\u0013\u0019\u0017\u0001C2mK\u0006tWM]:\u0016\u0003\u0011\u00042!\u001a6m\u001b\u00051'BA4i\u0003%IW.\\;uC\ndWM\u0003\u0002j\u0015\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005-4'AC%oI\u0016DX\rZ*fcB\u0011QN\\\u0007\u0002\u0001\u0019!q\u000e\u0001\u0003q\u00055\u0019E.Z1oKJ$\u0006N]3bIN\u0011a.\u001d\t\u0003\u001fIL!a\u001d\t\u0003%MCW\u000f\u001e3po:\f'\r\\3UQJ,\u0017\r\u001a\u0005\tk:\u0014\t\u0011)A\u0005m\u0006AA\u000f\u001b:fC\u0012LE\r\u0005\u0002\no&\u0011\u0001P\u0003\u0002\u0004\u0013:$\b\"\u0002&o\t\u0003QHC\u00017|\u0011\u0015)\u0018\u00101\u0001w\u0011\u001dihN1A\u0005By\f!\u0002\\8hO\u0016\u0014h*Y7f+\u0005y\b\u0003BA\u0001\u0003\u000fi!!a\u0001\u000b\u0007\u0005\u0015Q&\u0001\u0003mC:<\u0017\u0002BA\u0005\u0003\u0007\u0011aa\u0015;sS:<\u0007bBA\u0007]\u0002\u0006Ia`\u0001\fY><w-\u001a:OC6,\u0007\u0005C\u0005\u0002\u00129\u0014\r\u0011\"\u0001\u0002\u0014\u000591\r\\3b]\u0016\u0014XCAA\u000b!\rq\u0012qC\u0005\u0004\u00033\u0011!aB\"mK\u0006tWM\u001d\u0005\t\u0003;q\u0007\u0015!\u0003\u0002\u0016\u0005A1\r\\3b]\u0016\u0014\b\u0005C\u0005\u0002\"9\u0004\r\u0011\"\u0001\u0002$\u0005IA.Y:u'R\fGo]\u000b\u0003\u0003K\u00012AHA\u0014\u0013\r\tIC\u0001\u0002\r\u00072,\u0017M\\3s'R\fGo\u001d\u0005\n\u0003[q\u0007\u0019!C\u0001\u0003_\tQ\u0002\\1tiN#\u0018\r^:`I\u0015\fH\u0003BA\u0019\u0003o\u00012!CA\u001a\u0013\r\t)D\u0003\u0002\u0005+:LG\u000f\u0003\u0006\u0002:\u0005-\u0012\u0011!a\u0001\u0003K\t1\u0001\u001f\u00132\u0011!\tiD\u001cQ!\n\u0005\u0015\u0012A\u00037bgR\u001cF/\u0019;tA!\"\u00111HA!!\rI\u00111I\u0005\u0004\u0003\u000bR!\u0001\u0003<pY\u0006$\u0018\u000e\\3\t\u0013\u0005%cN1A\u0005\n\u0005-\u0013\u0001\u00052bG.|eMZ,bSRd\u0015\r^2i+\t\ti\u0005\u0005\u0003\u0002P\u0005eSBAA)\u0015\u0011\t\u0019&!\u0016\u0002\u0015\r|gnY;se\u0016tGOC\u0002\u0002X5\nA!\u001e;jY&!\u00111LA)\u00059\u0019u.\u001e8u\t><h\u000eT1uG\"D\u0001\"a\u0018oA\u0003%\u0011QJ\u0001\u0012E\u0006\u001c7n\u00144g/\u0006LG\u000fT1uG\"\u0004\u0003bBA2]\u0012%\u0011QM\u0001\nG\",7m\u001b#p]\u0016$B!!\r\u0002h!9\u0011\u0011NA1\u0001\u0004I\u0014!\u0005;pa&\u001c\u0017I\u001c3QCJ$\u0018\u000e^5p]\"9\u0011Q\u000e8\u0005B\u0005=\u0014A\u00023p/>\u00148\u000e\u0006\u0002\u00022!9\u00111\u000f8\u0005B\u0005=\u0014\u0001C:ikR$wn\u001e8\t\u000f\u0005]d\u000e\"\u0003\u0002p\u0005a1\r\\3b]>\u00138\u000b\\3fa\"9\u00111\u00108\u0005\u0002\u0005u\u0014a\u0003:fG>\u0014Hm\u0015;biN$B\"!\r\u0002\u0000\u0005\r\u00151SAO\u0003CCq!!!\u0002z\u0001\u0007a/\u0001\u0002jI\"A\u0011QQA=\u0001\u0004\t9)\u0001\u0003oC6,\u0007\u0003BAE\u0003\u001fs1!CAF\u0013\r\tiIC\u0001\u0007!J,G-\u001a4\n\t\u0005%\u0011\u0011\u0013\u0006\u0004\u0003\u001bS\u0001\u0002CAK\u0003s\u0002\r!a&\u0002\t\u0019\u0014x.\u001c\t\u0004\u0013\u0005e\u0015bAAN\u0015\t!Aj\u001c8h\u0011!\ty*!\u001fA\u0002\u0005]\u0015A\u0001;p\u0011!\t\u0019+!\u001fA\u0002\u0005\u0015\u0012!B:uCR\u001c\bbBAT\u0001\u0001\u0006I\u0001Z\u0001\nG2,\u0017M\\3sg\u0002Bq!a+\u0001\t\u0003\ty'A\u0004ti\u0006\u0014H/\u001e9\t\u000f\u0005M\u0004\u0001\"\u0001\u0002p!9\u0011\u0011\u0017\u0001\u0005\u0002\u0005M\u0016!D1c_J$8\t\\3b]&tw\r\u0006\u0003\u00022\u0005U\u0006bBA5\u0003_\u0003\r!\u000f\u0005\b\u0003s\u0003A\u0011AA^\u0003E)\b\u000fZ1uK\u000eCWmY6q_&tGo\u001d\u000b\u0005\u0003c\ti\fC\u0004\u0002@\u0006]\u0006\u0019A\u0015\u0002\u000f\u0011\fG/\u0019#je\"9\u00111\u0019\u0001\u0005\u0002\u0005\u0015\u0017!F1c_J$\u0018I\u001c3QCV\u001cXm\u00117fC:Lgn\u001a\u000b\u0005\u0003c\t9\rC\u0004\u0002j\u0005\u0005\u0007\u0019A\u001d\t\u000f\u0005-\u0007\u0001\"\u0001\u0002N\u0006q!/Z:v[\u0016\u001cE.Z1oS:<G\u0003BA\u0019\u0003\u001fDq!!\u001b\u0002J\u0002\u0007\u0011\bC\u0004\u0002T\u0002!\t!!6\u0002\u0019\u0005<\u0018-\u001b;DY\u0016\fg.\u001a3\u0015\u0015\u0005]\u0017Q\\Aq\u0003K\fI\u000fE\u0002\n\u00033L1!a7\u000b\u0005\u001d\u0011un\u001c7fC:D\u0001\"a8\u0002R\u0002\u0007\u0011qQ\u0001\u0006i>\u0004\u0018n\u0019\u0005\b\u0003G\f\t\u000e1\u0001w\u0003\u0011\u0001\u0018M\u001d;\t\u0011\u0005\u001d\u0018\u0011\u001ba\u0001\u0003/\u000baa\u001c4gg\u0016$\bBCAv\u0003#\u0004\n\u00111\u0001\u0002\u0018\u0006IQ.\u0019=XC&$Xj\u001d\u0005\n\u0003_\u0004\u0011\u0013!C\u0001\u0003c\fa#Y<bSR\u001cE.Z1oK\u0012$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003gTC!a&\u0002v.\u0012\u0011q\u001f\t\u0005\u0003s\u0014\u0019!\u0004\u0002\u0002|*!\u0011Q`A\u0000\u0003%)hn\u00195fG.,GMC\u0002\u0003\u0002)\t!\"\u00198o_R\fG/[8o\u0013\u0011\u0011)!a?\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cWmB\u0005\u0003\n\t\t\t\u0011#\u0001\u0003\f\u0005QAj\\4DY\u0016\fg.\u001a:\u0011\u0007y\u0011iA\u0002\u0005\u0002\u0005\u0005\u0005\t\u0012\u0001B\b'\r\u0011i\u0001\u0003\u0005\b\u0015\n5A\u0011\u0001B\n)\t\u0011Y\u0001\u0003\u0006\u0003\u0018\t5\u0011\u0013!C\u0001\u00053\t1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"TC\u0001B\u000eU\r1\u0015Q\u001f")
public class LogCleaner
implements KafkaMetricsGroup {
    private final CleanerConfig config;
    private final File[] logDirs;
    private final Pool<TopicAndPartition, Log> logs;
    public final Time kafka$log$LogCleaner$$time;
    private final LogCleanerManager cleanerManager;
    private final Throttler kafka$log$LogCleaner$$throttler;
    private final IndexedSeq<CleanerThread> kafka$log$LogCleaner$$cleaners;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static Time $lessinit$greater$default$4() {
        return LogCleaner$.MODULE$.$lessinit$greater$default$4();
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newGauge(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newMeter(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newHistogram(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newTimer(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup$class.removeMetric(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup$class.newGauge$default$3(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup$class.newMeter$default$4(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup$class.removeMetric$default$2(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup$class.newTimer$default$4(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup$class.newHistogram$default$2(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup$class.newHistogram$default$3(this);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        LogCleaner logCleaner = this;
        synchronized (logCleaner) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public CleanerConfig config() {
        return this.config;
    }

    public File[] logDirs() {
        return this.logDirs;
    }

    public Pool<TopicAndPartition, Log> logs() {
        return this.logs;
    }

    public LogCleanerManager cleanerManager() {
        return this.cleanerManager;
    }

    public Throttler kafka$log$LogCleaner$$throttler() {
        return this.kafka$log$LogCleaner$$throttler;
    }

    public IndexedSeq<CleanerThread> kafka$log$LogCleaner$$cleaners() {
        return this.kafka$log$LogCleaner$$cleaners;
    }

    public void startup() {
        this.info((Function0<String>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Starting the log cleaner";
            }
        }));
        this.kafka$log$LogCleaner$$cleaners().foreach(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(CleanerThread x$9) {
                x$9.start();
            }
        });
    }

    public void shutdown() {
        this.info((Function0<String>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Shutting down the log cleaner.";
            }
        }));
        this.kafka$log$LogCleaner$$cleaners().foreach(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(CleanerThread x$10) {
                x$10.shutdown();
            }
        });
    }

    public void abortCleaning(TopicAndPartition topicAndPartition) {
        this.cleanerManager().abortCleaning(topicAndPartition);
    }

    public void updateCheckpoints(File dataDir) {
        this.cleanerManager().updateCheckpoints(dataDir, None$.MODULE$);
    }

    public void abortAndPauseCleaning(TopicAndPartition topicAndPartition) {
        this.cleanerManager().abortAndPauseCleaning(topicAndPartition);
    }

    public void resumeCleaning(TopicAndPartition topicAndPartition) {
        this.cleanerManager().resumeCleaning(topicAndPartition);
    }

    public boolean awaitCleaned(String topic, int part, long offset, long maxWaitMs) {
        long sleepTime;
        for (long remainingWaitMs = maxWaitMs; !this.isCleaned$1(topic, part, offset) && remainingWaitMs > 0L; remainingWaitMs -= sleepTime) {
            sleepTime = package$.MODULE$.min(100L, remainingWaitMs);
            Thread.sleep(sleepTime);
        }
        return this.isCleaned$1(topic, part, offset);
    }

    public long awaitCleaned$default$4() {
        return 60000L;
    }

    private final boolean isCleaned$1(String topic$1, int part$1, long offset$1) {
        return BoxesRunTime.unboxToBoolean(this.cleanerManager().allCleanerCheckpoints().get(new TopicAndPartition(topic$1, part$1)).fold(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return false;
            }
        }, new Serializable(this, offset$1){
            public static final long serialVersionUID = 0L;
            private final long offset$1;

            public final boolean apply(long x$11) {
                return this.apply$mcZJ$sp(x$11);
            }

            public boolean apply$mcZJ$sp(long x$11) {
                return x$11 >= this.offset$1;
            }
            {
                this.offset$1 = offset$1;
            }
        }));
    }

    public LogCleaner(CleanerConfig config, File[] logDirs, Pool<TopicAndPartition, Log> logs, Time time) {
        this.config = config;
        this.logDirs = logDirs;
        this.logs = logs;
        this.kafka$log$LogCleaner$$time = time;
        Logging$class.$init$(this);
        KafkaMetricsGroup$class.$init$(this);
        this.cleanerManager = new LogCleanerManager(logDirs, logs);
        this.kafka$log$LogCleaner$$throttler = new Throttler(config.maxIoBytesPerSecond(), 300L, true, "cleaner-io", "bytes", time);
        this.kafka$log$LogCleaner$$cleaners = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), config.numThreads()).map(new $anonfun$1(this), IndexedSeq$.MODULE$.canBuildFrom());
        this.newGauge("max-buffer-utilization-percent", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public int value() {
                return (int)BoxesRunTime.unboxToDouble(((TraversableOnce)((TraversableLike)this.$outer.kafka$log$LogCleaner$$cleaners().map(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CleanerStats apply(CleanerThread x$2) {
                        return x$2.lastStats();
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).map(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(CleanerStats x$3) {
                        return (double)100 * x$3.bufferUtilization();
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).max(Ordering$Double$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge("cleaner-recopy-percent", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public int value() {
                IndexedSeq<CleanerStats> stats = this.$outer.kafka$log$LogCleaner$$cleaners().map(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CleanerStats apply(CleanerThread x$4) {
                        return x$4.lastStats();
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                double recopyRate = (double)BoxesRunTime.unboxToLong(((TraversableOnce)stats.map(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(CleanerStats x$5) {
                        return x$5.bytesWritten();
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).sum(Numeric$LongIsIntegral$.MODULE$)) / (double)package$.MODULE$.max(BoxesRunTime.unboxToLong(((TraversableOnce)stats.map(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(CleanerStats x$6) {
                        return x$6.bytesRead();
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).sum(Numeric$LongIsIntegral$.MODULE$)), 1L);
                return (int)((double)100 * recopyRate);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge("max-clean-time-secs", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public int value() {
                return (int)BoxesRunTime.unboxToDouble(((TraversableOnce)((TraversableLike)this.$outer.kafka$log$LogCleaner$$cleaners().map(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CleanerStats apply(CleanerThread x$7) {
                        return x$7.lastStats();
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).map(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(CleanerStats x$8) {
                        return x$8.elapsedSecs();
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).max(Ordering$Double$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
    }

    public class CleanerThread
    extends ShutdownableThread {
        private final String loggerName;
        private final Cleaner cleaner;
        private volatile CleanerStats lastStats;
        private final CountDownLatch backOffWaitLatch;

        @Override
        public String loggerName() {
            return this.loggerName;
        }

        public Cleaner cleaner() {
            return this.cleaner;
        }

        public CleanerStats lastStats() {
            return this.lastStats;
        }

        public void lastStats_$eq(CleanerStats x$1) {
            this.lastStats = x$1;
        }

        private CountDownLatch backOffWaitLatch() {
            return this.backOffWaitLatch;
        }

        public void kafka$log$LogCleaner$CleanerThread$$checkDone(TopicAndPartition topicAndPartition) {
            if (this.isRunning().get()) {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().checkCleaningAborted(topicAndPartition);
                return;
            }
            throw new ThreadShutdownException();
        }

        @Override
        public void doWork() {
            this.cleanOrSleep();
        }

        @Override
        public void shutdown() {
            this.initiateShutdown();
            this.backOffWaitLatch().countDown();
            this.awaitShutdown();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void cleanOrSleep() {
            BoxedUnit boxedUnit;
            Option<LogToClean> option = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().grabFilthiestLog();
            None$ none$ = None$.MODULE$;
            Option<LogToClean> option2 = option;
            if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
                this.backOffWaitLatch().await(this.kafka$log$LogCleaner$CleanerThread$$$outer().config().backOffMs(), TimeUnit.MILLISECONDS);
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                return;
            }
            if (!(option instanceof Some)) throw new MatchError(option);
            Some some = (Some)option;
            LogToClean cleanable = (LogToClean)some.x();
            long endOffset = cleanable.firstDirtyOffset();
            try {
                endOffset = this.cleaner().clean(cleanable);
                this.recordStats(this.cleaner().id(), cleanable.log().name(), cleanable.firstDirtyOffset(), endOffset, this.cleaner().stats());
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (LogCleaningAbortedException logCleaningAbortedException) {
                boxedUnit = BoxedUnit.UNIT;
            }
            finally {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneCleaning(cleanable.topicPartition(), cleanable.log().dir().getParentFile(), endOffset);
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }

        public void recordStats(int id, String name, long from2, long to2, CleanerStats stats) {
            this.lastStats_$eq(stats);
            this.cleaner().statsUnderlying().swap();
            String message = new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("%n\tLog cleaner thread %d cleaned log %s (dirty section = [%d, %d])%n")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(id), name, BoxesRunTime.boxToLong(from2), BoxesRunTime.boxToLong(to2)}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("\t%,.1f MB of log processed in %,.1f seconds (%,.1f MB/sec).%n")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToDouble(this.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble(stats.elapsedSecs()), BoxesRunTime.boxToDouble(this.mb$1((double)stats.bytesRead() / stats.elapsedSecs()))}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("\tIndexed %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToDouble(this.mb$1(stats.mapBytesRead())), BoxesRunTime.boxToDouble(stats.elapsedIndexSecs()), BoxesRunTime.boxToDouble(this.mb$1(stats.mapBytesRead()) / stats.elapsedIndexSecs()), BoxesRunTime.boxToDouble((double)100 * stats.elapsedIndexSecs() / stats.elapsedSecs())}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("\tBuffer utilization: %.1f%%%n")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToDouble((double)100 * stats.bufferUtilization())}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("\tCleaned %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToDouble(this.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble(stats.elapsedSecs() - stats.elapsedIndexSecs()), BoxesRunTime.boxToDouble(this.mb$1(stats.bytesRead()) / (stats.elapsedSecs() - stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)100 * (stats.elapsedSecs() - stats.elapsedIndexSecs()) / stats.elapsedSecs())}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("\tStart size: %,.1f MB (%,d messages)%n")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToDouble(this.mb$1(stats.bytesRead())), BoxesRunTime.boxToLong(stats.messagesRead())}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("\tEnd size: %,.1f MB (%,d messages)%n")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToDouble(this.mb$1(stats.bytesWritten())), BoxesRunTime.boxToLong(stats.messagesWritten())}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("\t%.1f%% size reduction (%.1f%% fewer messages)%n")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToDouble(100.0 * (1.0 - (double)stats.bytesWritten() / (double)stats.bytesRead())), BoxesRunTime.boxToDouble(100.0 * (1.0 - (double)stats.messagesWritten() / (double)stats.messagesRead()))}))).toString();
            this.info((Function0<String>)((Object)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$1;

                public final String apply() {
                    return this.message$1;
                }
                {
                    this.message$1 = message$1;
                }
            }));
            if (stats.invalidMessagesRead() > 0L) {
                this.warn((Function0<String>)((Object)new Serializable(this, stats){
                    public static final long serialVersionUID = 0L;
                    private final CleanerStats stats$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("\tFound %d invalid messages during compaction.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.stats$1.invalidMessagesRead())}));
                    }
                    {
                        this.stats$1 = stats$1;
                    }
                }));
            }
        }

        public /* synthetic */ LogCleaner kafka$log$LogCleaner$CleanerThread$$$outer() {
            return LogCleaner.this;
        }

        private final double mb$1(double bytes2) {
            return bytes2 / (double)0x100000;
        }

        public CleanerThread(int threadId) {
            if (LogCleaner.this == null) {
                throw new NullPointerException();
            }
            super(new StringBuilder().append((Object)"kafka-log-cleaner-thread-").append(BoxesRunTime.boxToInteger(threadId)).toString(), false);
            this.loggerName = LogCleaner.class.getName();
            if (LogCleaner.this.config().dedupeBufferSize() / (long)LogCleaner.this.config().numThreads() > Integer.MAX_VALUE) {
                this.warn((Function0<String>)((Object)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Cannot use more than 2G of cleaner buffer space per cleaner thread, ignoring excess buffer space...";
                    }
                }));
            }
            this.cleaner = new Cleaner(threadId, new SkimpyOffsetMap((int)package$.MODULE$.min(LogCleaner.this.config().dedupeBufferSize() / (long)LogCleaner.this.config().numThreads(), (long)Integer.MAX_VALUE), LogCleaner.this.config().hashAlgorithm()), LogCleaner.this.config().ioBufferSize() / LogCleaner.this.config().numThreads() / 2, LogCleaner.this.config().maxMessageSize(), LogCleaner.this.config().dedupeBufferLoadFactor(), LogCleaner.this.kafka$log$LogCleaner$$throttler(), LogCleaner.this.kafka$log$LogCleaner$$time, new CleanerThread$$anonfun$6(this));
            this.lastStats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
            this.backOffWaitLatch = new CountDownLatch(1);
        }
    }
}

