/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.DataOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Date;
import kafka.common.LogCleaningAbortedException;
import kafka.common.TopicAndPartition;
import kafka.log.Cleaner$;
import kafka.log.CleanerStats;
import kafka.log.FileMessageSet;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogCleaner;
import kafka.log.LogSegment;
import kafka.log.LogToClean;
import kafka.log.OffsetIndex;
import kafka.log.OffsetMap;
import kafka.message.ByteBufferMessageSet;
import kafka.message.ByteBufferMessageSet$;
import kafka.message.CompressionCodec;
import kafka.message.CompressionFactory$;
import kafka.message.Message;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet$;
import kafka.message.MessageWriter;
import kafka.message.NoCompressionCodec$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Throttler;
import kafka.utils.Time;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005eh!B\u0001\u0003\u0001\t1!aB\"mK\u0006tWM\u001d\u0006\u0003\u0007\u0011\t1\u0001\\8h\u0015\u0005)\u0011!B6bM.\f7c\u0001\u0001\b\u001bA\u0011\u0001bC\u0007\u0002\u0013)\t!\"A\u0003tG\u0006d\u0017-\u0003\u0002\r\u0013\t1\u0011I\\=SK\u001a\u0004\"AD\t\u000e\u0003=Q!\u0001\u0005\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005Iy!a\u0002'pO\u001eLgn\u001a\u0005\t)\u0001\u0011)\u0019!C\u0001-\u0005\u0011\u0011\u000eZ\u0002\u0001+\u00059\u0002C\u0001\u0005\u0019\u0013\tI\u0012BA\u0002J]RD\u0001b\u0007\u0001\u0003\u0002\u0003\u0006IaF\u0001\u0004S\u0012\u0004\u0003\u0002C\u000f\u0001\u0005\u000b\u0007I\u0011\u0001\u0010\u0002\u0013=4gm]3u\u001b\u0006\u0004X#A\u0010\u0011\u0005\u0001\nS\"\u0001\u0002\n\u0005\t\u0012!!C(gMN,G/T1q\u0011!!\u0003A!A!\u0002\u0013y\u0012AC8gMN,G/T1qA!Aa\u0005\u0001B\u0001B\u0003%q#\u0001\u0007j_\n+hMZ3s'&TX\r\u0003\u0005)\u0001\t\u0005\t\u0015!\u0003\u0018\u0003=i\u0017\r_%p\u0005V4g-\u001a:TSj,\u0007\u0002\u0003\u0016\u0001\u0005\u0003\u0005\u000b\u0011B\u0016\u0002'\u0011,\bOQ;gM\u0016\u0014Hj\\1e\r\u0006\u001cGo\u001c:\u0011\u0005!a\u0013BA\u0017\n\u0005\u0019!u.\u001e2mK\"Aq\u0006\u0001B\u0001B\u0003%\u0001'A\u0005uQJ|G\u000f\u001e7feB\u0011a\"M\u0005\u0003e=\u0011\u0011\u0002\u00165s_R$H.\u001a:\t\u0011Q\u0002!\u0011!Q\u0001\nU\nA\u0001^5nKB\u0011aBN\u0005\u0003o=\u0011A\u0001V5nK\"A\u0011\b\u0001B\u0001B\u0003%!(A\u0005dQ\u0016\u001c7\u000eR8oKB!\u0001bO\u001fD\u0013\ta\u0014BA\u0005Gk:\u001cG/[8ocA\u0011a(Q\u0007\u0002\u007f)\u0011\u0001\tB\u0001\u0007G>lWn\u001c8\n\u0005\t{$!\u0005+pa&\u001c\u0017I\u001c3QCJ$\u0018\u000e^5p]B\u0011\u0001\u0002R\u0005\u0003\u000b&\u0011A!\u00168ji\")q\t\u0001C\u0001\u0011\u00061A(\u001b8jiz\"\u0012\"\u0013&L\u00196su\nU)\u0011\u0005\u0001\u0002\u0001\"\u0002\u000bG\u0001\u00049\u0002\"B\u000fG\u0001\u0004y\u0002\"\u0002\u0014G\u0001\u00049\u0002\"\u0002\u0015G\u0001\u00049\u0002\"\u0002\u0016G\u0001\u0004Y\u0003\"B\u0018G\u0001\u0004\u0001\u0004\"\u0002\u001bG\u0001\u0004)\u0004\"B\u001dG\u0001\u0004Q\u0004bB*\u0001\u0005\u0004%\t\u0005V\u0001\u000bY><w-\u001a:OC6,W#A+\u0011\u0005Y[V\"A,\u000b\u0005aK\u0016\u0001\u00027b]\u001eT\u0011AW\u0001\u0005U\u00064\u0018-\u0003\u0002]/\n11\u000b\u001e:j]\u001eDaA\u0018\u0001!\u0002\u0013)\u0016a\u00037pO\u001e,'OT1nK\u0002Bq\u0001\u0019\u0001C\u0002\u0013\u0005\u0011-A\bti\u0006$8/\u00168eKJd\u00170\u001b8h+\u0005\u0011\u0007\u0003\u0002\u0005dK\u0016L!\u0001Z\u0005\u0003\rQ+\b\u000f\\33!\t\u0001c-\u0003\u0002h\u0005\ta1\t\\3b]\u0016\u00148\u000b^1ug\"1\u0011\u000e\u0001Q\u0001\n\t\f\u0001c\u001d;biN,f\u000eZ3sYfLgn\u001a\u0011\t\u000b-\u0004A\u0011\u00017\u0002\u000bM$\u0018\r^:\u0016\u0003\u0015DqA\u001c\u0001A\u0002\u0013%q.\u0001\u0006sK\u0006$')\u001e4gKJ,\u0012\u0001\u001d\t\u0003cRl\u0011A\u001d\u0006\u0003gf\u000b1A\\5p\u0013\t)(O\u0001\u0006CsR,')\u001e4gKJDqa\u001e\u0001A\u0002\u0013%\u00010\u0001\bsK\u0006$')\u001e4gKJ|F%Z9\u0015\u0005\rK\bb\u0002>w\u0003\u0003\u0005\r\u0001]\u0001\u0004q\u0012\n\u0004B\u0002?\u0001A\u0003&\u0001/A\u0006sK\u0006$')\u001e4gKJ\u0004\u0003b\u0002@\u0001\u0001\u0004%Ia\\\u0001\foJLG/\u001a\"vM\u001a,'\u000fC\u0005\u0002\u0002\u0001\u0001\r\u0011\"\u0003\u0002\u0004\u0005yqO]5uK\n+hMZ3s?\u0012*\u0017\u000fF\u0002D\u0003\u000bAqA_@\u0002\u0002\u0003\u0007\u0001\u000fC\u0004\u0002\n\u0001\u0001\u000b\u0015\u00029\u0002\u0019]\u0014\u0018\u000e^3Ck\u001a4WM\u001d\u0011\t\u0011\u00055\u0001\u0001\"\u0001\u0003\u0003\u001f\tQa\u00197fC:$B!!\u0005\u0002\u0018A\u0019\u0001\"a\u0005\n\u0007\u0005U\u0011B\u0001\u0003M_:<\u0007\u0002CA\r\u0003\u0017\u0001\r!a\u0007\u0002\u0013\rdW-\u00198bE2,\u0007c\u0001\u0011\u0002\u001e%\u0019\u0011q\u0004\u0002\u0003\u00151{w\rV8DY\u0016\fg\u000e\u0003\u0005\u0002$\u0001!\tAAA\u0013\u00035\u0019G.Z1o'\u0016<W.\u001a8ugRI1)a\n\u00020\u0005\u0015\u0013\u0011\n\u0005\b\u0007\u0005\u0005\u0002\u0019AA\u0015!\r\u0001\u00131F\u0005\u0004\u0003[\u0011!a\u0001'pO\"A\u0011\u0011GA\u0011\u0001\u0004\t\u0019$\u0001\u0005tK\u001elWM\u001c;t!\u0019\t)$a\u000f\u0002@5\u0011\u0011q\u0007\u0006\u0004\u0003sI\u0011AC2pY2,7\r^5p]&!\u0011QHA\u001c\u0005\r\u0019V-\u001d\t\u0004A\u0005\u0005\u0013bAA\"\u0005\tQAj\\4TK\u001elWM\u001c;\t\u000f\u0005\u001d\u0013\u0011\u0005a\u0001?\u0005\u0019Q.\u00199\t\u0011\u0005-\u0013\u0011\u0005a\u0001\u0003#\tq\u0002Z3mKR,\u0007j\u001c:ju>tWj\u001d\u0005\t\u0003\u001f\u0002A\u0011\u0001\u0002\u0002R\u0005I1\r\\3b]&sGo\u001c\u000b\f\u0007\u0006M\u0013qKA.\u0003?\n\t\u0007C\u0004\u0002V\u00055\u0003\u0019A\u001f\u0002#Q|\u0007/[2B]\u0012\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0005\u0002Z\u00055\u0003\u0019AA \u0003\u0019\u0019x.\u001e:dK\"A\u0011QLA'\u0001\u0004\ty$\u0001\u0003eKN$\bbBA$\u0003\u001b\u0002\ra\b\u0005\t\u0003G\ni\u00051\u0001\u0002f\u0005i!/\u001a;bS:$U\r\\3uKN\u00042\u0001CA4\u0013\r\tI'\u0003\u0002\b\u0005>|G.Z1o\u0011\u001d\ti\u0007\u0001C\u0005\u0003_\n\u0001cY8naJ,7o]'fgN\fw-Z:\u0015\u000f\r\u000b\t(!\u001e\u0002\u0006\"9\u00111OA6\u0001\u0004\u0001\u0018A\u00022vM\u001a,'\u000f\u0003\u0005\u0002x\u0005-\u0004\u0019AA=\u0003A\u0019w.\u001c9sKN\u001c\u0018n\u001c8D_\u0012,7\r\u0005\u0003\u0002|\u0005\u0005UBAA?\u0015\r\ty\bB\u0001\b[\u0016\u001c8/Y4f\u0013\u0011\t\u0019)! \u0003!\r{W\u000e\u001d:fgNLwN\\\"pI\u0016\u001c\u0007\u0002CAD\u0003W\u0002\r!!#\u0002\u00115,7o]1hKN\u0004b!!\u000e\u0002<\u0005-\u0005\u0003BA>\u0003\u001bKA!a$\u0002~\t\u0001R*Z:tC\u001e,\u0017I\u001c3PM\u001a\u001cX\r\u001e\u0005\b\u0003'\u0003A\u0011BAK\u0003M\u0019\bn\\;mIJ+G/Y5o\u001b\u0016\u001c8/Y4f))\t)'a&\u0002\u001a\u0006m\u0015Q\u0014\u0005\t\u00033\n\t\n1\u0001\u0002@!9\u0011qIAI\u0001\u0004y\u0002\u0002CA2\u0003#\u0003\r!!\u001a\t\u0011\u0005}\u0015\u0011\u0013a\u0001\u0003\u0017\u000bQ!\u001a8uefDq!a)\u0001\t\u0003\t)+A\u0006he><()\u001e4gKJ\u001cH#A\"\t\u000f\u0005%\u0006\u0001\"\u0001\u0002&\u0006q!/Z:u_J,')\u001e4gKJ\u001c\b\u0002CAW\u0001\u0011\u0005!!a,\u0002'\u001d\u0014x.\u001e9TK\u001elWM\u001c;t\u0005f\u001c\u0016N_3\u0015\u0011\u0005E\u0016\u0011ZAi\u0003+\u0004b!a-\u0002D\u0006Mb\u0002BA[\u0003\u007fsA!a.\u0002>6\u0011\u0011\u0011\u0018\u0006\u0004\u0003w+\u0012A\u0002\u001fs_>$h(C\u0001\u000b\u0013\r\t\t-C\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t)-a2\u0003\t1K7\u000f\u001e\u0006\u0004\u0003\u0003L\u0001\u0002CA\u0019\u0003W\u0003\r!a3\u0011\r\u0005U\u0012QZA \u0013\u0011\ty-a\u000e\u0003\u0011%#XM]1cY\u0016Dq!a5\u0002,\u0002\u0007q#A\u0004nCb\u001c\u0016N_3\t\u000f\u0005]\u00171\u0016a\u0001/\u0005aQ.\u0019=J]\u0012,\u0007pU5{K\"A\u00111\u001c\u0001\u0005\u0002\t\ti.\u0001\bck&dGm\u00144gg\u0016$X*\u00199\u0015\u0015\u0005E\u0011q\\Aq\u0003K\fI\u000fC\u0004\u0004\u00033\u0004\r!!\u000b\t\u0011\u0005\r\u0018\u0011\u001ca\u0001\u0003#\tQa\u001d;beRD\u0001\"a:\u0002Z\u0002\u0007\u0011\u0011C\u0001\u0004K:$\u0007bBA$\u00033\u0004\ra\b\u0005\b\u0003[\u0004A\u0011BAx\u0003a\u0011W/\u001b7e\u001f\u001a47/\u001a;NCB4uN]*fO6,g\u000e\u001e\u000b\t\u0003#\t\t0a=\u0002x\"9\u0011QKAv\u0001\u0004i\u0004\u0002CA{\u0003W\u0004\r!a\u0010\u0002\u000fM,w-\\3oi\"9\u0011qIAv\u0001\u0004y\u0002")
public class Cleaner
implements Logging {
    private final int id;
    private final OffsetMap offsetMap;
    private final int ioBufferSize;
    private final int maxIoBufferSize;
    private final double dupBufferLoadFactor;
    private final Throttler throttler;
    private final Time time;
    public final Function1<TopicAndPartition, BoxedUnit> kafka$log$Cleaner$$checkDone;
    private final String loggerName;
    private final Tuple2<CleanerStats, CleanerStats> statsUnderlying;
    private ByteBuffer kafka$log$Cleaner$$readBuffer;
    private ByteBuffer kafka$log$Cleaner$$writeBuffer;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        Cleaner cleaner = this;
        synchronized (cleaner) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public int id() {
        return this.id;
    }

    public OffsetMap offsetMap() {
        return this.offsetMap;
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    public Tuple2<CleanerStats, CleanerStats> statsUnderlying() {
        return this.statsUnderlying;
    }

    public CleanerStats stats() {
        return this.statsUnderlying()._1();
    }

    public ByteBuffer kafka$log$Cleaner$$readBuffer() {
        return this.kafka$log$Cleaner$$readBuffer;
    }

    private void kafka$log$Cleaner$$readBuffer_$eq(ByteBuffer x$1) {
        this.kafka$log$Cleaner$$readBuffer = x$1;
    }

    public ByteBuffer kafka$log$Cleaner$$writeBuffer() {
        return this.kafka$log$Cleaner$$writeBuffer;
    }

    private void kafka$log$Cleaner$$writeBuffer_$eq(ByteBuffer x$1) {
        this.kafka$log$Cleaner$$writeBuffer = x$1;
    }

    public long clean(LogToClean cleanable) {
        Option option;
        block4: {
            long l;
            long endOffset;
            Log log2;
            block3: {
                block2: {
                    this.stats().clear();
                    this.info((Function0<String>)((Object)new Serializable(this, cleanable){
                        public static final long serialVersionUID = 0L;
                        private final LogToClean cleanable$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Beginning cleaning of log %s.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.cleanable$1.log().name()}));
                        }
                        {
                            this.cleanable$1 = cleanable$1;
                        }
                    }));
                    log2 = cleanable.log();
                    this.info((Function0<String>)((Object)new Serializable(this, cleanable){
                        public static final long serialVersionUID = 0L;
                        private final LogToClean cleanable$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Building offset map for %s...")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.cleanable$1.log().name()}));
                        }
                        {
                            this.cleanable$1 = cleanable$1;
                        }
                    }));
                    long upperBoundOffset = log2.activeSegment().baseOffset();
                    endOffset = this.buildOffsetMap(log2, cleanable.firstDirtyOffset(), upperBoundOffset, this.offsetMap()) + 1L;
                    this.stats().indexDone();
                    option = log2.logSegments(0L, cleanable.firstDirtyOffset()).lastOption();
                    None$ none$ = None$.MODULE$;
                    Option option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block2;
                    l = 0L;
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                LogSegment seg = (LogSegment)some.x();
                l = seg.lastModified() - Predef$.MODULE$.Long2long(log2.config().deleteRetentionMs());
            }
            long deleteHorizonMs = l;
            this.info((Function0<String>)((Object)new Serializable(this, log2, deleteHorizonMs){
                public static final long serialVersionUID = 0L;
                private final Log log$1;
                private final long deleteHorizonMs$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Cleaning log %s (discarding tombstones prior to %s)...")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.log$1.name(), new Date(this.deleteHorizonMs$1)}));
                }
                {
                    this.log$1 = log$1;
                    this.deleteHorizonMs$1 = deleteHorizonMs$1;
                }
            }));
            this.groupSegmentsBySize(log2.logSegments(0L, endOffset), Predef$.MODULE$.Integer2int(log2.config().segmentSize()), Predef$.MODULE$.Integer2int(log2.config().maxIndexSize())).foreach(new Serializable(this, log2, deleteHorizonMs){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Cleaner $outer;
                private final Log log$1;
                private final long deleteHorizonMs$1;

                public final void apply(Seq<LogSegment> group) {
                    this.$outer.cleanSegments(this.log$1, group, this.$outer.offsetMap(), this.deleteHorizonMs$1);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.log$1 = log$1;
                    this.deleteHorizonMs$1 = deleteHorizonMs$1;
                }
            });
            this.stats().bufferUtilization_$eq(this.offsetMap().utilization());
            this.stats().allDone();
            return endOffset;
        }
        throw new MatchError(option);
    }

    public void cleanSegments(Log log2, Seq<LogSegment> segments2, OffsetMap map2, long deleteHorizonMs) {
        File logFile = new File(new StringBuilder().append((Object)((LogSegment)segments2.head()).log().file().getPath()).append((Object)Log$.MODULE$.CleanedFileSuffix()).toString());
        logFile.delete();
        File indexFile = new File(new StringBuilder().append((Object)((LogSegment)segments2.head()).index().file().getPath()).append((Object)Log$.MODULE$.CleanedFileSuffix()).toString());
        indexFile.delete();
        FileMessageSet messages = new FileMessageSet(logFile, false, log2.initFileSize(), log2.config().preallocate());
        OffsetIndex index2 = new OffsetIndex(indexFile, ((LogSegment)segments2.head()).baseOffset(), ((LogSegment)segments2.head()).index().maxIndexSize());
        LogSegment cleaned = new LogSegment(messages, index2, ((LogSegment)segments2.head()).baseOffset(), ((LogSegment)segments2.head()).indexIntervalBytes(), log2.config().randomSegmentJitter(), this.time);
        try {
            segments2.foreach(new Serializable(this, log2, map2, deleteHorizonMs, cleaned){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Cleaner $outer;
                public final Log log$3;
                private final OffsetMap map$2;
                private final long deleteHorizonMs$2;
                public final LogSegment cleaned$1;

                public final void apply(LogSegment old) {
                    boolean retainDeletes = old.lastModified() > this.deleteHorizonMs$2;
                    this.$outer.info((Function0<String>)((Object)new Serializable(this, old, retainDeletes){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$cleanSegments$1 $outer;
                        private final LogSegment old$1;
                        private final boolean retainDeletes$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Cleaning segment %s in log %s (last modified %s) into %s, %s deletes.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.old$1.baseOffset()), this.$outer.log$3.name(), new Date(this.old$1.lastModified()), BoxesRunTime.boxToLong(this.$outer.cleaned$1.baseOffset()), this.retainDeletes$1 ? "retaining" : "discarding"}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.old$1 = old$1;
                            this.retainDeletes$1 = retainDeletes$1;
                        }
                    }));
                    this.$outer.cleanInto(this.log$3.topicAndPartition(), old, this.cleaned$1, this.map$2, retainDeletes);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.log$3 = log$3;
                    this.map$2 = map$2;
                    this.deleteHorizonMs$2 = deleteHorizonMs$2;
                    this.cleaned$1 = cleaned$1;
                }
            });
            index2.trimToValidSize();
            cleaned.flush();
            long modified = ((LogSegment)segments2.last()).lastModified();
            cleaned.lastModified_$eq(modified);
            this.info((Function0<String>)((Object)new Serializable(this, log2, segments2, cleaned){
                public static final long serialVersionUID = 0L;
                private final Log log$3;
                private final Seq segments$1;
                private final LogSegment cleaned$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Swapping in cleaned segment %d for segment(s) %s in log %s.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.cleaned$1.baseOffset()), ((TraversableOnce)this.segments$1.map(new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(LogSegment x$12) {
                            return x$12.baseOffset();
                        }
                    }, Seq$.MODULE$.canBuildFrom())).mkString(","), this.log$3.name()}));
                }
                {
                    this.log$3 = log$3;
                    this.segments$1 = segments$1;
                    this.cleaned$1 = cleaned$1;
                }
            }));
            log2.replaceSegments(cleaned, segments2, log2.replaceSegments$default$3());
            return;
        }
        catch (LogCleaningAbortedException logCleaningAbortedException) {
            cleaned.delete();
            throw logCleaningAbortedException;
        }
    }

    public void cleanInto(TopicAndPartition topicAndPartition, LogSegment source, LogSegment dest, OffsetMap map2, boolean retainDeletes) {
        int position = 0;
        while (position < source.log().sizeInBytes()) {
            this.kafka$log$Cleaner$$checkDone.apply(topicAndPartition);
            this.kafka$log$Cleaner$$readBuffer().clear();
            this.kafka$log$Cleaner$$writeBuffer().clear();
            ByteBufferMessageSet messages = new ByteBufferMessageSet(source.log().readInto(this.kafka$log$Cleaner$$readBuffer(), position));
            this.throttler.maybeThrottle(messages.sizeInBytes());
            IntRef messagesRead = new IntRef(0);
            messages.shallowIterator().foreach(new Serializable(this, source, map2, retainDeletes, messagesRead){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Cleaner $outer;
                public final LogSegment source$1;
                public final OffsetMap map$3;
                public final boolean retainDeletes$2;
                public final IntRef messagesRead$1;

                public final void apply(MessageAndOffset entry2) {
                    int size2 = MessageSet$.MODULE$.entrySize(entry2.message());
                    this.$outer.stats().readMessage(size2);
                    CompressionCodec compressionCodec = entry2.message().compressionCodec();
                    NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
                    if (!(compressionCodec != null ? !compressionCodec.equals(noCompressionCodec$) : noCompressionCodec$ != null)) {
                        if (this.$outer.kafka$log$Cleaner$$shouldRetainMessage(this.source$1, this.map$3, this.retainDeletes$2, entry2)) {
                            ByteBufferMessageSet$.MODULE$.writeMessage(this.$outer.kafka$log$Cleaner$$writeBuffer(), entry2.message(), entry2.offset());
                            this.$outer.stats().recopyMessage(size2);
                        }
                        ++this.messagesRead$1.elem;
                    } else {
                        Iterator<MessageAndOffset> messages = ByteBufferMessageSet$.MODULE$.deepIterator(entry2.message());
                        Seq<MessageAndOffset> retainedMessages = messages.filter((Function1<MessageAndOffset, Object>)((Object)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$cleanInto$1 $outer;

                            public final boolean apply(MessageAndOffset messageAndOffset) {
                                ++this.$outer.messagesRead$1.elem;
                                return this.$outer.kafka$log$Cleaner$$anonfun$$$outer().kafka$log$Cleaner$$shouldRetainMessage(this.$outer.source$1, this.$outer.map$3, this.$outer.retainDeletes$2, messageAndOffset);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        })).toSeq();
                        if (retainedMessages.nonEmpty()) {
                            this.$outer.kafka$log$Cleaner$$compressMessages(this.$outer.kafka$log$Cleaner$$writeBuffer(), entry2.message().compressionCodec(), retainedMessages);
                        }
                    }
                }

                public /* synthetic */ Cleaner kafka$log$Cleaner$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.source$1 = source$1;
                    this.map$3 = map$3;
                    this.retainDeletes$2 = retainDeletes$2;
                    this.messagesRead$1 = messagesRead$1;
                }
            });
            position += messages.validBytes();
            if (this.kafka$log$Cleaner$$writeBuffer().position() > 0) {
                this.kafka$log$Cleaner$$writeBuffer().flip();
                ByteBufferMessageSet retained = new ByteBufferMessageSet(this.kafka$log$Cleaner$$writeBuffer());
                dest.append(((MessageAndOffset)retained.head()).offset(), retained);
                this.throttler.maybeThrottle(this.kafka$log$Cleaner$$writeBuffer().limit());
            }
            if (this.kafka$log$Cleaner$$readBuffer().limit() <= 0 || messagesRead.elem != 0) continue;
            this.growBuffers();
        }
        this.restoreBuffers();
    }

    public void kafka$log$Cleaner$$compressMessages(ByteBuffer buffer, CompressionCodec compressionCodec, Seq<MessageAndOffset> messages) {
        Iterable<Message> messagesIterable = messages.toIterable().map(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Message apply(MessageAndOffset x$13) {
                return x$13.message();
            }
        }, Iterable$.MODULE$.canBuildFrom());
        if (messages.isEmpty()) {
            MessageSet$.MODULE$.Empty().sizeInBytes();
        } else {
            CompressionCodec compressionCodec2 = compressionCodec;
            NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
            if (!(compressionCodec2 != null ? !compressionCodec2.equals(noCompressionCodec$) : noCompressionCodec$ != null)) {
                messages.foreach(new Serializable(this, buffer){
                    public static final long serialVersionUID = 0L;
                    private final ByteBuffer buffer$1;

                    public final void apply(MessageAndOffset messageOffset) {
                        ByteBufferMessageSet$.MODULE$.writeMessage(this.buffer$1, messageOffset.message(), messageOffset.offset());
                    }
                    {
                        this.buffer$1 = buffer$1;
                    }
                });
                MessageSet$.MODULE$.messageSetSize(messagesIterable);
            } else {
                LongRef offset = new LongRef(-1L);
                MessageWriter messageWriter = new MessageWriter(package$.MODULE$.min(package$.MODULE$.max(MessageSet$.MODULE$.messageSetSize(messagesIterable) / 2, 1024), 65536));
                CompressionCodec x$17 = compressionCodec;
                byte[] x$18 = messageWriter.write$default$1();
                Serializable x$19 = new Serializable(this, compressionCodec, messages, offset){
                    public static final long serialVersionUID = 0L;
                    private final CompressionCodec compressionCodec$1;
                    private final Seq messages$1;
                    public final LongRef offset$2;

                    public final void apply(OutputStream outputStream) {
                        DataOutputStream output2 = new DataOutputStream(CompressionFactory$.MODULE$.apply(this.compressionCodec$1, outputStream));
                        try {
                            this.messages$1.foreach(new Serializable(this, output2){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$9 $outer;
                                private final DataOutputStream output$1;

                                public final void apply(MessageAndOffset messageOffset) {
                                    Message message = messageOffset.message();
                                    this.$outer.offset$2.elem = messageOffset.offset();
                                    this.output$1.writeLong(this.$outer.offset$2.elem);
                                    this.output$1.writeInt(message.size());
                                    this.output$1.write(message.buffer().array(), message.buffer().arrayOffset(), message.buffer().limit());
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.output$1 = output$1;
                                }
                            });
                            return;
                        }
                        finally {
                            output2.close();
                        }
                    }
                    {
                        this.compressionCodec$1 = compressionCodec$1;
                        this.messages$1 = messages$1;
                        this.offset$2 = offset$2;
                    }
                };
                messageWriter.write(x$18, x$17, (Function1<OutputStream, BoxedUnit>)((Object)x$19));
                ByteBufferMessageSet$.MODULE$.writeMessage(buffer, messageWriter, offset.elem);
                this.stats().recopyMessage(messageWriter.size() + MessageSet$.MODULE$.LogOverhead());
            }
        }
    }

    public boolean kafka$log$Cleaner$$shouldRetainMessage(LogSegment source, OffsetMap map2, boolean retainDeletes, MessageAndOffset entry2) {
        boolean bl;
        ByteBuffer key = entry2.message().key();
        if (key == null) {
            this.stats().invalidMessage();
            bl = false;
        } else {
            long foundOffset = map2.get(key);
            boolean redundant = foundOffset >= 0L && entry2.offset() < foundOffset;
            boolean obsoleteDelete = !retainDeletes && entry2.message().isNull();
            bl = !redundant && !obsoleteDelete;
        }
        return bl;
    }

    public void growBuffers() {
        if (this.kafka$log$Cleaner$$readBuffer().capacity() >= this.maxIoBufferSize || this.kafka$log$Cleaner$$writeBuffer().capacity() >= this.maxIoBufferSize) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("This log contains a message larger than maximum allowable size of %s.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.maxIoBufferSize)})));
        }
        int newSize = package$.MODULE$.min(this.kafka$log$Cleaner$$readBuffer().capacity() * 2, this.maxIoBufferSize);
        this.info((Function0<String>)((Object)new Serializable(this, newSize){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Cleaner $outer;
            private final int newSize$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Growing cleaner I/O buffers from ").append(BoxesRunTime.boxToInteger(this.$outer.kafka$log$Cleaner$$readBuffer().capacity())).append((Object)"bytes to ").append(BoxesRunTime.boxToInteger(this.newSize$1)).append((Object)" bytes.").toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.newSize$1 = newSize$1;
            }
        }));
        this.kafka$log$Cleaner$$readBuffer_$eq(ByteBuffer.allocate(newSize));
        this.kafka$log$Cleaner$$writeBuffer_$eq(ByteBuffer.allocate(newSize));
    }

    public void restoreBuffers() {
        if (this.kafka$log$Cleaner$$readBuffer().capacity() > this.ioBufferSize) {
            this.kafka$log$Cleaner$$readBuffer_$eq(ByteBuffer.allocate(this.ioBufferSize));
        }
        if (this.kafka$log$Cleaner$$writeBuffer().capacity() > this.ioBufferSize) {
            this.kafka$log$Cleaner$$writeBuffer_$eq(ByteBuffer.allocate(this.ioBufferSize));
        }
    }

    public List<Seq<LogSegment>> groupSegmentsBySize(Iterable<LogSegment> segments2, int maxSize, int maxIndexSize) {
        Nil$ grouped2 = Nil$.MODULE$;
        List segs = segments2.toList();
        while (!segs.isEmpty()) {
            List<Object> list2;
            List list3;
            List<LogSegment> group = List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{(LogSegment)list3.head()}));
            long logSize = ((LogSegment)list3.head()).size();
            int indexSize = ((LogSegment)list3.head()).index().sizeInBytes();
            list3 = (List)list3.tail();
            while (!list3.isEmpty() && logSize + ((LogSegment)list3.head()).size() <= (long)maxSize && indexSize + ((LogSegment)list3.head()).index().sizeInBytes() <= maxIndexSize && ((LogSegment)list3.head()).index().lastOffset() - ((LogSegment)group.last()).index().baseOffset() <= Integer.MAX_VALUE) {
                LogSegment logSegment = (LogSegment)list3.head();
                group = group.$colon$colon(logSegment);
                logSize += ((LogSegment)list3.head()).size();
                indexSize += ((LogSegment)list3.head()).index().sizeInBytes();
                list3 = (List)list3.tail();
            }
            list2 = list2.$colon$colon(group.reverse());
        }
        return grouped2.reverse();
    }

    public long buildOffsetMap(Log log2, long start2, long end, OffsetMap map2) {
        map2.clear();
        Seq<LogSegment> dirty = log2.logSegments(start2, end).toSeq();
        this.info((Function0<String>)((Object)new Serializable(this, log2, start2, end, dirty){
            public static final long serialVersionUID = 0L;
            private final Log log$2;
            private final long start$1;
            private final long end$1;
            private final Seq dirty$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Building offset map for log %s for %d segments in offset range [%d, %d).")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.log$2.name(), BoxesRunTime.boxToInteger(this.dirty$1.size()), BoxesRunTime.boxToLong(this.start$1), BoxesRunTime.boxToLong(this.end$1)}));
            }
            {
                this.log$2 = log$2;
                this.start$1 = start$1;
                this.end$1 = end$1;
                this.dirty$1 = dirty$1;
            }
        }));
        LongRef offset = new LongRef(((LogSegment)dirty.head()).baseOffset());
        Predef$.MODULE$.require(offset.elem == start2, (Function0<Object>)((Object)new Serializable(this, log2, start2, offset){
            public static final long serialVersionUID = 0L;
            private final Log log$2;
            private final long start$1;
            private final LongRef offset$3;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Last clean offset is %d but segment base offset is %d for log %s.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.start$1), BoxesRunTime.boxToLong(this.offset$3.elem), this.log$2.name()}));
            }
            {
                this.log$2 = log$2;
                this.start$1 = start$1;
                this.offset$3 = offset$3;
            }
        }));
        int maxDesiredMapSize = (int)((double)map2.slots() * this.dupBufferLoadFactor);
        BooleanRef full = new BooleanRef(false);
        dirty.withFilter((Function1<LogSegment, Object>)((Object)new Serializable(this, full){
            public static final long serialVersionUID = 0L;
            private final BooleanRef full$1;

            public final boolean apply(LogSegment segment) {
                return !this.full$1.elem;
            }
            {
                this.full$1 = full$1;
            }
        })).foreach(new Serializable(this, log2, map2, offset, maxDesiredMapSize, full){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Cleaner $outer;
            public final Log log$2;
            private final OffsetMap map$1;
            private final LongRef offset$3;
            public final int maxDesiredMapSize$1;
            private final BooleanRef full$1;

            public final void apply(LogSegment segment) {
                this.$outer.kafka$log$Cleaner$$checkDone.apply(this.log$2.topicAndPartition());
                long segmentSize = segment.nextOffset() - segment.baseOffset();
                Predef$.MODULE$.require(segmentSize <= (long)this.maxDesiredMapSize$1, (Function0<Object>)((Object)new Serializable(this, segment, segmentSize){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$buildOffsetMap$4 $outer;
                    private final LogSegment segment$1;
                    private final long segmentSize$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("%d messages in segment %s/%s but offset map can fit only %d. You can increase log.cleaner.dedupe.buffer.size or decrease log.cleaner.threads")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.segmentSize$1), this.$outer.log$2.name(), this.segment$1.log().file().getName(), BoxesRunTime.boxToInteger(this.$outer.maxDesiredMapSize$1)}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.segment$1 = segment$1;
                        this.segmentSize$1 = segmentSize$1;
                    }
                }));
                if ((long)this.map$1.size() + segmentSize <= (long)this.maxDesiredMapSize$1) {
                    this.offset$3.elem = this.$outer.kafka$log$Cleaner$$buildOffsetMapForSegment(this.log$2.topicAndPartition(), segment, this.map$1);
                } else {
                    this.full$1.elem = true;
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.log$2 = log$2;
                this.map$1 = map$1;
                this.offset$3 = offset$3;
                this.maxDesiredMapSize$1 = maxDesiredMapSize$1;
                this.full$1 = full$1;
            }
        });
        this.info((Function0<String>)((Object)new Serializable(this, log2){
            public static final long serialVersionUID = 0L;
            private final Log log$2;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Offset map for log %s complete.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.log$2.name()}));
            }
            {
                this.log$2 = log$2;
            }
        }));
        return offset.elem;
    }

    public long kafka$log$Cleaner$$buildOffsetMapForSegment(TopicAndPartition topicAndPartition, LogSegment segment, OffsetMap map2) {
        int position = 0;
        LongRef offset = new LongRef(segment.baseOffset());
        while (position < segment.log().sizeInBytes()) {
            this.kafka$log$Cleaner$$checkDone.apply(topicAndPartition);
            this.kafka$log$Cleaner$$readBuffer().clear();
            ByteBufferMessageSet messages = new ByteBufferMessageSet(segment.log().readInto(this.kafka$log$Cleaner$$readBuffer(), position));
            this.throttler.maybeThrottle(messages.sizeInBytes());
            int startPosition = position;
            messages.foreach(new Serializable(this, map2, offset){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Cleaner $outer;
                private final OffsetMap map$4;
                private final LongRef offset$4;

                public final void apply(MessageAndOffset entry2) {
                    Message message = entry2.message();
                    if (message.hasKey()) {
                        this.map$4.put(message.key(), entry2.offset());
                    }
                    this.offset$4.elem = entry2.offset();
                    this.$outer.stats().indexMessagesRead(1);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.map$4 = map$4;
                    this.offset$4 = offset$4;
                }
            });
            this.stats().indexBytesRead(messages.validBytes());
            if ((position += messages.validBytes()) != startPosition) continue;
            this.growBuffers();
        }
        this.restoreBuffers();
        return offset.elem;
    }

    public Cleaner(int id, OffsetMap offsetMap, int ioBufferSize, int maxIoBufferSize, double dupBufferLoadFactor, Throttler throttler, Time time, Function1<TopicAndPartition, BoxedUnit> checkDone) {
        this.id = id;
        this.offsetMap = offsetMap;
        this.ioBufferSize = ioBufferSize;
        this.maxIoBufferSize = maxIoBufferSize;
        this.dupBufferLoadFactor = dupBufferLoadFactor;
        this.throttler = throttler;
        this.time = time;
        this.kafka$log$Cleaner$$checkDone = checkDone;
        Logging$class.$init$(this);
        this.loggerName = LogCleaner.class.getName();
        this.logIdent_$eq(new StringBuilder().append((Object)"Cleaner ").append(BoxesRunTime.boxToInteger(id)).append((Object)": ").toString());
        this.statsUnderlying = new Tuple2<CleanerStats, CleanerStats>(new CleanerStats(time), new CleanerStats(time));
        this.kafka$log$Cleaner$$readBuffer = ByteBuffer.allocate(ioBufferSize);
        this.kafka$log$Cleaner$$writeBuffer = ByteBuffer.allocate(ioBufferSize);
    }
}

