/*
 * Decompiled with CFR 0.152.
 */
package joptsimple;

import java.util.Collection;
import joptsimple.IllegalOptionSpecificationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ParserRules {
    static final char HYPHEN_CHAR = '-';
    static final String HYPHEN = String.valueOf('-');
    static final String DOUBLE_HYPHEN = "--";
    static final String OPTION_TERMINATOR = "--";
    static final String RESERVED_FOR_EXTENSIONS = "W";

    private ParserRules() {
    }

    static boolean isShortOptionToken(String argument2) {
        return argument2.startsWith(HYPHEN) && !HYPHEN.equals(argument2) && !ParserRules.isLongOptionToken(argument2);
    }

    static boolean isLongOptionToken(String argument2) {
        return argument2.startsWith("--") && !ParserRules.isOptionTerminator(argument2);
    }

    static boolean isOptionTerminator(String argument2) {
        return "--".equals(argument2);
    }

    static void ensureLegalOption(String option) {
        if (option.startsWith(HYPHEN)) {
            throw new IllegalOptionSpecificationException(String.valueOf(option));
        }
        for (int i = 0; i < option.length(); ++i) {
            ParserRules.ensureLegalOptionCharacter(option.charAt(i));
        }
    }

    static void ensureLegalOptions(Collection<String> options) {
        for (String each : options) {
            ParserRules.ensureLegalOption(each);
        }
    }

    private static void ensureLegalOptionCharacter(char option) {
        if (!Character.isLetterOrDigit(option) && !ParserRules.isAllowedPunctuation(option)) {
            throw new IllegalOptionSpecificationException(String.valueOf(option));
        }
    }

    private static boolean isAllowedPunctuation(char option) {
        String allowedPunctuation = "?.-";
        return allowedPunctuation.indexOf(option) != -1;
    }

    static {
        new ParserRules();
    }
}

