/*
 * Decompiled with CFR 0.152.
 */
package jline;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import jline.SimpleCompletor;

public class ClassNameCompletor
extends SimpleCompletor {
    static /* synthetic */ Class class$jline$ClassNameCompletor;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$swing$JFrame;

    public ClassNameCompletor() throws IOException {
        this((SimpleCompletor.SimpleCompletorFilter)null);
    }

    public ClassNameCompletor(SimpleCompletor.SimpleCompletorFilter filter2) throws IOException {
        super(ClassNameCompletor.getClassNames(), filter2);
        this.setDelimiter(".");
    }

    public static String[] getClassNames() throws IOException {
        HashSet<URL> urls = new HashSet<URL>();
        for (ClassLoader loader = (class$jline$ClassNameCompletor == null ? (class$jline$ClassNameCompletor = ClassNameCompletor.class$("jline.ClassNameCompletor")) : class$jline$ClassNameCompletor).getClassLoader(); loader != null; loader = loader.getParent()) {
            if (!(loader instanceof URLClassLoader)) continue;
            urls.addAll(Arrays.asList(((URLClassLoader)loader).getURLs()));
        }
        Class[] systemClasses = new Class[]{class$java$lang$String == null ? (class$java$lang$String = ClassNameCompletor.class$("java.lang.String")) : class$java$lang$String, class$javax$swing$JFrame == null ? (class$javax$swing$JFrame = ClassNameCompletor.class$("javax.swing.JFrame")) : class$javax$swing$JFrame};
        for (int i = 0; i < systemClasses.length; ++i) {
            URLConnection uc;
            URL classURL = systemClasses[i].getResource("/" + systemClasses[i].getName().replace('.', '/') + ".class");
            if (classURL == null || !((uc = classURL.openConnection()) instanceof JarURLConnection)) continue;
            urls.add(((JarURLConnection)uc).getJarFileURL());
        }
        HashSet<String> classes2 = new HashSet<String>();
        Iterator i = urls.iterator();
        while (i.hasNext()) {
            URL url = (URL)i.next();
            File file = new File(url.getFile());
            if (file.isDirectory()) {
                Set files2 = ClassNameCompletor.getClassFiles(file.getAbsolutePath(), new HashSet(), file, new int[]{200});
                classes2.addAll(files2);
                continue;
            }
            if (file == null || !file.isFile()) continue;
            JarFile jf = new JarFile(file);
            Enumeration<JarEntry> e = jf.entries();
            while (e.hasMoreElements()) {
                String name;
                JarEntry entry2 = e.nextElement();
                if (entry2 == null || !(name = entry2.getName()).endsWith(".class")) continue;
                classes2.add(name);
            }
        }
        TreeSet<String> classNames = new TreeSet<String>();
        Iterator i2 = classes2.iterator();
        while (i2.hasNext()) {
            String name = (String)i2.next();
            classNames.add(name.replace('/', '.').substring(0, name.length() - 6));
        }
        return classNames.toArray(new String[classNames.size()]);
    }

    private static Set getClassFiles(String root2, Set holder, File directory, int[] maxDirectories) {
        int n = maxDirectories[0];
        maxDirectories[0] = n - 1;
        if (n < 0) {
            return holder;
        }
        File[] files2 = directory.listFiles();
        for (int i = 0; files2 != null && i < files2.length; ++i) {
            String name = files2[i].getAbsolutePath();
            if (!name.startsWith(root2)) continue;
            if (files2[i].isDirectory()) {
                ClassNameCompletor.getClassFiles(root2, holder, files2[i], maxDirectories);
                continue;
            }
            if (!files2[i].getName().endsWith(".class")) continue;
            holder.add(files2[i].getAbsolutePath().substring(root2.length() + 1));
        }
        return holder;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

