/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.fjbg;

import ch.epfl.lamp.fjbg.FJBGContext;
import ch.epfl.lamp.fjbg.JAttribute;
import ch.epfl.lamp.fjbg.JAttributeFactory;
import ch.epfl.lamp.fjbg.JBootstrapInvokeDynamic;
import ch.epfl.lamp.fjbg.JConstantPool;
import ch.epfl.lamp.fjbg.JField;
import ch.epfl.lamp.fjbg.JInnerClassesAttribute;
import ch.epfl.lamp.fjbg.JMember;
import ch.epfl.lamp.fjbg.JMethod;
import ch.epfl.lamp.fjbg.JObjectType;
import ch.epfl.lamp.fjbg.JType;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;

public class JClass
extends JMember {
    public static final int MAGIC_NUMBER = -889275714;
    protected final JAttributeFactory attributeFactory;
    protected final String superclassName;
    protected final String[] interfaceNames;
    protected final String sourceFileName;
    protected final JConstantPool pool;
    protected JBootstrapInvokeDynamic bootstrapClassAttr = null;
    public static final String[] NO_INTERFACES = new String[0];
    protected final LinkedList methods = new LinkedList();
    protected final LinkedList fields = new LinkedList();
    protected JInnerClassesAttribute innerClasses;
    protected int major;
    protected int minor;

    protected JClass(FJBGContext context, int accessFlags, String name, String superclassName, String[] interfaceNames, String sourceFileName) {
        super(context, accessFlags, name);
        this.attributeFactory = context.getJAttributeFactory();
        this.major = context.MAJOR_VERSION;
        this.minor = context.MINOR_VERSION;
        this.superclassName = superclassName;
        this.interfaceNames = interfaceNames;
        this.sourceFileName = sourceFileName;
        this.pool = context.JConstantPool();
        if (sourceFileName != null) {
            this.addAttribute(context.JSourceFileAttribute(this, sourceFileName));
        }
    }

    protected JClass(FJBGContext context, DataInputStream stream) throws IOException {
        super(context);
        this.attributeFactory = context.getJAttributeFactory();
        int magic = stream.readInt();
        if (magic != -889275714) {
            throw new IllegalArgumentException("invalid magic number: " + magic);
        }
        this.minor = stream.readShort();
        this.major = stream.readShort();
        this.pool = context.JConstantPool(stream);
        this.accessFlags = stream.readShort();
        this.name = this.pool.lookupClass(stream.readShort());
        this.superclassName = this.pool.lookupClass(stream.readShort());
        this.interfaceNames = new String[stream.readShort()];
        for (int i = 0; i < this.interfaceNames.length; ++i) {
            this.interfaceNames[i] = this.pool.lookupClass(stream.readShort());
        }
        int fieldsCount = stream.readShort();
        for (int i = 0; i < fieldsCount; ++i) {
            this.addField(context.JField(this, stream));
        }
        int methodsCount = stream.readShort();
        for (int i = 0; i < methodsCount; ++i) {
            this.addMethod(context.JMethod(this, stream));
        }
        int attributesCount = stream.readShort();
        for (int i = 0; i < attributesCount; ++i) {
            this.addAttribute(this.attributeFactory.newInstance(this, this, stream));
        }
        this.sourceFileName = null;
    }

    public String getSuperclassName() {
        return this.superclassName;
    }

    public String[] getInterfaceNames() {
        return this.interfaceNames;
    }

    public JType getType() {
        return new JObjectType(this.name);
    }

    public JClass getJClass() {
        return this;
    }

    public void setVersion(int major, int minor) {
        assert (!this.frozen);
        this.major = major;
        this.minor = minor;
    }

    public int getMajorVersion() {
        return this.major;
    }

    public int getMinorVersion() {
        return this.minor;
    }

    public JConstantPool getConstantPool() {
        return this.pool;
    }

    public JInnerClassesAttribute getInnerClasses() {
        if (this.innerClasses == null) {
            this.innerClasses = new JInnerClassesAttribute(this.context, this);
            this.addAttribute(this.innerClasses);
        }
        return this.innerClasses;
    }

    public boolean isInterface() {
        return (this.accessFlags & 0x200) != 0;
    }

    public void addField(JField field2) {
        assert (!this.frozen);
        this.fields.add(field2);
    }

    public JField addNewField(int accessFlags, String name, JType type) {
        assert (!this.frozen);
        JField f = this.context.JField(this, accessFlags, name, type);
        this.addField(f);
        return f;
    }

    protected void addMethod(JMethod method) {
        assert (!this.frozen);
        this.methods.add(method);
    }

    public JMethod addNewMethod(int accessFlags, String name, JType returnType, JType[] argTypes, String[] argNames) {
        assert (!this.frozen);
        JMethod m = this.context.JMethod(this, accessFlags, name, returnType, argTypes, argNames);
        this.addMethod(m);
        return m;
    }

    public void removeMethod(JMethod m) {
        assert (!this.frozen);
        this.methods.remove(m);
    }

    public JMethod[] getMethods() {
        return this.methods.toArray(new JMethod[this.methods.size()]);
    }

    public void freeze() {
        assert (!this.frozen);
        this.frozen = true;
    }

    public void writeTo(String fileName) throws IOException {
        this.writeTo(new File(fileName));
    }

    public void writeTo(File file) throws IOException {
        File parent = file.getParentFile();
        if (parent != null && !parent.isDirectory() && !parent.mkdirs()) {
            throw new IOException("cannot create directory " + parent);
        }
        FileOutputStream fStream = new FileOutputStream(file);
        BufferedOutputStream bStream = new BufferedOutputStream(fStream);
        DataOutputStream dStream = new DataOutputStream(bStream);
        this.writeTo(dStream);
        dStream.close();
        bStream.close();
        fStream.close();
    }

    public void setBootstrapClass(String bootstrapClass) {
        assert (this.bootstrapClassAttr == null);
        this.bootstrapClassAttr = new JBootstrapInvokeDynamic(this.context, this, bootstrapClass);
        this.addAttribute(this.bootstrapClassAttr);
    }

    public void writeTo(DataOutputStream stream) throws IOException {
        int i;
        if (!this.frozen) {
            this.freeze();
        }
        int thisClassIdx = this.pool.addClass(this.name);
        int superClassIdx = this.pool.addClass(this.superclassName);
        int[] interfacesIdx = new int[this.interfaceNames.length];
        for (i = 0; i < this.interfaceNames.length; ++i) {
            interfacesIdx[i] = this.pool.addClass(this.interfaceNames[i]);
        }
        this.pool.freeze();
        stream.writeInt(-889275714);
        stream.writeShort(this.minor);
        stream.writeShort(this.major);
        this.pool.writeTo(stream);
        stream.writeShort(this.accessFlags);
        stream.writeShort(thisClassIdx);
        stream.writeShort(superClassIdx);
        stream.writeShort(interfacesIdx.length);
        for (i = 0; i < interfacesIdx.length; ++i) {
            stream.writeShort(interfacesIdx[i]);
        }
        stream.writeShort(this.fields.size());
        Iterator fieldsIt = this.fields.iterator();
        while (fieldsIt.hasNext()) {
            ((JField)fieldsIt.next()).writeTo(stream);
        }
        stream.writeShort(this.methods.size());
        Iterator methodsIt = this.methods.iterator();
        while (methodsIt.hasNext()) {
            ((JMethod)methodsIt.next()).writeTo(stream);
        }
        JAttribute.writeTo(this.attributes, stream);
    }
}

