/*
 * Decompiled with CFR 0.152.
 */
package org.ojai.json.mapreduce;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.ojai.Document;
import org.ojai.DocumentStream;
import org.ojai.json.Json;

public class JSONFileRecordReader
extends RecordReader<LongWritable, Document> {
    private FSDataInputStream inputStream;
    private DocumentStream<Document> documentStream;
    private Iterator<Document> it;
    private long documentCount;
    private LongWritable key = null;
    private Document document;
    private long currentPos;
    private long start;
    private long end;
    private long blockLength;

    public void close() throws IOException {
        try {
            this.documentStream.close();
        }
        catch (Exception e) {
            throw new IOException("Error closing document Stream in JsonFileRecordReader");
        }
        if (this.inputStream != null) {
            this.inputStream.close();
        }
    }

    public LongWritable getCurrentKey() throws IOException, InterruptedException {
        return this.key;
    }

    public Document getCurrentValue() throws IOException, InterruptedException {
        return this.document;
    }

    public float getProgress() throws IOException, InterruptedException {
        if (this.start == this.end) {
            return 0.0f;
        }
        return Math.min(1.0f, (float)(this.currentPos - this.start) / (float)(this.end - this.start));
    }

    private long bytesToSkip(long start, long blockLength) throws IOException {
        long toSkip;
        this.inputStream.seek(start - 1L);
        InputStreamReader in = new InputStreamReader((InputStream)this.inputStream, "UTF-8");
        boolean gotStart = false;
        for (toSkip = 0L; toSkip <= blockLength; ++toSkip) {
            char curChar = (char)in.read();
            if (curChar == '}') {
                gotStart = true;
            }
            if (curChar == '{' && gotStart) break;
            if (curChar != ',') continue;
            gotStart = false;
        }
        return toSkip;
    }

    public void initialize(InputSplit arg0, TaskAttemptContext taskContext) throws IOException, InterruptedException {
        this.documentStream = null;
        this.it = null;
        this.documentCount = 0L;
        this.key = new LongWritable();
        this.document = null;
        this.currentPos = 0L;
        FileSplit split = (FileSplit)arg0;
        Configuration job = taskContext.getConfiguration();
        Path path = split.getPath();
        FileSystem fs = path.getFileSystem(job);
        this.inputStream = fs.open(path);
        this.start = split.getStart();
        this.blockLength = split.getLength();
        long skipBytes = 0L;
        if (this.start != 0L) {
            skipBytes = this.bytesToSkip(this.start, this.blockLength);
            this.currentPos = this.start - 1L + skipBytes;
            this.inputStream.seek(this.currentPos);
        }
        this.documentStream = Json.newDocumentStream((InputStream)this.inputStream);
        this.it = this.documentStream.iterator();
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        boolean hasNextKeyVal = false;
        long thisPos = this.inputStream.getPos();
        if (thisPos >= this.start + this.blockLength) {
            return false;
        }
        if (this.it.hasNext()) {
            this.key.set(this.documentCount);
            this.document = this.it.next();
            ++this.documentCount;
            hasNextKeyVal = true;
        }
        return hasNextKeyVal;
    }
}

