/*
 * Decompiled with CFR 0.152.
 */
package org.ojai.json.mapreduce;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.Serialization;
import org.apache.hadoop.io.serializer.Serializer;
import org.ojai.Document;
import org.ojai.DocumentBuilder;
import org.ojai.DocumentReader;
import org.ojai.DocumentStream;
import org.ojai.json.Json;
import org.ojai.json.impl.JsonDocument;
import org.ojai.json.mapreduce.JSONFileRecordWriter;

public class JSONDocumentSerialization
extends Configured
implements Serialization<JsonDocument> {
    public boolean accept(Class<?> arg0) {
        return JsonDocument.class.isAssignableFrom(arg0);
    }

    public Deserializer<JsonDocument> getDeserializer(Class<JsonDocument> arg0) {
        return new JsonDocumentDeserializer();
    }

    public Serializer<JsonDocument> getSerializer(Class<JsonDocument> arg0) {
        return new JsonDocumentSerializer();
    }

    private static class JsonDocumentSerializer
    implements Serializer<JsonDocument> {
        private OutputStream out;
        private JSONFileRecordWriter writer = null;

        private JsonDocumentSerializer() {
        }

        public void close() throws IOException {
            this.out.close();
        }

        public void open(OutputStream arg0) throws IOException {
            this.out = arg0;
        }

        public void serialize(JsonDocument arg0) throws IOException {
            this.writer = new JSONFileRecordWriter(this.out);
            if (this.writer == null) {
                throw new IOException("Output stream is not available for serialization.");
            }
            DocumentReader reader = arg0.asReader();
            Json.writeReaderToBuilder((DocumentReader)reader, (DocumentBuilder)this.writer);
        }
    }

    private static class JsonDocumentDeserializer
    implements Deserializer<JsonDocument> {
        private DocumentStream<Document> stream;
        private Iterator<Document> iter;

        private JsonDocumentDeserializer() {
        }

        public void close() throws IOException {
            try {
                this.stream.close();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }

        public JsonDocument deserialize(JsonDocument arg0) throws IOException {
            if (this.iter.hasNext()) {
                return (JsonDocument)this.iter.next();
            }
            return null;
        }

        public void open(InputStream in) throws IOException {
            this.stream = Json.newDocumentStream((InputStream)in);
            this.iter = this.stream.iterator();
        }
    }
}

