/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import com.google.protobuf.ByteString;
import com.google.protobuf.ZeroCopyLiteralByteString;
import java.util.ArrayList;
import org.hbase.async.Bytes;
import org.hbase.async.HBaseRpc;
import org.hbase.async.ScanFilter;
import org.hbase.async.generated.FilterPB;
import org.jboss.netty.buffer.ChannelBuffer;

public final class MultipleColumnPrefixFilter
extends ScanFilter {
    private static final byte[] NAME = Bytes.ISO88591("org.apache.hadoop.hbase.filter.MultipleColumnPrefixFilter");
    private final byte[][] prefixes;
    private final int prefixesLength;

    public MultipleColumnPrefixFilter(String[] prefixes) {
        this.prefixes = new byte[prefixes.length][];
        for (int i = 0; i < prefixes.length; ++i) {
            this.prefixes[i] = Bytes.UTF8(prefixes[i]);
        }
        this.prefixesLength = this.estimatePrefixesLength();
    }

    public MultipleColumnPrefixFilter(byte[][] prefixes) {
        if (prefixes.length == 0) {
            throw new IllegalArgumentException("Empty prefix");
        }
        this.prefixes = prefixes;
        this.prefixesLength = this.estimatePrefixesLength();
    }

    private int estimatePrefixesLength() {
        int prefix_length = 0;
        for (int i = 0; i < this.prefixes.length; ++i) {
            prefix_length += this.prefixes[i].length;
        }
        return prefix_length;
    }

    @Override
    byte[] serialize() {
        ArrayList<ByteString> byte_strings = new ArrayList<ByteString>(this.prefixes.length);
        for (int i = 0; i < this.prefixes.length; ++i) {
            byte_strings.add(ZeroCopyLiteralByteString.wrap(this.prefixes[i]));
        }
        return FilterPB.MultipleColumnPrefixFilter.newBuilder().addAllSortedPrefixes(byte_strings).build().toByteArray();
    }

    @Override
    byte[] name() {
        return NAME;
    }

    @Override
    int predictSerializedSize() {
        return 1 + NAME.length + 3 * (this.prefixes.length + 1) + this.prefixesLength;
    }

    @Override
    void serializeOld(ChannelBuffer buf) {
        buf.writeByte((int)((byte)NAME.length));
        buf.writeBytes(NAME);
        for (int i = 0; i < this.prefixes.length; ++i) {
            HBaseRpc.writeByteArray(buf, this.prefixes[i]);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.prefixesLength + this.prefixes.length);
        for (int i = 0; i < this.prefixes.length; ++i) {
            builder.append(this.prefixes[i]);
            builder.append(";");
        }
        return "MultipleColumnPrefixFilter(" + builder.toString() + ")";
    }

    @Override
    protected ByteString getState() {
        throw new UnsupportedOperationException("MultipleColumnPrefixFilter currently not supported for MapR tables.");
    }

    @Override
    protected String getId() {
        throw new UnsupportedOperationException("MultipleColumnPrefixFilter currently not supported for MapR tables.");
    }
}

