/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.google.protobuf.AbstractMessageLite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.hbase.async.Bytes;
import org.hbase.async.GetRequest;
import org.hbase.async.HBaseRpc;
import org.hbase.async.KeyValue;
import org.hbase.async.generated.ClientPB;
import org.jboss.netty.buffer.ChannelBuffer;

public final class MultiColumnAtomicIncrementRequest
extends HBaseRpc
implements HBaseRpc.HasTable,
HBaseRpc.HasKey,
HBaseRpc.HasFamily,
HBaseRpc.HasQualifiers,
HBaseRpc.IsEdit {
    private static final byte[] INCREMENT_COLUMN_VALUE = new byte[]{105, 110, 99, 114, 101, 109, 101, 110, 116, 67, 111, 108, 117, 109, 110, 86, 97, 108, 117, 101};
    private static final Joiner AMOUNT_JOINER = Joiner.on((String)",");
    private final byte[] family;
    private final byte[][] qualifiers;
    private long[] amounts;
    private boolean durable = true;

    private static byte[][] toByteArrays(String[] strArray) {
        byte[][] converted = new byte[strArray.length][];
        for (int i = 0; i < strArray.length; ++i) {
            converted[i] = strArray[i].getBytes();
        }
        return converted;
    }

    public MultiColumnAtomicIncrementRequest(byte[] table, byte[] key, byte[] family, byte[][] qualifiers, long[] amounts) {
        super(table, key);
        KeyValue.checkFamily(family);
        this.family = family;
        if (qualifiers == null || qualifiers.length == 0) {
            throw new IllegalArgumentException("qualifiers must be provided for MultiColumnAtomicIncrementRequest");
        }
        for (byte[] qualifier : qualifiers) {
            KeyValue.checkQualifier(qualifier);
        }
        this.qualifiers = qualifiers;
        if (amounts != null) {
            if (amounts.length == 0) {
                throw new IllegalArgumentException("amounts must be provided for MultiColumnAtomicIncrementRequest");
            }
            if (qualifiers.length != amounts.length) {
                throw new IllegalArgumentException("Number of amounts must be equal to the number of qualifiers provided for MultiColumnAtomicIncrementRequest");
            }
            this.amounts = amounts;
        } else {
            this.amounts = new long[qualifiers.length];
            Arrays.fill(this.amounts, 1L);
        }
    }

    public MultiColumnAtomicIncrementRequest(byte[] table, byte[] key, byte[] family, byte[][] qualifiers) {
        this(table, key, family, qualifiers, null);
    }

    public MultiColumnAtomicIncrementRequest(String table, String key, String family, String[] qualifiers, long[] amounts) {
        this(table.getBytes(), key.getBytes(), family.getBytes(), MultiColumnAtomicIncrementRequest.toByteArrays(qualifiers), amounts);
    }

    public MultiColumnAtomicIncrementRequest(String table, String key, String family, String[] qualifiers) {
        this(table.getBytes(), key.getBytes(), family.getBytes(), MultiColumnAtomicIncrementRequest.toByteArrays(qualifiers), null);
    }

    public long[] getAmounts() {
        return this.amounts;
    }

    public void setAmounts(long[] amounts) {
        this.amounts = amounts;
    }

    @Override
    byte[] method(byte server_version) {
        return server_version >= 95 ? MUTATE : INCREMENT_COLUMN_VALUE;
    }

    @Override
    public byte[] table() {
        return this.table;
    }

    @Override
    public byte[] key() {
        return this.key;
    }

    @Override
    public byte[] family() {
        return this.family;
    }

    @Override
    public byte[][] qualifiers() {
        return this.qualifiers;
    }

    @Override
    public String toString() {
        return super.toStringWithQualifiers("MultiColumnAtomicIncrementRequest", this.family, this.qualifiers, null, ", amounts=" + AMOUNT_JOINER.join(Arrays.asList(new long[][]{this.amounts})));
    }

    void setDurable(boolean durable) {
        this.durable = durable;
    }

    private int predictSerializedSize() {
        int size = 0;
        size += 4;
        ++size;
        size += 3;
        size += this.region.name().length;
        ++size;
        size += 3;
        size += this.key.length;
        ++size;
        ++size;
        size += this.family.length;
        ++size;
        size += 3;
        for (byte[] qualifier : this.qualifiers) {
            size += qualifier.length;
        }
        ++size;
        size += 8 * this.amounts.length;
        ++size;
        return ++size;
    }

    @Override
    ChannelBuffer serialize(byte server_version) {
        if (server_version < 95) {
            throw new UnsupportedOperationException(server_version + " is not supported by " + this.getClass().getName());
        }
        ClientPB.MutationProto.Builder incr = ClientPB.MutationProto.newBuilder().setRow(Bytes.wrap(this.key)).setMutateType(ClientPB.MutationProto.MutationType.INCREMENT);
        for (int i = 0; i < this.qualifiers.length; ++i) {
            ClientPB.MutationProto.ColumnValue.QualifierValue qualifier = ClientPB.MutationProto.ColumnValue.QualifierValue.newBuilder().setQualifier(Bytes.wrap(this.qualifiers[i])).setValue(Bytes.wrap(Bytes.fromLong(this.amounts[i]))).build();
            ClientPB.MutationProto.ColumnValue column = ClientPB.MutationProto.ColumnValue.newBuilder().setFamily(Bytes.wrap(this.family)).addQualifierValue(qualifier).build();
            incr.addColumnValue(column);
        }
        if (!this.durable) {
            incr.setDurability(ClientPB.MutationProto.Durability.SKIP_WAL);
        }
        ClientPB.MutateRequest req = ClientPB.MutateRequest.newBuilder().setRegion(this.region.toProtobuf()).setMutation(incr.build()).build();
        return MultiColumnAtomicIncrementRequest.toChannelBuffer(MUTATE, (AbstractMessageLite)req);
    }

    @Override
    Object deserialize(ChannelBuffer buf, int cell_size) {
        ClientPB.MutateResponse resp = MultiColumnAtomicIncrementRequest.readProtobuf(buf, ClientPB.MutateResponse.PARSER);
        ArrayList<KeyValue> kvs = GetRequest.convertResult(resp.getResult(), buf, cell_size);
        HashMap updatedValues = Maps.newHashMap();
        for (KeyValue kv : kvs) {
            updatedValues.put(kv.qualifier(), Bytes.getLong(kv.value()));
        }
        return updatedValues;
    }

    @Override
    public byte[][][] getQualifiers() {
        throw new UnsupportedOperationException("Multiple column-family increment is currently not supported");
    }

    @Override
    public byte[][] getFamilies() {
        throw new UnsupportedOperationException("Multiple column-family increment is currently not supported");
    }
}

