/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import com.mapr.fs.MapRHTable;
import com.mapr.fs.jni.MapRCallBackQueue;
import com.mapr.fs.jni.MapRGet;
import com.mapr.fs.jni.MapRIncrement;
import com.mapr.fs.jni.MapRKeyValue;
import com.mapr.fs.jni.MapRPut;
import com.mapr.fs.jni.MapRResult;
import com.mapr.fs.jni.MapRRowConstraint;
import com.mapr.fs.jni.MapRScan;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.hbase.async.AppendRequest;
import org.hbase.async.Bytes;
import org.hbase.async.DeleteRequest;
import org.hbase.async.GetRequest;
import org.hbase.async.KeyValue;
import org.hbase.async.MapRThreadPool;
import org.hbase.async.PutRequest;
import org.hbase.async.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapRConverter {
    private static final Logger LOG = LoggerFactory.getLogger(MapRConverter.class);
    private static final byte[] ZERO_BYTE_ARRAY = new byte[0];

    public static int compareTo(byte[] buffer1, int offset1, int length1, byte[] buffer2, int offset2, int length2) {
        if (buffer1 == buffer2 && offset1 == offset2 && length1 == length2) {
            return 0;
        }
        int end1 = offset1 + length1;
        int end2 = offset2 + length2;
        int i = offset1;
        for (int j = offset2; i < end1 && j < end2; ++i, ++j) {
            int a = buffer1[i] & 0xFF;
            int b = buffer2[j] & 0xFF;
            if (a == b) continue;
            return a - b;
        }
        return length1 - length2;
    }

    public static MapRPut toMapRPut(PutRequest put, MapRHTable mtable, MapRThreadPool cbq) {
        byte[][] families = put.getFamilies();
        byte[][][] qualifiers = put.getQualifiers();
        byte[][][] values = put.getValues();
        int[] familyIds = new int[families.length];
        int nCells = 0;
        for (int i = 0; i < families.length; ++i) {
            String family = Bytes.toString(families[i]);
            try {
                familyIds[i] = mtable.getFamilyId(family);
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException("Invalid column family " + family, ioe);
            }
            nCells += qualifiers[i].length;
        }
        byte[][][] sortedQuals = new byte[nCells][][];
        byte[][][] sortedVals = new byte[nCells][][];
        if (nCells > 1) {
            for (int i = 0; i < families.length; ++i) {
                int cellsPerFamily = qualifiers[i].length;
                Integer[] cells = new Integer[cellsPerFamily];
                for (int j = 0; j < cellsPerFamily; ++j) {
                    cells[j] = j;
                }
                sortedQuals[i] = new byte[cellsPerFamily][];
                sortedVals[i] = new byte[cellsPerFamily][];
                final byte[][] quals = qualifiers[i];
                byte[][] vals = values[i];
                Comparator<Integer> cmp = new Comparator<Integer>(){

                    @Override
                    public int compare(Integer i, Integer j) {
                        return MapRConverter.compareTo(quals[i], 0, quals[i].length, quals[j], 0, quals[j].length);
                    }
                };
                Arrays.sort(cells, cmp);
                for (int j = 0; j < cellsPerFamily; ++j) {
                    int off = cells[j];
                    sortedQuals[i][j] = quals[off];
                    sortedVals[i][j] = vals[off];
                }
            }
            return new MapRPut(put.key(), familyIds, (byte[][][])sortedQuals, (byte[][][])sortedVals, put.timestamp(), put.getTimestamps(), (Object)put, (MapRCallBackQueue)cbq);
        }
        return new MapRPut(put.key(), familyIds, put.getQualifiers(), put.getValues(), put.timestamp(), put.getTimestamps(), (Object)put, (MapRCallBackQueue)cbq);
    }

    public static MapRPut toMapRPut(AppendRequest append, MapRHTable mtable) {
        byte[][] families = append.getFamilies();
        byte[][][] qualifiers = append.getQualifiers();
        byte[][][] values = append.getValues();
        int[] familyIds = new int[families.length];
        int nCells = 0;
        for (int i = 0; i < families.length; ++i) {
            String family = Bytes.toString(families[i]);
            try {
                familyIds[i] = mtable.getFamilyId(family);
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException("Invalid column family " + family, ioe);
            }
            nCells += qualifiers[i].length;
        }
        byte[][][] sortedQuals = new byte[nCells][][];
        byte[][][] sortedVals = new byte[nCells][][];
        if (nCells > 1) {
            for (int i = 0; i < families.length; ++i) {
                int cellsPerFamily = qualifiers[i].length;
                Integer[] cells = new Integer[cellsPerFamily];
                for (int j = 0; j < cellsPerFamily; ++j) {
                    cells[j] = j;
                }
                sortedQuals[i] = new byte[cellsPerFamily][];
                sortedVals[i] = new byte[cellsPerFamily][];
                final byte[][] quals = qualifiers[i];
                byte[][] vals = values[i];
                Comparator<Integer> cmp = new Comparator<Integer>(){

                    @Override
                    public int compare(Integer i, Integer j) {
                        return MapRConverter.compareTo(quals[i], 0, quals[i].length, quals[j], 0, quals[j].length);
                    }
                };
                Arrays.sort(cells, cmp);
                for (int j = 0; j < cellsPerFamily; ++j) {
                    int off = cells[j];
                    sortedQuals[i][j] = quals[off];
                    sortedVals[i][j] = vals[off];
                }
            }
            return new MapRPut(append.key(), familyIds, (byte[][][])sortedQuals, (byte[][][])sortedVals, append.timestamp(), null, (Object)append, null);
        }
        return new MapRPut(append.key(), familyIds, append.getQualifiers(), append.getValues(), append.timestamp(), null, (Object)append, null);
    }

    public static MapRPut toMapRPut(DeleteRequest drpc, MapRHTable mTable) {
        MapRPut mput;
        if (drpc.getFamilies() != DeleteRequest.WHOLE_ROW) {
            byte[][] families = drpc.getFamilies();
            int[] familyIds = new int[families.length];
            byte[][][] qualifiers = new byte[families.length][][];
            byte[][][] drpcQuals = drpc.getQualifiers();
            for (int i = 0; i < families.length; ++i) {
                String family = Bytes.toString(families[i]);
                try {
                    familyIds[i] = mTable.getFamilyId(family);
                }
                catch (IOException ioe) {
                    throw new IllegalArgumentException("Invalid column family " + family, ioe);
                }
                qualifiers[i] = drpcQuals == null || drpcQuals[i] == null ? DeleteRequest.DELETE_FAMILY_MARKER : drpcQuals[i];
            }
            mput = drpc.deleteAtTimestampOnly() ? new MapRPut(drpc.key(), familyIds, (byte[][][])qualifiers, null, drpc.timestamp(), null, 28) : new MapRPut(drpc.key(), familyIds, (byte[][][])qualifiers, null, drpc.timestamp(), null, 24);
        } else {
            mput = new MapRPut(drpc.key(), null, null, null, drpc.timestamp(), null, 18);
        }
        return mput;
    }

    public static MapRGet toMapRGet(GetRequest get, MapRHTable mtable) {
        try {
            MapRGet mrget = new MapRGet();
            mrget.key = get.key();
            mrget.result = new MapRResult();
            mrget.rowConstraint = MapRConverter.toRowConstraint(mtable, get.getFamilies(), get.getQualifiers(), get.getMinTimestamp(), get.getMaxTimestamp(), get.maxVersions());
            if (get.getFilterMsg() != null) {
                mrget.setFilter(get.getFilterMsg().toByteArray());
            }
            return mrget;
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Invalid column families " + get.getFamilies(), ioe);
        }
    }

    public static MapRRowConstraint toRowConstraint(MapRHTable htable, String family, byte[][] qualifier, int maxVers) throws IOException {
        MapRRowConstraint rc = new MapRRowConstraint();
        if (family != null) {
            int id = 0;
            try {
                id = htable.getFamilyId(family);
            }
            catch (IOException ioe) {
                throw new IOException("Invalid column family " + family, ioe);
            }
            rc.numFamilies = 1;
            rc.families = new int[rc.numFamilies];
            rc.families[0] = id;
            rc.columnsPerFamily = new int[rc.numFamilies];
        } else {
            rc.numFamilies = 0;
            rc.families = new int[rc.numFamilies];
            rc.columnsPerFamily = new int[rc.numFamilies];
        }
        if (qualifier != null) {
            rc.columns = new byte[qualifier.length][];
            rc.numColumns = qualifier.length;
            if (family != null) {
                rc.columnsPerFamily[0] = qualifier.length;
            }
            int i = 0;
            for (byte[] q : qualifier) {
                rc.columns[i] = q;
                ++i;
            }
        } else {
            rc.numColumns = 0;
            if (family != null) {
                rc.columnsPerFamily[0] = 0;
            }
        }
        rc.maxVersions = maxVers;
        rc.minStamp = -9223372036854775807L;
        rc.maxStamp = Long.MAX_VALUE;
        return rc;
    }

    public static ArrayList<KeyValue> toAsyncHBaseResult(MapRPut mput, byte[] key, MapRHTable htable) {
        if (mput == null || mput.getKeyValues().length == 0) {
            return new ArrayList<KeyValue>();
        }
        ArrayList<KeyValue> cells = new ArrayList<KeyValue>(mput.getKeyValues().length);
        int cellPos = 0;
        MapRKeyValue[] mKeyVals = mput.keyvals;
        for (int f = 0; f < mput.families.length; ++f) {
            String cfname;
            try {
                cfname = htable.getFamilyName(mput.families[f]);
            }
            catch (IOException ioe) {
                if (key != null) {
                    LOG.error("Stale column family id: " + mput.families[f]);
                    continue;
                }
                LOG.error("Stale column family id: " + mput.families[f] + ", during append");
                continue;
            }
            byte[] fname = cfname.getBytes();
            for (int i = 0; i < mput.cellsPerFamily[f]; ++i) {
                MapRKeyValue mKeyVal = mKeyVals[cellPos];
                byte[] qual = mKeyVal.getQualifier();
                byte[] val = mKeyVal.getValue();
                KeyValue kv = new KeyValue(key, fname, qual, mput.rowTimeStamp, val);
                cells.add(kv);
                ++cellPos;
            }
        }
        Collections.sort(cells, new Comparator<KeyValue>(){

            @Override
            public int compare(KeyValue kv1, KeyValue kv2) {
                return Bytes.memcmp(kv1.family(), kv2.family());
            }
        });
        return cells;
    }

    public static ArrayList<KeyValue> toAsyncHBaseResult(MapRResult mresult, byte[] key, MapRHTable htable) {
        if (mresult == null || mresult.getColumnOffsets() == null || mresult.getBufSize() == 0) {
            return new ArrayList<KeyValue>();
        }
        ArrayList<KeyValue> cells = new ArrayList<KeyValue>(mresult.getColumnOffsets().length);
        ByteBuffer bbuf = ByteBuffer.wrap(mresult.bufBytes);
        int columnPos = 0;
        int cellPos = 0;
        for (int f = 0; f < mresult.getCfids().length; ++f) {
            String cfname;
            try {
                cfname = htable.getFamilyName(mresult.getCfids()[f]);
            }
            catch (IOException ioe) {
                if (key != null) {
                    LOG.error("Stale column family id: " + mresult.getCfids()[f] + ". Ignoring get request with key = " + Bytes.toString(key) + "]");
                    continue;
                }
                LOG.error("Stale column family id: " + mresult.getCfids()[f] + ", during scan");
                continue;
            }
            byte[] fname = cfname.getBytes();
            for (int i = 0; i < mresult.getCellsPerFamily()[f]; ++i) {
                int qualLen = mresult.getColumnLengths()[columnPos];
                byte[] qual = ZERO_BYTE_ARRAY;
                if (qualLen != 0) {
                    qual = new byte[qualLen];
                    bbuf.position(mresult.getColumnOffsets()[columnPos]);
                    bbuf.get(qual, 0, qualLen);
                }
                for (int v = 0; v < mresult.versions()[columnPos]; ++v) {
                    int valueLen = mresult.getValueLengths()[cellPos];
                    byte[] val = new byte[valueLen];
                    bbuf.position(mresult.getValueOffsets()[cellPos]);
                    bbuf.get(val, 0, valueLen);
                    KeyValue kv = new KeyValue(key, fname, qual, mresult.getTimeStamps()[cellPos], val);
                    cells.add(kv);
                    ++cellPos;
                }
                ++columnPos;
            }
        }
        Collections.sort(cells, new Comparator<KeyValue>(){

            @Override
            public int compare(KeyValue kv1, KeyValue kv2) {
                return Bytes.memcmp(kv1.family(), kv2.family());
            }
        });
        return cells;
    }

    public static MapRScan toMapRScan(Scanner scan, MapRHTable mtable) throws IOException {
        MapRScan maprscan = new MapRScan();
        maprscan.startRow = scan.getCurrentKey();
        maprscan.stopRow = scan.getStopKey();
        maprscan.rowConstraint = MapRConverter.toRowConstraint(mtable, scan.getFamilies(), scan.getQualifiers(), scan.getMinTimestamp(), scan.getMaxTimestamp(), scan.getMaxVersions());
        return maprscan;
    }

    public static MapRRowConstraint toRowConstraint(MapRHTable mtable, byte[][] families, byte[][][] qualifiers, long minTimeStamp, long maxTimeStamp, int maxVers) throws IOException {
        MapRRowConstraint rc = new MapRRowConstraint();
        if (families != null) {
            rc.numFamilies = families.length;
            rc.families = new int[rc.numFamilies];
            rc.columnsPerFamily = new int[rc.numFamilies];
            rc.numColumns = 0;
            for (int i = 0; i < families.length; ++i) {
                try {
                    rc.families[i] = mtable.getFamilyId(Bytes.toString(families[i]));
                }
                catch (IOException ioe) {
                    throw new IOException("Invalid columns family " + families[i], ioe);
                }
                rc.columnsPerFamily[i] = qualifiers != null && qualifiers[i] != null ? qualifiers[i].length : 0;
                rc.numColumns += rc.columnsPerFamily[i];
            }
            if (qualifiers != null) {
                rc.columns = new byte[rc.numColumns][];
                int k = 0;
                for (int i = 0; i < qualifiers.length; ++i) {
                    for (int j = 0; qualifiers[i] != null && j < qualifiers[i].length; ++j) {
                        rc.columns[k] = qualifiers[i][j];
                        ++k;
                    }
                }
            } else {
                rc.columns = null;
            }
        } else {
            rc.numFamilies = 0;
            rc.families = null;
            rc.columnsPerFamily = null;
            rc.numColumns = 0;
        }
        rc.maxVersions = maxVers;
        rc.minStamp = minTimeStamp;
        rc.maxStamp = maxTimeStamp;
        return rc;
    }

    public static MapRIncrement toMapRIncrement(byte[] key, byte[] family, byte[] qualifier, long delta, MapRHTable mtable) throws IOException {
        MapRIncrement mincr = new MapRIncrement();
        mincr.key = key;
        mincr.rowConstraint = MapRConverter.toRowConstraint(mtable, Bytes.toString(family), new byte[][]{qualifier}, 1);
        mincr.deltas = new long[1];
        mincr.deltas[0] = delta;
        return mincr;
    }
}

